/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import java.awt.Color;

public class ColorUtil {
    private ColorUtil() {
    }

    public static Color brighter(Color color) {
        return ColorUtil.brighter(color, 0.05f);
    }

    public static Color brighter(Color color, float factor) {
        if (factor < 0.0f || factor > 1.0f) {
            return color;
        }
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        hsbvals[2] = hsbvals[2] + factor;
        if (hsbvals[2] > 1.0f) {
            hsbvals[2] = 1.0f;
        }
        return new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]));
    }

    public static Color setSaturation(Color color, float saturation) {
        if (saturation < 0.0f || saturation > 1.0f) {
            return color;
        }
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        hsbvals[1] = saturation;
        color = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]));
        return color;
    }

    public static Color setBrightness(Color color, float brightness) {
        if (brightness < 0.0f || brightness > 1.0f) {
            return color;
        }
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        hsbvals[2] = brightness;
        color = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]));
        return color;
    }
}

