/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.TabExitEvent;
import org.jmeld.ui.util.TabExitListenerIF;

public class TabIcon
implements Icon {
    private static int CLOSE_ICON_HEIGHT = 7;
    private static int CLOSE_ICON_WIDTH = 7;
    private static int SPACE_WIDTH = 5;
    private Icon icon;
    private String text;
    private int width;
    private int height;
    private JLabel label;
    private int stringWidth;
    private Rectangle closeBounds;
    private JTabbedPane tabbedPane;
    private Icon currentIcon;
    private Icon closeIcon;
    private Icon closeIcon_rollover;
    private Icon closeIcon_pressed;
    private Icon closeIcon_disabled;
    private boolean pressed;
    private boolean ignoreNextMousePressed;
    private ChangeListener changeListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private ArrayList<TabExitListenerIF> tabExitListeners;

    public TabIcon(Icon icon, String text) {
        this.icon = icon;
        this.text = text;
        this.init();
        this.tabExitListeners = new ArrayList();
    }

    private void init() {
        this.height = 0;
        this.width = 0;
        this.closeIcon = ImageUtil.getImageIcon("jmeld_close");
        this.closeIcon_rollover = ImageUtil.getImageIcon("jmeld_close-rollover");
        this.closeIcon_pressed = ImageUtil.getImageIcon("jmeld_close-pressed");
        this.closeIcon_disabled = ImageUtil.getImageIcon("jmeld_close-disabled");
        if (this.closeIcon != null) {
            CLOSE_ICON_WIDTH = this.closeIcon.getIconWidth();
            CLOSE_ICON_HEIGHT = this.closeIcon.getIconHeight();
        }
        if (this.icon != null) {
            this.height = this.height < this.icon.getIconHeight() ? this.icon.getIconHeight() : this.height;
            this.width += this.icon.getIconWidth();
        }
        if (this.text != null) {
            this.label = new JLabel(this.text);
            Font font = this.label.getFont();
            FontMetrics fm = this.label.getFontMetrics(font);
            this.height = this.height < fm.getHeight() ? fm.getHeight() : this.height;
            this.stringWidth = fm.stringWidth(this.text);
            this.width += this.stringWidth;
        }
        this.height = this.height < CLOSE_ICON_HEIGHT ? CLOSE_ICON_HEIGHT : this.height;
        this.width += CLOSE_ICON_WIDTH;
        if (this.icon != null) {
            this.width += SPACE_WIDTH;
        }
        if (this.text != null) {
            this.width += SPACE_WIDTH;
        }
    }

    public void addExitListener(TabExitListenerIF listener) {
        this.tabExitListeners.add(listener);
    }

    public void removeExitListener(TabExitListenerIF listener) {
        this.tabExitListeners.remove(listener);
    }

    public void exit() {
        this.tabbedPane.removeMouseListener(this.getMouseListener());
        this.tabbedPane.removeMouseMotionListener(this.getMouseMotionListener());
        this.tabbedPane.removeChangeListener(this.getChangeListener());
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int y0;
        int x0 = x;
        if (this.tabbedPane == null) {
            this.tabbedPane = (JTabbedPane)c;
            this.tabbedPane.addMouseListener(this.getMouseListener());
            this.tabbedPane.addMouseMotionListener(this.getMouseMotionListener());
            this.tabbedPane.addChangeListener(this.getChangeListener());
        }
        if (this.icon != null) {
            this.icon.paintIcon(c, g, x0, y + (this.height - this.icon.getIconHeight()) / 2);
            x0 += this.icon.getIconWidth();
            x0 += SPACE_WIDTH;
        }
        if (this.text != null) {
            FontMetrics fm = this.label.getFontMetrics(this.label.getFont());
            y0 = y + fm.getAscent() + (this.height - fm.getHeight()) / 2;
            g.setFont(this.label.getFont());
            g.drawString(this.text, x0, y0);
            x0 += this.stringWidth;
            x0 += SPACE_WIDTH;
        }
        y0 = y + (this.height - CLOSE_ICON_HEIGHT) / 2;
        if (this.closeIcon != null) {
            Icon cIcon = this.currentIcon;
            if (!this.isSelected()) {
                cIcon = this.closeIcon_disabled;
            }
            if (cIcon == null) {
                cIcon = this.closeIcon;
            }
            cIcon.paintIcon(c, g, x0, y0);
            this.closeBounds = new Rectangle(x0, y0, CLOSE_ICON_WIDTH, CLOSE_ICON_HEIGHT);
        } else {
            g.drawLine(x0, y0, x0 + CLOSE_ICON_HEIGHT, y0 + CLOSE_ICON_WIDTH);
            g.drawLine(x0 + CLOSE_ICON_HEIGHT, y0, x0, y0 + CLOSE_ICON_WIDTH);
            this.closeBounds = new Rectangle(x0, y0, CLOSE_ICON_WIDTH, CLOSE_ICON_HEIGHT);
        }
        x0 += CLOSE_ICON_WIDTH;
    }

    private MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                public void mousePressed(MouseEvent me) {
                    if (TabIcon.this.ignoreNextMousePressed) {
                        TabIcon.this.ignoreNextMousePressed = false;
                        return;
                    }
                    if (TabIcon.this.isCloseHit(me)) {
                        TabIcon.this.pressed = true;
                        Icon icon = TabIcon.this.closeIcon_pressed;
                        if (TabIcon.this.currentIcon != icon) {
                            TabIcon.this.currentIcon = icon;
                            TabIcon.this.tabbedPane.repaint();
                        }
                    } else {
                        TabIcon.this.pressed = false;
                    }
                }

                public void mouseReleased(MouseEvent me) {
                    if (TabIcon.this.pressed && TabIcon.this.isCloseHit(me)) {
                        int index = TabIcon.this.tabbedPane.indexOfTab(TabIcon.this);
                        if (index != TabIcon.this.tabbedPane.getSelectedIndex()) {
                            return;
                        }
                        if (index != -1) {
                            for (TabExitListenerIF listener : TabIcon.this.tabExitListeners) {
                                listener.doExit(new TabExitEvent(TabIcon.this, index));
                            }
                            me.consume();
                        }
                    }
                    if (TabIcon.this.currentIcon != TabIcon.this.closeIcon) {
                        TabIcon.this.currentIcon = TabIcon.this.closeIcon;
                        TabIcon.this.tabbedPane.repaint();
                    }
                }
            };
        }
        return this.mouseListener;
    }

    private MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent me) {
                    Icon icon;
                    if (TabIcon.this.isSelected()) {
                        TabIcon.this.ignoreNextMousePressed = false;
                    }
                    if (TabIcon.this.isCloseHit(me)) {
                        icon = TabIcon.this.closeIcon_rollover;
                    } else {
                        TabIcon.this.pressed = false;
                        icon = TabIcon.this.closeIcon;
                    }
                    if (icon != TabIcon.this.currentIcon) {
                        TabIcon.this.currentIcon = icon;
                        TabIcon.this.tabbedPane.repaint();
                    }
                }
            };
        }
        return this.mouseMotionListener;
    }

    private ChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    TabIcon.this.ignoreNextMousePressed = true;
                }
            };
        }
        return this.changeListener;
    }

    private boolean isCloseHit(MouseEvent me) {
        return !me.isConsumed() && this.closeBounds != null && this.closeBounds.contains(me.getX(), me.getY()) && this.isSelected();
    }

    private boolean isSelected() {
        int index = this.tabbedPane.indexOfTab(this);
        return index != -1 && this.tabbedPane.getSelectedIndex() == index;
    }
}

