/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbPersister {
    private static JaxbPersister instance = new JaxbPersister();
    private Map<Class, Context> contexts = new HashMap<Class, Context>();

    private JaxbPersister() {
    }

    public static JaxbPersister getInstance() {
        return instance;
    }

    public <T> T load(Class<T> clazz, File file) throws FileNotFoundException {
        return this.load(clazz, new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T load(Class<T> clazz, InputStream is) {
        try {
            Context context;
            Context context2 = context = this.getContext(clazz);
            synchronized (context2) {
                Object object = context.unmarshal(is);
                return (T)object;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void save(Object object, File file) throws JAXBException, IOException {
        this.save(object, new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object object, OutputStream os) throws JAXBException, IOException {
        Context context;
        OutputStreamWriter writer = new OutputStreamWriter(os);
        Context context2 = context = this.getContext(object.getClass());
        synchronized (context2) {
            context.marshal(object, writer);
        }
        os.close();
    }

    private ValidationEventHandler getValidationEventHandler() {
        return new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                ValidationEventLocator locator = event.getLocator();
                System.out.println("Line " + locator.getLineNumber() + ": " + event.getMessage());
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(Class clazz) {
        Context c;
        Map<Class, Context> map = this.contexts;
        synchronized (map) {
            c = this.contexts.get(clazz);
            if (c == null) {
                c = new Context(clazz);
                this.contexts.put(clazz, c);
            }
        }
        return c;
    }

    class Context {
        private JAXBContext jaxbContext;
        private Marshaller marshaller;
        private Unmarshaller unmarshaller;

        Context(Class clazz) {
            try {
                this.jaxbContext = JAXBContext.newInstance(clazz);
                this.marshaller = this.jaxbContext.createMarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                this.marshaller.setEventHandler(JaxbPersister.this.getValidationEventHandler());
                this.unmarshaller = this.jaxbContext.createUnmarshaller();
                this.unmarshaller.setEventHandler(JaxbPersister.this.getValidationEventHandler());
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }

        public void marshal(Object object, Writer writer) throws JAXBException {
            this.marshaller.marshal(object, writer);
        }

        public Object unmarshal(InputStream is) throws JAXBException {
            return this.unmarshaller.unmarshal(is);
        }
    }
}

