/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.jmeld.util.conf.AbstractConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPersister {
    private static ConfigurationPersister instance = new ConfigurationPersister();
    private Map<Class, Context> contexts = new HashMap<Class, Context>();

    private ConfigurationPersister() {
    }

    public static ConfigurationPersister getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractConfiguration> T load(Class<T> clazz, File file) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(file);
        try {
            Context context;
            Context context2 = context = this.getContext(clazz);
            synchronized (context2) {
                AbstractConfiguration configuration = (AbstractConfiguration)context.unmarshal(is);
                configuration.init();
                return (T)configuration;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void save(AbstractConfiguration configuration, File file) throws JAXBException, IOException {
        this.save(configuration, new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(AbstractConfiguration configuration, OutputStream os) throws JAXBException, IOException {
        Context context;
        OutputStreamWriter writer = new OutputStreamWriter(os);
        Context context2 = context = this.getContext(configuration.getClass());
        synchronized (context2) {
            context.marshal(configuration, writer);
        }
        os.close();
    }

    private ValidationEventHandler getValidationEventHandler() {
        return new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                ValidationEventLocator locator = event.getLocator();
                System.out.println(locator.getLineNumber() + ": " + event.getMessage());
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(Class clazz) {
        Context c;
        Map<Class, Context> map = this.contexts;
        synchronized (map) {
            c = this.contexts.get(clazz);
            if (c == null) {
                c = new Context(clazz);
                this.contexts.put(clazz, c);
            }
        }
        return c;
    }

    class Context {
        private JAXBContext jaxbContext;
        private Marshaller marshaller;
        private Unmarshaller unmarshaller;

        Context(Class clazz) {
            try {
                this.jaxbContext = JAXBContext.newInstance(clazz);
                this.marshaller = this.jaxbContext.createMarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                this.marshaller.setEventHandler(ConfigurationPersister.this.getValidationEventHandler());
                this.unmarshaller = this.jaxbContext.createUnmarshaller();
                this.unmarshaller.setEventHandler(ConfigurationPersister.this.getValidationEventHandler());
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }

        public void marshal(Object configuration, Writer writer) throws JAXBException {
            this.marshaller.marshal(configuration, writer);
        }

        public Object unmarshal(InputStream is) throws JAXBException {
            return this.unmarshaller.unmarshal(is);
        }
    }
}

