/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.jmeld.util.Ignore;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.FileNode;

public class CompareUtil {
    private CompareUtil() {
    }

    public static boolean contentEquals(BufferNode nodeLeft, BufferNode nodeRight, Ignore ignore) {
        if (nodeLeft instanceof FileNode && nodeRight instanceof FileNode) {
            return CompareUtil.contentEquals((FileNode)nodeLeft, (FileNode)nodeRight, ignore);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean contentEquals(FileNode nodeLeft, FileNode nodeRight, Ignore ignore) {
        RandomAccessFile fLeft = null;
        RandomAccessFile fRight = null;
        try {
            boolean equals;
            block38: {
                File fileLeft = nodeLeft.getFile();
                File fileRight = nodeRight.getFile();
                if (fileLeft.isDirectory() || fileRight.isDirectory()) {
                    boolean bl = true;
                    return bl;
                }
                if (!ignore.ignore && fileLeft.length() != fileRight.length()) {
                    boolean bl = false;
                    return bl;
                }
                if (!ignore.ignore) {
                    fLeft = new RandomAccessFile(fileLeft, "r");
                    fRight = new RandomAccessFile(fileRight, "r");
                    FileChannel fcLeft = fLeft.getChannel();
                    FileChannel fcRight = fRight.getChannel();
                    MappedByteBuffer bbLeft = fcLeft.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fcLeft.size());
                    MappedByteBuffer bbRight = fcRight.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fcRight.size());
                    equals = bbLeft.equals(bbRight);
                } else {
                    BufferedReader readerLeft = new BufferedReader(new FileReader(fileLeft));
                    BufferedReader readerRight = new BufferedReader(new FileReader(fileRight));
                    equals = false;
                    int leftChar = 0;
                    int rightChar = 0;
                    while (true) {
                        boolean leftFound = false;
                        while ((leftChar = readerLeft.read()) != -1) {
                            if (ignore.ignoreWhitespace && Character.isWhitespace(leftChar)) continue;
                            leftFound = true;
                            break;
                        }
                        boolean rightFound = false;
                        while ((rightChar = readerRight.read()) != -1) {
                            if (ignore.ignoreWhitespace && Character.isWhitespace(rightChar)) continue;
                            rightFound = true;
                            break;
                        }
                        if (leftFound && rightFound) {
                            if (leftChar == rightChar) continue;
                            equals = false;
                            break block38;
                        }
                        if (leftFound && !rightFound || !leftFound && rightFound) {
                            equals = false;
                            break block38;
                        }
                        if (!leftFound && !rightFound) break;
                    }
                    equals = true;
                }
            }
            boolean bl = equals;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fLeft != null) {
                    fLeft.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                if (fRight != null) {
                    fRight.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean contentEquals(char[] left, char[] right, Ignore ignore) {
        boolean equals;
        block7: {
            int leftIndex = 0;
            int rightIndex = 0;
            if (!ignore.ignore) {
                equals = Arrays.equals(left, right);
            } else {
                equals = false;
                char leftChar = '\u0000';
                char rightChar = '\u0000';
                while (true) {
                    boolean leftFound = false;
                    while (leftIndex < left.length) {
                        leftChar = left[leftIndex];
                        ++leftIndex;
                        if (ignore.ignoreWhitespace && Character.isWhitespace(leftChar)) continue;
                        leftFound = true;
                        break;
                    }
                    boolean rightFound = false;
                    while (rightIndex < right.length) {
                        rightChar = right[rightIndex];
                        ++rightIndex;
                        if (ignore.ignoreWhitespace && Character.isWhitespace(rightChar)) continue;
                        rightFound = true;
                        break;
                    }
                    if (leftFound && rightFound) {
                        if (leftChar == rightChar) continue;
                        equals = false;
                        break block7;
                    }
                    if (leftFound && !rightFound || !leftFound && rightFound) {
                        equals = false;
                        break block7;
                    }
                    if (!leftFound && !rightFound) break;
                }
                equals = true;
            }
        }
        return equals;
    }
}

