/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.node;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jmeld.ui.text.FileDocument;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.JMeldNode;

public class FileNode
extends JMeldNode
implements BufferNode {
    private File file;
    private FileDocument document;
    private boolean exists;

    public FileNode(String name, File file) {
        super(name, !file.isDirectory());
        this.file = file;
        this.initialize();
    }

    public File getFile() {
        return this.file;
    }

    public void resetContent() {
        this.document = null;
        this.initialize();
    }

    public boolean exists() {
        return this.exists;
    }

    public FileDocument getDocument() {
        if (this.document == null) {
            this.initialize();
            if (this.exists()) {
                this.document = new FileDocument(this.file);
            }
        }
        return this.document;
    }

    public long getSize() {
        return this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(JMeldNode node) {
        RandomAccessFile f1 = null;
        RandomAccessFile f2 = null;
        try {
            boolean equals;
            if (!(node instanceof FileNode)) {
                boolean bl = false;
                return bl;
            }
            File file2 = ((FileNode)node).getFile();
            if (this.file.isDirectory() || file2.isDirectory()) {
                boolean bl = true;
                return bl;
            }
            if (this.file.length() != file2.length()) {
                boolean bl = false;
                return bl;
            }
            f1 = new RandomAccessFile(this.file, "r");
            f2 = new RandomAccessFile(file2, "r");
            FileChannel fc1 = f1.getChannel();
            FileChannel fc2 = f2.getChannel();
            MappedByteBuffer bb1 = fc1.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc1.size());
            MappedByteBuffer bb2 = fc2.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc2.size());
            boolean bl = equals = bb1.equals(bb2);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (f1 != null) {
                    f1.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                if (f2 != null) {
                    f2.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initialize() {
        this.exists = this.file.exists();
    }
}

