/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jmeld.JMeldException;
import org.jmeld.diff.JMDiff;
import org.jmeld.diff.JMRevision;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.StatusBar;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.util.Ignore;
import org.jmeld.util.file.CompareUtil;
import org.jmeld.util.file.cmd.AbstractCmd;
import org.jmeld.util.file.cmd.CopyFileCmd;
import org.jmeld.util.file.cmd.RemoveFileCmd;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.FileNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMDiffNode
implements TreeNode {
    private String text;
    private String name;
    private String shortName;
    private String parentName;
    private JMDiffNode parent;
    private List<JMDiffNode> children;
    private BufferNode nodeLeft;
    private BufferNode nodeRight;
    private boolean leaf;
    private Compare compareState;
    private JMDiff diff;
    private JMRevision revision;

    public JMDiffNode(String name, boolean leaf) {
        this.name = name;
        this.shortName = name;
        this.leaf = leaf;
        this.children = new ArrayList<JMDiffNode>();
        this.calculateNames();
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void addChild(JMDiffNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    private void setParent(JMDiffNode parent) {
        this.parent = parent;
    }

    public void setBufferNodeLeft(BufferNode bufferNode) {
        this.nodeLeft = bufferNode;
    }

    public BufferNode getBufferNodeLeft() {
        return this.nodeLeft;
    }

    public void setBufferNodeRight(BufferNode bufferNode) {
        this.nodeRight = bufferNode;
    }

    public BufferNode getBufferNodeRight() {
        return this.nodeRight;
    }

    public List<JMDiffNode> getChildren() {
        return this.children;
    }

    public Enumeration<JMDiffNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isLeaf();
    }

    @Override
    public JMDiffNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public JMDiffNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    private void calculateNames() {
        int index = this.name.lastIndexOf("/");
        if (index == -1) {
            this.parentName = null;
            return;
        }
        this.parentName = this.name.substring(0, index);
        this.shortName = this.name.substring(index + 1);
    }

    public AbstractCmd getCopyToRightCmd() throws Exception {
        if (this.nodeLeft.exists() && this.nodeLeft instanceof FileNode && this.nodeRight instanceof FileNode) {
            return new CopyFileCmd(this, (FileNode)this.nodeLeft, (FileNode)this.nodeRight);
        }
        return null;
    }

    public AbstractCmd getCopyToLeftCmd() throws Exception {
        if (this.nodeRight.exists() && this.nodeLeft instanceof FileNode && this.nodeRight instanceof FileNode) {
            return new CopyFileCmd(this, (FileNode)this.nodeRight, (FileNode)this.nodeLeft);
        }
        return null;
    }

    public AbstractCmd getRemoveLeftCmd() throws Exception {
        if (this.nodeLeft instanceof FileNode) {
            return new RemoveFileCmd(this, (FileNode)this.nodeLeft);
        }
        return null;
    }

    public AbstractCmd getRemoveRightCmd() throws Exception {
        if (this.nodeRight instanceof FileNode) {
            return new RemoveFileCmd(this, (FileNode)this.nodeRight);
        }
        return null;
    }

    public void compareContents() {
        if (!this.nodeLeft.exists() && !this.nodeRight.exists()) {
            this.compareState = Compare.BothMissing;
            return;
        }
        if (this.nodeLeft.exists() && !this.nodeRight.exists()) {
            this.compareState = Compare.RightMissing;
            return;
        }
        if (!this.nodeLeft.exists() && this.nodeRight.exists()) {
            this.compareState = Compare.LeftMissing;
            return;
        }
        Ignore ignore = JMeldSettings.getInstance().getEditor().getIgnore();
        boolean equals = CompareUtil.contentEquals(this.nodeLeft, this.nodeRight, ignore);
        this.compareState = equals ? Compare.Equal : Compare.NotEqual;
    }

    public void diff() throws JMeldException {
        StatusBar.getInstance().start();
        BufferDocumentIF documentLeft = null;
        BufferDocumentIF documentRight = null;
        if (this.nodeLeft != null) {
            documentLeft = this.nodeLeft.getDocument();
            StatusBar.getInstance().setState("Reading left : %s", this.nodeLeft.getName());
            documentLeft.read();
        }
        if (this.nodeRight != null) {
            documentRight = this.nodeRight.getDocument();
            StatusBar.getInstance().setState("Reading right: %s", this.nodeRight.getName());
            documentRight.read();
        }
        StatusBar.getInstance().setState("Calculating differences", new Object[0]);
        this.diff = new JMDiff();
        this.revision = this.diff.diff(documentLeft == null ? null : documentLeft.getLines(), documentRight == null ? null : documentRight.getLines());
        StatusBar.getInstance().setState("Ready calculating differences", new Object[0]);
        StatusBar.getInstance().stop();
    }

    public JMDiff getDiff() {
        return this.diff;
    }

    public JMRevision getRevision() {
        return this.revision;
    }

    public boolean isCompareEqual(Compare state) {
        return this.compareState == state;
    }

    public void print(String indent) {
        System.out.println(indent + this.shortName + " (" + (Object)((Object)this.compareState) + ")");
        indent = indent + "  ";
        for (JMDiffNode node : this.children) {
            node.print(indent);
        }
    }

    public String toString() {
        if (this.text == null) {
            String pn;
            this.text = this.name;
            if (this.parent != null && this.name.startsWith(pn = this.parent.getName())) {
                this.text = this.name.substring(pn.length() + 1);
            }
        }
        return this.text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compare {
        Equal,
        NotEqual,
        RightMissing,
        LeftMissing,
        BothMissing;

    }
}

