/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.vc.svn;

import java.io.File;
import org.jmeld.util.Result;
import org.jmeld.util.vc.BlameIF;
import org.jmeld.util.vc.svn.BlameData;
import org.jmeld.util.vc.svn.SvnXmlCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlameCmd
extends SvnXmlCmd<BlameData> {
    private File file;

    public BlameCmd(File file) {
        this.file = file;
    }

    public Result execute() {
        return super.execute(BlameData.class, "svn", "blame", "--non-interactive", "--xml", this.file.getPath());
    }

    public BlameData getBlameData() {
        return (BlameData)this.getResultData();
    }

    public BlameIF getBlame() {
        return this.getBlameData();
    }

    public static void main(String[] args) {
        BlameCmd cmd = new BlameCmd(new File(args[0]));
        if (cmd.execute().isTrue()) {
            for (BlameData.Target target : cmd.getBlameData().getTargetList()) {
                for (BlameData.Entry entry : target.getEntryList()) {
                    System.out.println(entry.getLineNumber() + " : " + entry.getCommit().getRevision() + " -> " + entry.getCommit().getAuthor());
                }
            }
        } else {
            cmd.printError();
        }
    }
}

