/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.vc.svn;

import java.io.File;
import org.jmeld.util.Result;
import org.jmeld.util.vc.svn.StatusData;
import org.jmeld.util.vc.svn.SvnXmlCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCmd
extends SvnXmlCmd<StatusData> {
    private File file;

    public StatusCmd(File file) {
        this.file = file;
    }

    public Result execute() {
        return super.execute(StatusData.class, "svn", "status", "--non-interactive", "-v", "--xml", this.file.getPath());
    }

    public StatusData getStatusData() {
        return (StatusData)this.getResultData();
    }

    public static void main(String[] args) {
        StatusCmd cmd = new StatusCmd(new File(args[0]));
        if (cmd.execute().isTrue()) {
            for (StatusData.Target target : cmd.getStatusData().getTargetList()) {
                for (StatusData.Entry entry : target.getEntryList()) {
                    StatusData.WcStatus wcStatus = entry.getWcStatus();
                    if (wcStatus.getItem() == StatusData.ItemStatus.normal) continue;
                    System.out.println(wcStatus.getItem().getShortText() + " " + entry.getPath());
                }
            }
        } else {
            cmd.printError();
        }
    }
}

