/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.vc.svn;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.jmeld.util.JaxbPersister;
import org.jmeld.util.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnXmlCmd<T> {
    private T resultData;
    private Result result;

    public Result execute(Class<T> clazz, String ... command) {
        this.result = this._execute(clazz, command);
        return this.result;
    }

    private Result _execute(Class<T> clazz, String ... command) {
        try {
            int c;
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            System.out.println("execute: " + Arrays.asList(command));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = br.read()) != -1) {
                baos.write(c);
            }
            br.close();
            p.waitFor();
            if (p.exitValue() != 0) {
                String text;
                StringBuilder errorText = new StringBuilder();
                br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((text = br.readLine()) != null) {
                    errorText.append(text);
                }
                br.close();
                return Result.FALSE(errorText.toString());
            }
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            this.resultData = JaxbPersister.getInstance().load(clazz, is);
            baos = null;
        }
        catch (Exception ex) {
            this.result = Result.FALSE(ex.getMessage(), ex);
            Object baos = null;
            return this.result;
        }
        return Result.TRUE();
    }

    public void printError() {
        System.out.println(this.result.getDescription());
        if (this.result.hasException()) {
            this.result.getException().printStackTrace();
        }
    }

    public Result getResult() {
        return this.result;
    }

    protected T getResultData() {
        return this.resultData;
    }
}

