/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.diff.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HuntDiff {
    private HuntDiff() {
    }

    public static Difference[] diff(Object[] lines1, Object[] lines2) {
        int m = lines1.length;
        int n = lines2.length;
        Object[] lines1_original = lines1;
        Object[] lines2_original = lines2;
        Line[] l2s = new Line[n + 1];
        for (int i = 1; i <= n; ++i) {
            l2s[i] = new Line(i, lines2[i - 1]);
        }
        Arrays.sort(l2s, 1, n + 1, new Comparator<Line>(){

            @Override
            public int compare(Line l1, Line l2) {
                return l1.line.compareTo(l2.line);
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        int[] equvalenceLines = new int[n + 1];
        boolean[] equivalence = new boolean[n + 1];
        for (int i = 1; i <= n; ++i) {
            Line l = l2s[i];
            equvalenceLines[i] = l.lineNo;
            equivalence[i] = i == n || !l.line.equals(l2s[i + 1].line);
        }
        equvalenceLines[0] = 0;
        equivalence[0] = true;
        int[] equivalenceAssoc = new int[m + 1];
        for (int i = 1; i <= m; ++i) {
            equivalenceAssoc[i] = HuntDiff.findAssoc((Comparable)lines1[i - 1], l2s, equivalence);
        }
        l2s = null;
        Candidate[] K = new Candidate[Math.min(m, n) + 2];
        K[0] = new Candidate(0, 0, null);
        K[1] = new Candidate(m + 1, n + 1, null);
        int k = 0;
        for (int i = 1; i <= m; ++i) {
            if (equivalenceAssoc[i] == 0) continue;
            k = HuntDiff.merge(K, k, i, equvalenceLines, equivalence, equivalenceAssoc[i]);
        }
        int[] J = new int[m + 2];
        Candidate c = K[k];
        while (c != null) {
            J[((Candidate)c).a] = c.b;
            c = c.c;
        }
        List<Difference> differences = HuntDiff.getDifferences(J, lines1_original, lines2_original);
        HuntDiff.cleanup(differences);
        return differences.toArray(new Difference[0]);
    }

    private static int findAssoc(Comparable line1, Line[] l2s, boolean[] equivalence) {
        int idx = HuntDiff.binarySearch(l2s, line1, 1, l2s.length - 1);
        if (idx < 1) {
            return 0;
        }
        int lastGoodIdx = 0;
        while (idx >= 1 && l2s[idx].line.equals(line1)) {
            if (equivalence[idx - 1]) {
                lastGoodIdx = idx;
            }
            --idx;
        }
        return lastGoodIdx;
    }

    private static int binarySearch(Line[] L, Comparable key, int low, int high) {
        while (low <= high) {
            int mid = low + high >> 1;
            Comparable midVal = L[mid].line;
            int comparison = midVal.compareTo(key);
            if (comparison < 0) {
                low = mid + 1;
                continue;
            }
            if (comparison > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch(Candidate[] K, int key, int low, int high) {
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = K[mid].b;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int merge(Candidate[] K, int k, int i, int[] equvalenceLines, boolean[] equivalence, int p) {
        int r = 0;
        Candidate c = K[0];
        while (true) {
            int j;
            int s;
            if ((s = HuntDiff.binarySearch(K, j = equvalenceLines[p], r, k)) >= 0) {
                s = k + 1;
            } else if ((s = -s - 2) < r || s > k) {
                s = k + 1;
            }
            if (s <= k) {
                if (K[s + 1].b > j) {
                    Candidate newc = new Candidate(i, j, K[s]);
                    K[r] = c;
                    r = s + 1;
                    c = newc;
                }
                if (s == k) {
                    K[k + 2] = K[k + 1];
                    ++k;
                    break;
                }
            }
            if (equivalence[p]) break;
            ++p;
        }
        K[r] = c;
        return k;
    }

    private static List<Difference> getDifferences(int[] J, Object[] lines1, Object[] lines2) {
        AbstractStringBuilder addedText;
        int end2;
        ArrayList<Difference> differences = new ArrayList<Difference>();
        int n = lines1.length;
        int m = lines2.length;
        int start1 = 1;
        int start2 = 1;
        while (true) {
            if (start1 <= n && J[start1] == start2) {
                ++start1;
                ++start2;
                continue;
            }
            if (start1 > n) break;
            if (J[start1] < start2) {
                int end1;
                StringBuffer deletedText = new StringBuffer();
                deletedText.append(lines1[start1 - 1]).append('\n');
                for (end1 = start1 + 1; end1 <= n && J[end1] < start2; ++end1) {
                    Object line = lines1[end1 - 1];
                    deletedText.append(line).append('\n');
                }
                differences.add(new Difference(0, start1, end1 - 1, start2 - 1, 0, deletedText.toString(), null));
                start1 = end1;
            } else {
                end2 = J[start1];
                addedText = new StringBuffer();
                for (int i = start2; i < end2; ++i) {
                    Object line = lines2[i - 1];
                    ((StringBuffer)addedText).append(line).append('\n');
                }
                differences.add(new Difference(1, start1 - 1, 0, start2, end2 - 1, null, ((StringBuffer)addedText).toString()));
                start2 = end2;
            }
            if (start1 > n) break;
        }
        if (start2 <= m) {
            addedText = new StringBuilder();
            ((StringBuilder)addedText).append(lines2[start2 - 1]).append('\n');
            for (end2 = start2 + 1; end2 <= m; ++end2) {
                Object line = lines2[end2 - 1];
                ((StringBuilder)addedText).append(line).append('\n');
            }
            differences.add(new Difference(1, n, 0, start2, m, null, ((StringBuilder)addedText).toString()));
        }
        return differences;
    }

    private static void cleanup(List<Difference> diffs) {
        Difference last = null;
        for (int i = 0; i < diffs.size(); ++i) {
            Difference diff = diffs.get(i);
            if (last != null && (diff.getType() == 1 && last.getType() == 0 || diff.getType() == 0 && last.getType() == 1)) {
                Difference del;
                Difference add;
                if (1 == diff.getType()) {
                    add = diff;
                    del = last;
                } else {
                    add = last;
                    del = diff;
                }
                int d1f1l1 = add.getFirstStart() - (del.getFirstEnd() - del.getFirstStart());
                int d2f1l1 = del.getFirstStart();
                if (d1f1l1 == d2f1l1) {
                    Difference newDiff = new Difference(2, d1f1l1, del.getFirstEnd(), add.getSecondStart(), add.getSecondEnd(), del.getFirstText(), add.getSecondText());
                    diffs.set(i - 1, newDiff);
                    diffs.remove(i);
                    --i;
                    diff = newDiff;
                }
            }
            last = diff;
        }
    }

    private static class Candidate {
        private int a;
        private int b;
        private Candidate c;

        public Candidate(int a, int b, Candidate c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    private static class Line {
        public int lineNo;
        public Comparable line;
        public int hash;

        public Line(int lineNo, Object line) {
            this.lineNo = lineNo;
            this.line = (Comparable)line;
            this.hash = line.hashCode();
        }
    }
}

