/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.dbf;

import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTable;
import pl.mpak.orbada.export.dbf.ExportToDbfDialog;
import pl.mpak.orbada.export.dbf.OrbadaExportDbfPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ExportToDbf
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportDbfPlugin.class);
    private String nullDataValue;
    private String fileName;
    private String charset;

    public ExportToDbf() {
        this.setText(this.stringManager.getString("ExportToDbf-text"));
        this.setActionCommandKey("ExportToDbf");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToDbf-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-dbf-file");
    }

    private void localConfig() {
        try {
            this.nullDataValue = this.getConfig().getValue("null-data-value").getString();
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void exportTable(JTable table) {
        File file = new File(this.fileName);
        if (file.exists()) {
            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("ExportToDbf-dbf-save"), (String)this.stringManager.getString("ExportToDbf-file-exists-rewrite-q"), (int[])ModalResult.YESNO, (int)3) == 6) {
                return;
            }
            file.delete();
        }
        try {
            DBFWriter writer = new DBFWriter(file);
            DBFField[] fields = new DBFField[table.getColumnCount()];
            for (int c = 0; c < table.getColumnCount(); ++c) {
                if (table.getColumnModel().getColumn(c) instanceof QueryTableColumn) {
                    QueryTableColumn column = (QueryTableColumn)table.getColumnModel().getColumn(c);
                    String fieldName = new String(column.getFieldName().getBytes(), this.charset);
                    fields[c] = new DBFField();
                    fields[c].setName(fieldName.substring(0, Math.min(10, fieldName.length())));
                    fields[c].setDataType((byte)67);
                    fields[c].setFieldLength(column.getField().getOptimalSize());
                    continue;
                }
                String fieldName = new String(table.getColumnModel().getColumn(c).getHeaderValue().toString().getBytes(), this.charset);
                fields[c] = new DBFField();
                fields[c].setName(fieldName.substring(0, Math.min(10, fieldName.length())));
                fields[c].setDataType((byte)67);
                fields[c].setFieldLength(table.getColumnModel().getColumn(c).getWidth());
            }
            writer.setFields(fields);
            for (int r = 0; r < table.getRowCount(); ++r) {
                Object[] rowData = new Object[table.getColumnCount()];
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    Object o = table.getValueAt(r, c);
                    if (o != null) {
                        String s = o instanceof Variant ? ((Variant)o).getString() : o.toString();
                        rowData[c] = new String(s.getBytes(), this.charset);
                        continue;
                    }
                    rowData[c] = new String(this.nullDataValue.getBytes(), this.charset);
                }
                writer.addRecord(rowData);
            }
            writer.write();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToDbf.this.getTable(event);
                if (table != null && ExportToDbfDialog.showDialog(ExportToDbf.this.getConfig())) {
                    ExportToDbf.this.localConfig();
                    ExportToDbf.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

