/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.wizard.WizardAttributes;
import pl.mpak.wizard.WizardListener;
import pl.mpak.wizard.WizardPanel;

public class Wizard
extends JPanel
implements Closeable {
    public static final String BACK_I18N = "BACK_I18N";
    public static final String NEXT_I18N = "NEXT_I18N";
    public static final String FINISH_I18N = "FINISH_I18N";
    public static final String CANCEL_I18N = "CANCEL_I18N";
    public static final String HELP_I18N = "HELP_I18N";
    public static final Dimension WIZARD_WINDOW_SIZE = new Dimension(650, 500);
    private WizardAttributes wizardAttributes;
    private Stack<WizardPanel> previous = null;
    private WizardPanel current = null;
    private EventListenerList wizardListenerList = new EventListenerList();
    private JButton backButton;
    private JButton cancelButton;
    private Action cmBack;
    private Action cmCancel;
    private Action cmFinish;
    private Action cmHelp;
    private Action cmNext;
    private JButton finishButton;
    private JButton helpButton;
    private JPanel jPanel1;
    private JButton nextButton;

    public Wizard() {
        this.wizardAttributes = new WizardAttributes();
        this.initComponents();
        this.init();
    }

    private void init() {
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.nextButton, this.backButton, this.finishButton, this.cancelButton, this.helpButton});
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Wizard.this.getRootPane().getInputMap(2).put(Wizard.this.cmCancel.getShortCut(), "cmCancel");
                Wizard.this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)Wizard.this.cmCancel);
            }
        });
    }

    public Wizard(Map i18N) {
        this();
        this.applyI18N(i18N);
    }

    public WizardAttributes getWizardAttributes() {
        return this.wizardAttributes;
    }

    private void applyI18N(Map i18N) {
        if (i18N.size() > 0) {
            this.cmNext.setText((String)i18N.get(NEXT_I18N));
            this.cmBack.setText((String)i18N.get(BACK_I18N));
            this.cmFinish.setText((String)i18N.get(FINISH_I18N));
            this.cmCancel.setText((String)i18N.get(CANCEL_I18N));
            this.cmHelp.setText((String)i18N.get(HELP_I18N));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWizardListener(WizardListener listener) {
        EventListenerList eventListenerList = this.wizardListenerList;
        synchronized (eventListenerList) {
            this.wizardListenerList.add(WizardListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWizardListener(WizardListener listener) {
        EventListenerList eventListenerList = this.wizardListenerList;
        synchronized (eventListenerList) {
            this.wizardListenerList.remove(WizardListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWizardListener(WizardEvent event) {
        EventListenerList eventListenerList = this.wizardListenerList;
        synchronized (eventListenerList) {
            WizardListener[] listeners = (WizardListener[])this.wizardListenerList.getListeners(WizardListener.class);
            block8: for (int i = 0; i < listeners.length; ++i) {
                switch (event) {
                    case FINISHED: {
                        listeners[i].wizardFinished(this);
                        continue block8;
                    }
                    case CANCELLED: {
                        listeners[i].wizardCancelled(this);
                        continue block8;
                    }
                    case PANEL_CHANGE: {
                        listeners[i].wizardPanelChanged(this);
                    }
                }
            }
        }
    }

    public void start(WizardPanel wp) {
        this.previous = new Stack();
        wp.setWizardAttributes(this.wizardAttributes);
        this.setPanel(wp);
        this.updateButtons();
    }

    private void setPanel(WizardPanel wp) {
        if (null != this.current) {
            this.remove(this.current);
        }
        this.current = wp;
        this.add((Component)this.current, "Center");
        this.fireWizardListener(WizardEvent.PANEL_CHANGE);
        this.setVisible(true);
        this.revalidate();
        this.updateUI();
        this.current.display();
        this.updateButtons();
    }

    private void updateButtons() {
        this.cmCancel.setEnabled(true);
        this.cmHelp.setEnabled(this.current.hasHelp());
        this.cmBack.setEnabled(this.previous.size() > 0);
        this.cmNext.setEnabled(this.current.hasNext());
        this.cmFinish.setEnabled(this.current.canFinish());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Wizard.this.cmFinish.isEnabled()) {
                    Wizard.this.getRootPane().setDefaultButton(Wizard.this.finishButton);
                } else if (Wizard.this.cmNext.isEnabled()) {
                    Wizard.this.getRootPane().setDefaultButton(Wizard.this.nextButton);
                } else if (Wizard.this.cmBack.isEnabled()) {
                    Wizard.this.getRootPane().setDefaultButton(Wizard.this.backButton);
                }
            }
        });
    }

    private void back() {
        WizardPanel wp = this.previous.pop();
        this.setPanel(wp);
    }

    private void next() {
        ArrayList list = new ArrayList();
        if (this.current.validateNext(list)) {
            this.previous.push(this.current);
            WizardPanel wp = this.current.next();
            if (null != wp) {
                wp.setWizardAttributes(this.wizardAttributes);
            }
            this.setPanel(wp);
        } else {
            this.showErrorMessages(list);
        }
    }

    private void finish() {
        ArrayList list = new ArrayList();
        if (this.current.validateFinish(list)) {
            this.current.finish();
            this.fireWizardListener(WizardEvent.FINISHED);
        } else {
            this.showErrorMessages(list);
        }
    }

    private void cancel() {
        this.fireWizardListener(WizardEvent.CANCELLED);
    }

    private void help() {
        this.current.help();
    }

    @Override
    public void close() throws IOException {
        if (this.previous.firstElement() != null) {
            ((WizardPanel)this.previous.firstElement()).close();
        }
    }

    private void showErrorMessages(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            sb.append(s + (iter.hasNext() ? "\n" : ""));
        }
        MessageBox.show((Component)this, (String)"B\u0142\u0105d", (String)sb.toString(), (int)1, (int)0);
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmFinish = new Action();
        this.cmNext = new Action();
        this.cmBack = new Action();
        this.cmHelp = new Action();
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.finishButton = new JButton();
        this.nextButton = new JButton();
        this.backButton = new JButton();
        this.helpButton = new JButton();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText("Anuluj");
        this.cmCancel.setTooltip("Pozwala opu\u015bci\u0107 kreatora");
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Wizard.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmFinish.setActionCommandKey("cmFinish");
        this.cmFinish.setText("Zako\u0144cz");
        this.cmFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Wizard.this.cmFinishActionPerformed(evt);
            }
        });
        this.cmNext.setActionCommandKey("cmNext");
        this.cmNext.setText("Dalej >");
        this.cmNext.setTooltip("Nast\u0119pna strona");
        this.cmNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Wizard.this.cmNextActionPerformed(evt);
            }
        });
        this.cmBack.setActionCommandKey("cmBack");
        this.cmBack.setText("< Wstecz");
        this.cmBack.setTooltip("Poprzednia strona");
        this.cmBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Wizard.this.cmBackActionPerformed(evt);
            }
        });
        this.cmHelp.setActionCommandKey("cmHelp");
        this.cmHelp.setShortCut(KeyStroke.getKeyStroke(112, 0));
        this.cmHelp.setText("Pomoc");
        this.cmHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Wizard.this.cmHelpActionPerformed(evt);
            }
        });
        this.setPreferredSize(WIZARD_WINDOW_SIZE);
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.jPanel1.setPreferredSize(new Dimension(0, 45));
        this.cancelButton.setAction((javax.swing.Action)this.cmCancel);
        this.cancelButton.setMargin(new Insets(2, 2, 2, 2));
        this.cancelButton.setPreferredSize(new Dimension(85, 25));
        this.finishButton.setAction((javax.swing.Action)this.cmFinish);
        this.finishButton.setMargin(new Insets(2, 2, 2, 2));
        this.finishButton.setPreferredSize(new Dimension(85, 25));
        this.nextButton.setAction((javax.swing.Action)this.cmNext);
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.setPreferredSize(new Dimension(85, 25));
        this.backButton.setAction((javax.swing.Action)this.cmBack);
        this.backButton.setMargin(new Insets(2, 2, 2, 2));
        this.backButton.setPreferredSize(new Dimension(85, 25));
        this.helpButton.setAction((javax.swing.Action)this.cmHelp);
        this.helpButton.setMargin(new Insets(2, 2, 2, 2));
        this.helpButton.setPreferredSize(new Dimension(85, 25));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Wizard.this.helpButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.helpButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 124, Short.MAX_VALUE).addComponent(this.backButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.finishButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.finishButton, -2, -1, -2).addComponent(this.nextButton, -2, -1, -2).addComponent(this.backButton, -2, -1, -2).addComponent(this.helpButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "South");
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        this.help();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void cmFinishActionPerformed(ActionEvent evt) {
        this.finish();
    }

    private void cmNextActionPerformed(ActionEvent evt) {
        this.next();
    }

    private void cmBackActionPerformed(ActionEvent evt) {
        this.back();
    }

    private void cmHelpActionPerformed(ActionEvent evt) {
        this.help();
    }

    public static enum WizardEvent {
        FINISHED,
        CANCELLED,
        PANEL_CHANGE;

    }
}

