/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal;

import java.io.File;
import java.util.List;
import pl.mpak.orbada.db.OrbadaDatabase;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.universal.services.DatabaseInfoView;
import pl.mpak.orbada.universal.services.SqlQueryView;
import pl.mpak.orbada.universal.services.UniversalDatabaseProvider;
import pl.mpak.orbada.universal.services.UniversalPerspectiveProvider;
import pl.mpak.orbada.universal.services.UniversalPerspectiveSettingsProvider;
import pl.mpak.orbada.universal.services.UniversalProceduresView;
import pl.mpak.orbada.universal.services.UniversalSessionSettingsProvider;
import pl.mpak.orbada.universal.services.UniversalSettingsProvider;
import pl.mpak.orbada.universal.services.UniversalSqlTextTransformProvider;
import pl.mpak.orbada.universal.services.UniversalTablesView;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaUniversalPlugin
extends OrbadaPlugin {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    public static final String version = new VersionID(1, 2, 0, 53).toString();
    public static final String universalGroupName = stringManager.getString("universal-group-name");
    public static final TimerQueue refreshQueue = TimerManager.getTimer((String)"orbada-universal-refresh");
    public static final String universalSettingsRefresh = "universal-sql-query-settings-refresh";

    public String getInternalName() {
        return "OrbadaUniversalPlugin";
    }

    public String getDescriptiveName() {
        return String.format(stringManager.getString("OrbadaUniversalPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,Universal";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return version;
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-universal-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        block31: {
            OrbadaDatabase database = (OrbadaDatabase)this.application.getOrbadaDatabase();
            if (this.application.isUserAdmin()) {
                Query query = database.createQuery();
                try {
                    if (this.getLastVersion() == null) {
                        try {
                            database.executeCommand("create table execmds (\n  cmd_file_id varchar(40) not null,\n  cmd_crc32 numeric(10) not null,\n  cmd_usr_id varchar(40) not null,\n  cmd_executed timestamp,\n  cmd_selected timestamp,\n  cmd_source " + this.application.getProperty("data.type.clob", "CLOB") + ",\n" + "  cmd_sch_id varchar(40),\n" + "  cmd_executed_count integer\n" + ")");
                            database.executeCommandNoException("alter table execmds add constraint execmds_pk primary key (cmd_file_id)");
                            database.executeCommandNoException("alter table execmds add constraint execmd_user_fk foreign key (cmd_usr_id) references users (usr_id) on delete cascade");
                            database.executeCommand("create index execmds_selected_i on execmds(cmd_usr_id, cmd_sch_id, cmd_selected)");
                            database.executeCommandNoException("alter table execmds add constraint execmd_schema_fk foreign key (cmd_sch_id) references schemas (sch_id) on delete cascade");
                        }
                        catch (Exception ex2) {
                            ExceptionUtil.processException((Throwable)ex2);
                        }
                        try {
                            database.executeCommand("create table sqlparams (\n  sqlp_sch_id varchar(40),\n  sqlp_name varchar(100) not null,\n  sqlp_type varchar(50) not null,\n  sqlp_mode varchar(10),\n  sqlp_value varchar(1000)\n)");
                            database.executeCommandNoException("alter table sqlparams add constraint sqlparams_schema_fk foreign key (sqlp_sch_id) references schemas(sch_id) on delete cascade");
                            database.executeCommand("create unique index sqlparams_schema_name_ui on sqlparams (sqlp_sch_id, sqlp_name)");
                        }
                        catch (Exception ex2) {
                            ExceptionUtil.processException((Throwable)ex2);
                        }
                        break block31;
                    }
                    if (new VersionID(this.getLastVersion()).getBuild() < 2) {
                        try {
                            database.executeCommandNoException("alter table execmds drop constraint execmds_pk");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            database.executeCommandNoException("alter table execmds add constraint execmds_pk primary key (cmd_file_id)");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            database.executeCommand("drop index execmds_selected_i");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            database.executeCommand("create index execmds_selected_i on execmds(cmd_usr_id, cmd_sch_id, cmd_selected)");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            database.executeCommandNoException("alter table execmds add constraint execmd_schema_fk foreign key (cmd_sch_id) references schemas (sch_id) on delete cascade");
                        }
                        catch (Exception ex) {}
                        break block31;
                    }
                    if (new VersionID(this.getLastVersion()).getBuild() < 3) {
                        try {
                            database.executeCommand("alter table execmds add cmd_executed_count integer");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            database.executeCommand("update execmds set cmd_executed_count = 1");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            database.commit();
                        }
                        catch (Exception ex) {}
                        break block31;
                    }
                    if (new VersionID(this.getLastVersion()).getBuild() >= 4) break block31;
                    try {
                        database.executeCommand("alter table SQLPARAMS add sqlp_mode varchar(10)");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        database.executeCommand("update SQLPARAMS set sqlp_mode = 'IN'");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    query.close();
                }
            }
        }
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return new Class[]{SqlQueryView.class, DatabaseInfoView.class, UniversalTablesView.class, UniversalPerspectiveProvider.class, UniversalSqlTextTransformProvider.class, UniversalSettingsProvider.class, UniversalPerspectiveSettingsProvider.class, UniversalDatabaseProvider.class, UniversalSessionSettingsProvider.class, UniversalProceduresView.class};
    }

    public void processMessage(PluginMessage message) {
        File dir;
        if (message.isMessageId("schema-deleted") && (dir = new File(this.getApplication().getConfigPath() + "/sql-editor-contents/" + message.getObject().toString())).exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                file.delete();
            }
            dir.delete();
        }
    }
}

