/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.CommandParametersPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class CommandParametersDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private int modalResult = 0;
    private ParametrizedCommand command;
    private CommandParametersPanel panel;
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JPanel jPanel1;

    public CommandParametersDialog(ParametrizedCommand command) {
        super(SwingUtil.getRootFrame());
        this.command = command;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(final ParametrizedCommand command) {
        Boolean result = (Boolean)SwingUtil.invokeAndWait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                CommandParametersDialog dialog = new CommandParametersDialog(command);
                dialog.setVisible(true);
                return dialog.modalResult == 1;
            }
        });
        return result;
    }

    private void init() {
        this.getContentPane().add((Component)this.getPanel(), "Center");
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.pack();
        this.settings = Application.get().getSettings("orbada-command-parameter-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(800)).getInteger(), this.settings.getValue("height", new Variant(500)).getInteger());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.centerWithinScreen((Window)this);
        this.getPanel().setFocus();
    }

    private CommandParametersPanel getPanel() {
        if (this.panel == null) {
            this.panel = new CommandParametersPanel(this.command);
        }
        return this.panel;
    }

    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        try {
            this.getPanel().close();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jPanel1 = new JPanel();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandParametersDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandParametersDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle("Parametry polecenia SQL");
        this.setModal(true);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.jPanel1.add(this.buttonOk);
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jPanel1.add(this.buttonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }
}

