/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Parameter;
import pl.mpak.usedb.core.ParameterList;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.ParametersTableModel;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.Titleable;
import pl.mpak.util.task.Task;
import pl.mpak.util.variant.Variant;

public class CommandParametersPanel
extends JPanel
implements Closeable,
Titleable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private ParameterList parameterList;
    private String schemaId;
    private Query sqlParams;
    private JButton buttonOpenFile;
    private Action cmOpenFile;
    private JComboBox comboParamMode;
    private JComboBox comboParamType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private Table tableParameters;
    private JTextField textParamName;
    private TextField textParamValue;

    public CommandParametersPanel(ParametrizedCommand command) {
        this(command.getParameterList(), command.getDatabase().getUserProperties().getProperty("schemaId"));
    }

    public CommandParametersPanel(ParameterList parameterList, String schemaId) {
        this.parameterList = parameterList;
        this.schemaId = schemaId;
        this.initComponents();
        this.init();
    }

    public void updateParameters() {
        if (this.tableParameters.getSelectedRow() >= 0) {
            this.updateParameter(this.tableParameters.getSelectedRow());
        }
    }

    public void close() throws IOException {
        try {
            this.updateParameters();
            this.saveSqlParams();
            this.sqlParams.close();
        }
        catch (IndexOutOfBoundsException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public String getTitle() {
        return this.stringManager.getString("CommandParametersPanel-title");
    }

    private void init() {
        this.openSqlParams();
        TableRowChangeKeyListener trckl = new TableRowChangeKeyListener((JTable)this.tableParameters);
        this.textParamName.addKeyListener((KeyListener)trckl);
        this.textParamValue.addKeyListener((KeyListener)trckl);
        this.tableParameters.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int rowSelected = -1;

            public void valueChanged(ListSelectionEvent e) {
                if (this.rowSelected != -1) {
                    CommandParametersPanel.this.updateParameter(this.rowSelected);
                }
                this.rowSelected = CommandParametersPanel.this.tableParameters.getSelectedRow();
                if (this.rowSelected != -1) {
                    CommandParametersPanel.this.textParamName.setText(CommandParametersPanel.this.tableParameters.getValueAt(this.rowSelected, 0).toString());
                    CommandParametersPanel.this.comboParamType.setSelectedItem(CommandParametersPanel.this.tableParameters.getValueAt(this.rowSelected, 1).toString());
                    CommandParametersPanel.this.comboParamMode.setSelectedItem(CommandParametersPanel.this.tableParameters.getValueAt(this.rowSelected, 2).toString());
                    if (CommandParametersPanel.this.tableParameters.getValueAt(this.rowSelected, 3) != null) {
                        CommandParametersPanel.this.textParamValue.setText(CommandParametersPanel.this.tableParameters.getValueAt(this.rowSelected, 3).toString());
                    } else {
                        CommandParametersPanel.this.textParamValue.setText("");
                    }
                }
            }
        });
        this.tableParameters.setModel((TableModel)new ParametersTableModel(this.parameterList));
        ((ParametersTableModel)this.tableParameters.getModel()).configureTable((JTable)this.tableParameters);
        this.enableControls();
    }

    public void setFocus() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CommandParametersPanel.this.textParamValue.requestFocus();
            }
        });
    }

    private void openSqlParams() {
        Database database = InternalDatabase.get();
        this.sqlParams = database.createQuery();
        try {
            this.sqlParams.setFlushMode(Query.FlushMode.fmSynch);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.parameterList.parameterCount(); ++i) {
                Parameter p = this.parameterList.getParameter(i);
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append("'" + p.getParamName().toUpperCase() + "'");
            }
            this.sqlParams.setSqlText("select sqlp_name, sqlp_type, sqlp_mode, sqlp_value\n  from sqlparams\n where sqlp_sch_id " + (this.schemaId != null ? " = '" + this.schemaId + "'" : "is null") + "\n" + "   and sqlp_name in (" + sb.toString() + ")");
            this.sqlParams.open();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        if (this.sqlParams.isActive()) {
            for (int i = 0; i < this.parameterList.parameterCount(); ++i) {
                Parameter p = this.parameterList.getParameter(i);
                try {
                    if (!this.sqlParams.locate("sqlp_name", new Variant(p.getParamName().toUpperCase()))) continue;
                    p.setString(this.sqlParams.fieldByName("sqlp_value").getString());
                    p.setParamDataType(SQLUtil.stringToType((String)this.sqlParams.fieldByName("sqlp_type").getString()));
                    p.setParamMode(SQLUtil.stringToParamMode((String)this.sqlParams.fieldByName("sqlp_mode").getString()));
                    continue;
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
    }

    private void saveSqlParams() {
        if (this.sqlParams.isActive()) {
            for (int i = 0; i < this.parameterList.parameterCount(); ++i) {
                Parameter p = this.parameterList.getParameter(i);
                try {
                    if (this.sqlParams.locate("sqlp_name", new Variant(p.getParamName().toUpperCase()))) {
                        if (this.sqlParams.fieldByName("sqlp_type").getString().equals(SQLUtil.typeToString((int)p.getParamDataType())) && this.sqlParams.fieldByName("sqlp_mode").getString().equals(SQLUtil.paramModeToString((int)p.getParamMode())) && this.sqlParams.fieldByName("sqlp_value").getString().equals(p.getString())) continue;
                        InternalDatabase.get().getTaskPool().addTask((Task)new UpdateParamTask(this.schemaId, p.getParamName().toUpperCase(), SQLUtil.typeToString((int)p.getParamDataType()), SQLUtil.paramModeToString((int)p.getParamMode()), p.getString()));
                        continue;
                    }
                    InternalDatabase.get().getTaskPool().addTask((Task)new InsertParamTask(this.schemaId, p.getParamName().toUpperCase(), SQLUtil.typeToString((int)p.getParamDataType()), SQLUtil.paramModeToString((int)p.getParamMode()), p.getString()));
                    continue;
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
    }

    private void updateParameter(int row) {
        this.tableParameters.getModel().setValueAt(this.comboParamType.getSelectedItem(), row, 1);
        this.tableParameters.getModel().setValueAt(this.comboParamMode.getSelectedItem(), row, 2);
        this.tableParameters.getModel().setValueAt(this.textParamValue.getText(), row, 3);
    }

    private void enableControls() {
        this.buttonOpenFile.setVisible(StringUtil.equalAnyOfString((String)this.comboParamType.getSelectedItem().toString(), (String[])new String[]{"CLOB", "BLOB"}, (boolean)true));
    }

    private void initComponents() {
        this.cmOpenFile = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableParameters = new Table();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textParamName = new JTextField();
        this.jLabel2 = new JLabel();
        this.comboParamType = new JComboBox();
        this.jLabel4 = new JLabel();
        this.comboParamMode = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textParamValue = new TextField();
        this.buttonOpenFile = new JButton();
        this.cmOpenFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/open16.gif"));
        this.cmOpenFile.setText(this.stringManager.getString("cmOpenFile-text"));
        this.cmOpenFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandParametersPanel.this.cmOpenFileActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.tableParameters);
        this.jPanel1.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, new Color(0, 0, 0)));
        this.jLabel1.setText(this.stringManager.getString("parameter-name-dd"));
        this.textParamName.setEditable(false);
        this.jLabel2.setText(this.stringManager.getString("parameter-type-dd"));
        this.comboParamType.setModel(new DefaultComboBoxModel<String>(Parameter.paramTypesStr));
        this.comboParamType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CommandParametersPanel.this.comboParamTypeItemStateChanged(evt);
            }
        });
        this.jLabel4.setText(this.stringManager.getString("parameter-mode-dd"));
        this.comboParamMode.setModel(new DefaultComboBoxModel<String>(Parameter.paramModesStr));
        this.jLabel3.setText(this.stringManager.getString("parameter-value-dd"));
        this.buttonOpenFile.setAction((javax.swing.Action)this.cmOpenFile);
        this.buttonOpenFile.setHideActionText(true);
        this.buttonOpenFile.setPreferredSize(new Dimension(25, 25));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 250, Short.MAX_VALUE).addComponent(this.textParamName, -1, 250, Short.MAX_VALUE).addComponent(this.comboParamType, 0, 250, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 250, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 250, Short.MAX_VALUE).addComponent(this.comboParamMode, 0, 250, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 250, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.textParamValue, -1, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOpenFile, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textParamName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboParamType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboParamMode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonOpenFile, -2, 27, -2).addComponent((Component)this.textParamValue, -2, 22, -2)).addContainerGap(147, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 453, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 343, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void cmOpenFileActionPerformed(ActionEvent evt) {
        File file = FileUtil.selectFileToOpen((Component)this, (File)(StringUtil.isEmpty((String)this.textParamValue.getText()) ? null : new File(this.textParamValue.getText())), null);
        if (file != null) {
            this.textParamValue.setText(file.getAbsoluteFile().toString());
        }
    }

    private void comboParamTypeItemStateChanged(ItemEvent evt) {
        this.enableControls();
    }

    class InsertParamTask
    extends Task {
        private String schId;
        private String type;
        private String mode;
        private String name;
        private String value;

        public InsertParamTask(String schId, String name, String type, String mode, String value) {
            this.schId = schId;
            this.type = type;
            this.name = name;
            this.mode = mode;
            this.value = value;
        }

        public void run() {
            try {
                Command command = InternalDatabase.get().createCommand("insert into sqlparams (sqlp_sch_id, sqlp_name, sqlp_type, sqlp_mode, sqlp_value)\nvalues (" + (this.schId != null ? "'" + this.schId + "'" : "null") + ", :sqlp_name, :sqlp_type, :sqlp_mode, :sqlp_value)", false);
                command.paramByName("sqlp_type").setString(this.type);
                command.paramByName("sqlp_mode").setString(this.mode);
                command.paramByName("sqlp_value").setString(this.value);
                command.paramByName("sqlp_name").setString(this.name);
                command.execute();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    class UpdateParamTask
    extends Task {
        private String schId;
        private String type;
        private String mode;
        private String name;
        private String value;

        public UpdateParamTask(String schId, String name, String type, String mode, String value) {
            this.schId = schId;
            this.type = type;
            this.mode = mode;
            this.name = name;
            this.value = value;
        }

        public void run() {
            try {
                Command command = InternalDatabase.get().createCommand("update sqlparams\n   set sqlp_type = :sqlp_type,\n       sqlp_value = :sqlp_value,\n       sqlp_mode = :sqlp_mode\n where sqlp_sch_id " + (this.schId != null ? " = '" + this.schId + "'" : "is null") + "\n" + "   and sqlp_name = :sqlp_name", false);
                command.paramByName("sqlp_type").setString(this.type);
                command.paramByName("sqlp_mode").setString(this.mode);
                command.paramByName("sqlp_value").setString(this.value);
                command.paramByName("sqlp_name").setString(this.name);
                command.execute();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }
}

