/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pl.mpak.orbada.gui.comps.table.view.BeanPropertyPanel;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.ResultSetPanel;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.Titleable;

public class DatabaseInfoPanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IViewAccesibilities accesibilities;
    private JTabbedPane tabbedInfo;

    public DatabaseInfoPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.addBeanPanel(this.stringManager.getString("database"), this.getDatabase().getMetaData(), new String[]{"catalogs", "clientInfoProperties", "schemas", "tableTypes", "typeInfo"});
        this.addBeanPanel(this.stringManager.getString("driver"), this.getDatabase().getDriver(), null);
        try {
            this.addBeanPanel(this.stringManager.getString("connection"), this.getDatabase().getConnection(), null);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        try {
            this.addResultSetPanel(this.stringManager.getString("catalogs"), this.getDatabase().getMetaData().getCatalogs());
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        try {
            this.addResultSetPanel(this.stringManager.getString("schemas"), this.getDatabase().getMetaData().getSchemas());
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        try {
            this.addResultSetPanel(this.stringManager.getString("parameters"), this.getDatabase().getMetaData().getClientInfoProperties());
        }
        catch (AbstractMethodError ex) {
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        try {
            this.addResultSetPanel(this.stringManager.getString("table-types"), this.getDatabase().getMetaData().getTableTypes());
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        try {
            this.addResultSetPanel(this.stringManager.getString("data-types"), this.getDatabase().getMetaData().getTypeInfo());
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        DatabaseInfoProvider[] dip = (DatabaseInfoProvider[])this.accesibilities.getApplication().getServiceArray(DatabaseInfoProvider.class);
        if (dip != null && dip.length > 0) {
            for (int i = 0; i < dip.length; ++i) {
                if (!dip[i].isForDatabase(this.getDatabase())) continue;
                Component[] panels = dip[i].getExtendedPanelInfo(this.getDatabase());
                if (panels == null || panels.length <= 0) break;
                for (Component panel : panels) {
                    String title = this.stringManager.getString("no-name");
                    if (panel instanceof Titleable) {
                        title = ((Titleable)panel).getTitle();
                    }
                    this.addExtendedPanel(title, panel);
                }
                break;
            }
        }
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.tabbedInfo.getTabCount()) {
            Component c = this.tabbedInfo.getComponentAt(i);
            if (c instanceof Closeable) {
                try {
                    ((Closeable)((Object)c)).close();
                }
                catch (IOException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
                this.tabbedInfo.remove(c);
                continue;
            }
            ++i;
        }
    }

    private void addBeanPanel(String title, Object bean, String[] exclude) {
        BeanPropertyPanel panel = new BeanPropertyPanel(bean, exclude);
        this.tabbedInfo.addTab(title, (Component)panel);
        this.tabbedInfo.setTabComponentAt(this.tabbedInfo.indexOfComponent((Component)panel), (Component)new TabCloseComponent(title));
        this.tabbedInfo.setSelectedComponent((Component)panel);
    }

    private void addResultSetPanel(String title, ResultSet resultSet) throws Exception {
        ResultSetPanel panel = new ResultSetPanel(this.getDatabase(), resultSet);
        this.tabbedInfo.addTab(title, panel);
        this.tabbedInfo.setTabComponentAt(this.tabbedInfo.indexOfComponent(panel), (Component)new TabCloseComponent(title));
        this.tabbedInfo.setSelectedComponent(panel);
    }

    private void addExtendedPanel(String title, Component c) {
        this.tabbedInfo.addTab(title, c);
        this.tabbedInfo.setTabComponentAt(this.tabbedInfo.indexOfComponent(c), (Component)new TabCloseComponent(title));
        this.tabbedInfo.setSelectedComponent(c);
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.tabbedInfo = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedInfo, "Center");
    }
}

