/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.services.UniversalDatabaseProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class DatabaseSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IApplication application;
    private Database database;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private OrbadaSyntaxTextArea textAfterConnect;
    private OrbadaSyntaxTextArea textBeforeDisconnect;

    public DatabaseSettingsPanel(IApplication application, Database database) {
        this.application = application;
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.textAfterConnect.setDatabase(this.database);
        this.textBeforeDisconnect.setDatabase(this.database);
        this.restoreSettings();
    }

    public void restoreSettings() {
        if (UniversalDatabaseProvider.instance != null) {
            String script = UniversalDatabaseProvider.instance.readScript(this.database, true);
            this.textAfterConnect.setText(script != null ? script : "");
            script = UniversalDatabaseProvider.instance.readScript(this.database, false);
            this.textBeforeDisconnect.setText(script != null ? script : "");
        }
    }

    public void applySettings() {
        File file = new File(UniversalDatabaseProvider.instance.getFilePath());
        file.mkdirs();
        String script = this.textAfterConnect.getText();
        String fileName = UniversalDatabaseProvider.instance.getScriptFile(this.database, true);
        file = new File(fileName);
        if (!StringUtil.isEmpty((String)script)) {
            try {
                this.textAfterConnect.saveToFile(file);
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        } else if (file.exists()) {
            file.delete();
        }
        script = this.textBeforeDisconnect.getText();
        fileName = UniversalDatabaseProvider.instance.getScriptFile(this.database, false);
        file = new File(fileName);
        if (!StringUtil.isEmpty((String)script)) {
            try {
                this.textBeforeDisconnect.saveToFile(file);
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        } else if (file.exists()) {
            file.delete();
        }
    }

    public void cancelSettings() {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textAfterConnect = new OrbadaSyntaxTextArea();
        this.jLabel2 = new JLabel();
        this.textBeforeDisconnect = new OrbadaSyntaxTextArea();
        this.jLabel1.setText(this.stringManager.getString("DatabaseSettingsPanel-after-connect-dd"));
        this.jLabel2.setText(this.stringManager.getString("DatabaseSettingsPanel-before-disconnect-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.textBeforeDisconnect, GroupLayout.Alignment.LEADING, -1, 456, Short.MAX_VALUE).addComponent((Component)this.textAfterConnect, GroupLayout.Alignment.LEADING, -1, 456, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textAfterConnect, -1, 147, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textBeforeDisconnect, -1, 147, Short.MAX_VALUE).addContainerGap()));
    }
}

