/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.gui.webapp.RequestErrorDialog;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ErrorBox
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private Throwable exception;
    private String extInfo;
    private JButton buttonClose;
    private JButton buttonErrorRequest;
    private Action cmClose;
    private Action cmErrorRequest;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea textMessage;
    private JTextArea textStackTrace;

    public ErrorBox(Throwable exception) {
        this(exception, null);
    }

    public ErrorBox(Throwable exception, String extInfo) {
        this.exception = exception;
        this.initComponents();
        this.init();
    }

    public static void show(Throwable exception) {
        ErrorBox dialog = new ErrorBox(exception);
        dialog.setVisible(true);
    }

    public static void show(Throwable exception, String extInfo) {
        ErrorBox dialog = new ErrorBox(exception, extInfo);
        dialog.setVisible(true);
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        this.textMessage.setText("");
        if (this.extInfo != null) {
            this.textMessage.append(this.extInfo + "\n");
        }
        this.textMessage.append(this.exception.getMessage());
        this.textMessage.setCaretPosition(0);
        this.textStackTrace.setText(ExceptionUtil.getStackTrace((Throwable)this.exception));
        this.textStackTrace.setCaretPosition(0);
        this.getRootPane().setDefaultButton(this.buttonClose);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ErrorBox.this.buttonClose.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmErrorRequest = new Action();
        this.buttonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textMessage = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.textStackTrace = new JTextArea();
        this.buttonErrorRequest = new JButton();
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(this.stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorBox.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmErrorRequest.setActionCommandKey("cmErrorRequest");
        this.cmErrorRequest.setText(this.stringManager.getString("cmErrorRequest-text"));
        this.cmErrorRequest.setTooltip(this.stringManager.getString("cmErrorRequest-hint"));
        this.cmErrorRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorBox.this.cmErrorRequestActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle("B\u0142\u0105d");
        this.setModal(true);
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(75, 23));
        this.textMessage.setColumns(20);
        this.textMessage.setFont(new Font("Courier New", 0, 11));
        this.textMessage.setRows(5);
        this.jScrollPane1.setViewportView(this.textMessage);
        this.textStackTrace.setColumns(20);
        this.textStackTrace.setFont(new Font("Courier New", 0, 11));
        this.textStackTrace.setRows(5);
        this.jScrollPane2.setViewportView(this.textStackTrace);
        this.buttonErrorRequest.setAction((javax.swing.Action)this.cmErrorRequest);
        this.buttonErrorRequest.setMargin(new Insets(2, 2, 2, 2));
        this.buttonErrorRequest.setPreferredSize(new Dimension(75, 23));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 650, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 650, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonErrorRequest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 500, Short.MAX_VALUE).addComponent(this.buttonClose, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 221, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonClose, -2, -1, -2).addComponent(this.buttonErrorRequest, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmErrorRequestActionPerformed(ActionEvent evt) {
        RequestErrorDialog.showDialog((Throwable)this.exception);
    }
}

