/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.execmd.ExecutedSqlManager;
import pl.mpak.orbada.universal.services.UniversalSettingsProvider;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class GeneralSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkAutoCloneConnetion;
    private JCheckBox checkAutoExpandSqlText;
    private JCheckBox checkAutoSaveEditorContent;
    private JCheckBox checkCommentAsTabTitle;
    private JCheckBox checkNewEditorContent;
    private JCheckBox checkOnErrorShowMessageBox;
    private JCheckBox checkSplitPanelVertical;
    private JCheckBox checkStoringColumnListPosition;
    private JComboBox comboAutoSaveDitor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSpinner spinAutoSaveEditorContentIntervalSecond;
    private JSpinner spinDeleteAfterDays;
    private JSpinner spinMaxColumnListCount;

    public GeneralSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboAutoSaveDitor.setModel(new DefaultComboBoxModel<String>(new String[]{this.stringManager.getString("for-driver"), this.stringManager.getString("for-database-server"), this.stringManager.getString("for-connection-schema")}));
        this.spinDeleteAfterDays.setModel(new SpinnerNumberModel(1, 0, 1000, 1));
        this.spinMaxColumnListCount.setModel(new SpinnerNumberModel(10, 2, 100, 1));
        this.spinAutoSaveEditorContentIntervalSecond.setModel(new SpinnerNumberModel(60, 10, 3600, 10));
        this.settings = this.application.getSettings(UniversalSettingsProvider.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.spinDeleteAfterDays.setValue(this.settings.getValue(UniversalSettingsProvider.setDeleteAfterDays, Long.valueOf(ExecutedSqlManager.deleteAfterDays)).intValue());
        this.comboAutoSaveDitor.setSelectedIndex(this.settings.getValue(UniversalSettingsProvider.setAutoSaveEditor, Long.valueOf(UniversalSettingsProvider.AUTO_SAVE_EDITOR_SCHEMA)).intValue());
        this.spinAutoSaveEditorContentIntervalSecond.setValue(this.settings.getValue(UniversalSettingsProvider.setAutoSaveEditorContentIntervalSeconds, Long.valueOf(60L)).intValue());
        this.checkAutoSaveEditorContent.setSelected(this.settings.getValue(UniversalSettingsProvider.setAutoSaveEditorContent, Boolean.valueOf(this.checkAutoSaveEditorContent.isSelected())));
        this.checkOnErrorShowMessageBox.setSelected(this.settings.getValue(UniversalSettingsProvider.setOnErrorShowMessageBox, Boolean.valueOf(this.checkOnErrorShowMessageBox.isSelected())));
        this.checkAutoExpandSqlText.setSelected(this.settings.getValue(UniversalSettingsProvider.setAutoExpandSqlText, Boolean.valueOf(this.checkAutoExpandSqlText.isSelected())));
        this.checkNewEditorContent.setSelected(this.settings.getValue(UniversalSettingsProvider.setNewEditorContent, Boolean.valueOf(this.checkNewEditorContent.isSelected())));
        this.checkStoringColumnListPosition.setSelected(this.settings.getValue(UniversalSettingsProvider.setStoringColumnListPosition, Boolean.valueOf(true)));
        this.spinMaxColumnListCount.setValue(this.settings.getValue(UniversalSettingsProvider.setMaxColumnListCount, Long.valueOf(10L)).intValue());
        this.checkSplitPanelVertical.setSelected(this.settings.getValue(UniversalSettingsProvider.setSplitPanelVertical, Boolean.valueOf(false)));
        this.checkAutoCloneConnetion.setSelected(this.settings.getValue(UniversalSettingsProvider.setAutoCloneConnection, Boolean.valueOf(false)));
        this.checkCommentAsTabTitle.setSelected(this.settings.getValue(UniversalSettingsProvider.setCommentAtFirstLineTitle, Boolean.valueOf(this.checkCommentAsTabTitle.isSelected())));
    }

    public void applySettings() {
        this.settings.setValue(UniversalSettingsProvider.setDeleteAfterDays, Long.valueOf(((Integer)this.spinDeleteAfterDays.getValue()).intValue()));
        this.settings.setValue(UniversalSettingsProvider.setAutoSaveEditor, Long.valueOf(this.comboAutoSaveDitor.getSelectedIndex()));
        this.settings.setValue(UniversalSettingsProvider.setAutoSaveEditorContentIntervalSeconds, Long.valueOf(((Integer)this.spinAutoSaveEditorContentIntervalSecond.getValue()).intValue()));
        this.settings.setValue(UniversalSettingsProvider.setAutoSaveEditorContent, Boolean.valueOf(this.checkAutoSaveEditorContent.isSelected()));
        this.settings.setValue(UniversalSettingsProvider.setOnErrorShowMessageBox, Boolean.valueOf(this.checkOnErrorShowMessageBox.isSelected()));
        this.settings.setValue(UniversalSettingsProvider.setAutoExpandSqlText, Boolean.valueOf(this.checkAutoExpandSqlText.isSelected()));
        this.settings.setValue(UniversalSettingsProvider.setNewEditorContent, Boolean.valueOf(this.checkNewEditorContent.isSelected()));
        this.settings.setValue(UniversalSettingsProvider.setStoringColumnListPosition, Boolean.valueOf(this.checkStoringColumnListPosition.isSelected()));
        this.settings.setValue(UniversalSettingsProvider.setMaxColumnListCount, Long.valueOf(((Integer)this.spinMaxColumnListCount.getValue()).intValue()));
        this.settings.setValue(UniversalSettingsProvider.setSplitPanelVertical, Boolean.valueOf(this.checkSplitPanelVertical.isSelected()));
        this.settings.setValue(UniversalSettingsProvider.setAutoCloneConnection, Boolean.valueOf(this.checkAutoCloneConnetion.isSelected()));
        this.settings.setValue(UniversalSettingsProvider.setCommentAtFirstLineTitle, Boolean.valueOf(this.checkCommentAsTabTitle.isSelected()));
        this.settings.store();
        this.application.postPluginMessage(new PluginMessage(null, "universal-sql-query-settings-refresh", null));
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spinDeleteAfterDays = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.comboAutoSaveDitor = new JComboBox();
        this.checkAutoSaveEditorContent = new JCheckBox();
        this.spinAutoSaveEditorContentIntervalSecond = new JSpinner();
        this.jLabel5 = new JLabel();
        this.checkOnErrorShowMessageBox = new JCheckBox();
        this.checkAutoExpandSqlText = new JCheckBox();
        this.checkNewEditorContent = new JCheckBox();
        this.checkStoringColumnListPosition = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.spinMaxColumnListCount = new JSpinner();
        this.jLabel7 = new JLabel();
        this.checkSplitPanelVertical = new JCheckBox();
        this.checkAutoCloneConnetion = new JCheckBox();
        this.checkCommentAsTabTitle = new JCheckBox();
        this.jLabel1.setText(this.stringManager.getString("GeneralSettingsPanel-exec-sql-remember-dd"));
        this.jLabel2.setText(this.stringManager.getString("days"));
        this.jLabel3.setText(this.stringManager.getString("GeneralSettingsPanel-content-remember-for-dd"));
        this.checkAutoSaveEditorContent.setSelected(true);
        this.checkAutoSaveEditorContent.setText(this.stringManager.getString("GeneralSettingsPanel-auto-save-editor-content"));
        this.jLabel5.setText(this.stringManager.getString("seconds"));
        this.checkOnErrorShowMessageBox.setText(this.stringManager.getString("GeneralSettingsPanel-on-error-show-message"));
        this.checkAutoExpandSqlText.setText(this.stringManager.getString("GeneralSettingsPanel-auto-expand-sql"));
        this.checkNewEditorContent.setText(this.stringManager.getString("GeneralSettingsPanel-new-editor-content"));
        this.checkStoringColumnListPosition.setText(this.stringManager.getString("GeneralSettingsPanel-storing-column-list-pos"));
        this.jLabel6.setText(this.stringManager.getString("GeneralSettingsPanel-column-list-coun-before"));
        this.jLabel7.setText(this.stringManager.getString("GeneralSettingsPanel-column-list-coun-after"));
        this.checkSplitPanelVertical.setText(this.stringManager.getString("GeneralSettingsPanel-split-panel-vert"));
        this.checkAutoCloneConnetion.setText(this.stringManager.getString("GeneralSettingsPanel-auto-clone-connection"));
        this.checkCommentAsTabTitle.setText(this.stringManager.getString("checkCommentAsTabTitle-text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkCommentAsTabTitle).addComponent(this.checkAutoCloneConnetion).addComponent(this.checkSplitPanelVertical).addComponent(this.checkStoringColumnListPosition).addComponent(this.checkNewEditorContent).addComponent(this.checkAutoExpandSqlText).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinDeleteAfterDays, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboAutoSaveDitor, 0, 254, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.checkAutoSaveEditorContent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinAutoSaveEditorContentIntervalSecond, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addComponent(this.checkOnErrorShowMessageBox).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinMaxColumnListCount, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.spinDeleteAfterDays, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboAutoSaveDitor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkAutoSaveEditorContent).addComponent(this.spinAutoSaveEditorContentIntervalSecond, -2, 22, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkOnErrorShowMessageBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoExpandSqlText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNewEditorContent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkStoringColumnListPosition, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.spinMaxColumnListCount, -2, 22, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSplitPanelVertical, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoCloneConnetion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCommentAsTabTitle).addContainerGap(73, Short.MAX_VALUE)));
    }
}

