/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.EditorPane;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.CommandListener;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryField;
import pl.mpak.usedb.script.ErrorScriptEventObject;
import pl.mpak.usedb.script.SQLScript;
import pl.mpak.usedb.script.ScriptListener;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.TextTransfer;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.task.Task;

public class ScriptResultPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private Task scriptTask;
    private ArrayList<Integer> errorList;
    private StringBuilder errorListText;
    private int errorPointer;
    private int resultLength;
    private Command command;
    private CommandListener commandListener;
    private IViewAccesibilities accesibilities;
    private boolean firstShown;
    private ToolButton buttonCancelScript;
    private ToolButton buttonClear;
    private ToolButton buttonCopyErrorToClipboard;
    private ToolButton buttonGotoNextError;
    private ToolButton buttonGotoPrevError;
    private ToolButton buttonSave;
    private Action cmCancelScript;
    private Action cmClearContent;
    private Action cmCopyErrorToClipboard;
    private Action cmGotoNextError;
    private Action cmGotoPrevError;
    private Action cmSaveToFile;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar jToolBar1;
    private JPanel panelEditData;
    private EditorPane textResult;

    public ScriptResultPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.errorList = new ArrayList();
        this.errorListText = new StringBuilder();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.textResult.setFont(new Font("Monospaced", 0, this.textResult.getFont().getSize()));
        Style style = ((StyledDocument)this.textResult.getDocument()).addStyle("text", null);
        StyleConstants.setFontFamily(style, "Monospaced");
        StyleConstants.setForeground(style, this.textResult.getForeground());
        style = ((StyledDocument)this.textResult.getDocument()).addStyle("error", null);
        StyleConstants.setFontFamily(style, "Monospaced");
        StyleConstants.setBold(style, true);
        StyleConstants.setForeground(style, Color.RED);
        this.clearErrorList();
    }

    private void clearErrorList() {
        this.cmGotoNextError.setEnabled(false);
        this.cmGotoPrevError.setEnabled(false);
        this.errorList.clear();
        this.errorListText.setLength(0);
        this.errorPointer = -1;
        this.resultLength = 0;
    }

    private void activateErrorList() {
        this.cmGotoNextError.setEnabled(this.errorList.size() > 0);
        this.cmGotoPrevError.setEnabled(false);
    }

    private void enableErrorList() {
        this.cmGotoNextError.setEnabled(this.errorPointer < this.errorList.size() - 1);
        this.cmGotoPrevError.setEnabled(this.errorPointer > 0);
        this.cmCopyErrorToClipboard.setEnabled(this.errorList.size() > 0);
    }

    private void updatePositionError() {
        final int offset = this.errorList.get(this.errorPointer);
        this.textResult.setCaretPosition(offset);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    ScriptResultPanel.this.textResult.scrollRectToVisible(ScriptResultPanel.this.textResult.modelToView(offset));
                }
                catch (BadLocationException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    public void append(final String text) {
        JTabbedPane pane;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ScriptResultPanel.this.resultLength += text.length();
                StyledDocument doc = (StyledDocument)ScriptResultPanel.this.textResult.getDocument();
                try {
                    doc.insertString(doc.getLength(), text, doc.getStyle("text"));
                }
                catch (BadLocationException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
        if (!this.firstShown && (pane = (JTabbedPane)SwingUtil.getOwnerComponent(JTabbedPane.class, (Component)this)) != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    pane.setSelectedComponent(ScriptResultPanel.this);
                }
            });
        }
    }

    public void appendError(final String text, final String cmd) {
        JTabbedPane pane;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ScriptResultPanel.this.errorList.add(ScriptResultPanel.this.resultLength);
                StyledDocument doc = (StyledDocument)ScriptResultPanel.this.textResult.getDocument();
                try {
                    doc.insertString(doc.getLength(), text, doc.getStyle("error"));
                    ScriptResultPanel.this.errorListText.append(cmd + "\n" + text);
                }
                catch (BadLocationException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
                ScriptResultPanel.this.resultLength += text.length();
            }
        });
        if (!this.firstShown && (pane = (JTabbedPane)SwingUtil.getOwnerComponent(JTabbedPane.class, (Component)this)) != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    pane.setSelectedComponent(ScriptResultPanel.this);
                }
            });
        }
    }

    public void execute(Database database, final String text) {
        if (this.textResult.getDocument().getLength() > 0) {
            switch (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("ScriptResultPanel-clear_result-title"), (String)this.stringManager.getString("ScriptResultPanel-clear_result-q"), (int[])ModalResult.YESNOCANCEL, (int)3)) {
                case 2: {
                    return;
                }
                case 5: {
                    this.cmClearContent.performe();
                }
            }
        } else if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("script"), (String)this.stringManager.getString("ScriptResultPanel-exec_script-q"), (int[])ModalResult.YESNO, (int)3) != 5) {
            return;
        }
        final SQLScript script = new SQLScript(database);
        script.addScriptListener(new ScriptListener(){
            String cmdText;

            public void beforeScript(EventObject evt) {
            }

            public void beforeCommand(EventObject evt) {
                Command command = (Command)evt.getSource();
                String sqlText = SQLUtil.removeWhiteSpaces((String)command.getSqlText());
                this.cmdText = sqlText.substring(0, Math.min(100, sqlText.length()));
                ScriptResultPanel.this.append(this.cmdText + "\n");
            }

            public void afterCommand(EventObject evt) {
                Command command = (Command)evt.getSource();
                ScriptResultPanel.this.append(command.getUpdateCount() + " " + ScriptResultPanel.this.stringManager.getString("records-updated-count") + ", " + StringUtil.formatTime((long)command.getExecutionTime()) + "\n\n");
            }

            public void beforeQuery(EventObject evt) {
                Query query = (Query)evt.getSource();
                String sqlText = SQLUtil.removeWhiteSpaces((String)query.getSqlText());
                this.cmdText = sqlText.substring(0, Math.min(100, sqlText.length()));
                ScriptResultPanel.this.append(this.cmdText + "\n");
            }

            public void afterQuery(EventObject evt) {
                int c;
                int length;
                QueryField field;
                int i;
                Query query = (Query)evt.getSource();
                StringBuilder line = new StringBuilder();
                for (i = 0; i < query.getFieldCount(); ++i) {
                    field = query.getField(i);
                    line.append(field.getDisplayName());
                    length = Math.max(field.getDisplaySize(), field.getDisplayName().length());
                    for (c = 0; c < length - field.getDisplayName().length() + 1; ++c) {
                        line.append(' ');
                    }
                }
                line.append("\n");
                ScriptResultPanel.this.append(line.toString());
                line.setLength(0);
                for (i = 0; i < query.getFieldCount(); ++i) {
                    field = query.getField(i);
                    length = Math.max(field.getDisplaySize(), field.getDisplayName().length());
                    for (c = 0; c < length; ++c) {
                        line.append('-');
                    }
                    line.append(' ');
                }
                line.append("\n");
                ScriptResultPanel.this.append(line.toString());
                int records = 0;
                try {
                    while (!query.eof()) {
                        line.setLength(0);
                        for (int i2 = 0; i2 < query.getFieldCount(); ++i2) {
                            QueryField field2 = query.getField(i2);
                            String value = field2.getString();
                            line.append(value);
                            int length2 = Math.max(field2.getDisplaySize(), field2.getDisplayName().length());
                            for (int c2 = 0; c2 < length2 - value.length() + 1; ++c2) {
                                line.append(' ');
                            }
                        }
                        ++records;
                        line.append("\n");
                        ScriptResultPanel.this.append(line.toString());
                        query.next();
                    }
                }
                catch (Exception ex) {
                    ScriptResultPanel.this.appendError(ex.getMessage() + "\n", this.cmdText);
                }
                ScriptResultPanel.this.append("\n");
                ScriptResultPanel.this.append(records + " " + ScriptResultPanel.this.stringManager.getString("records-selected-count") + ", " + StringUtil.formatTime((long)query.getOpeningTime()) + "\n\n");
            }

            public boolean errorOccured(ErrorScriptEventObject evt) {
                ScriptResultPanel.this.appendError(((Throwable)evt.getSource()).getMessage() + "\n\n", this.cmdText);
                return false;
            }

            public void afterScript(EventObject evt) {
                ScriptResultPanel.this.append(ScriptResultPanel.this.stringManager.getString("ScriptResultPanel-script_end") + " " + StringUtil.formatTime((long)script.getScriptTime()) + "\n");
                ScriptResultPanel.this.append(ScriptResultPanel.this.stringManager.getString("ScriptResultPanel-script_errors") + " " + script.getErrorCount() + "\n\n");
            }
        });
        this.scriptTask = new Task(this.stringManager.getString("ScriptResultPanel-executor-task-3d")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ScriptResultPanel.this.cmCancelScript.setEnabled(true);
                PleaseWait wait = PleaseWait.createSqlWait((String)ScriptResultPanel.this.stringManager.getString("ScriptResultPanel-script_executing"), (int)2000);
                ScriptResultPanel.this.accesibilities.getApplication().startPleaseWait(wait);
                try {
                    script.execute(new BufferedReader(new StringReader(text)));
                }
                catch (IOException ex) {
                    ScriptResultPanel.this.errorList.add(ScriptResultPanel.this.textResult.getCaretPosition());
                    ScriptResultPanel.this.append(ex.getMessage() + "\n");
                    ExceptionUtil.processException((Throwable)ex);
                }
                finally {
                    ScriptResultPanel.this.accesibilities.getApplication().stopPleaseWait(wait);
                    ScriptResultPanel.this.cmCancelScript.setEnabled(false);
                    ScriptResultPanel.this.activateErrorList();
                    ScriptResultPanel.this.scriptTask = null;
                }
            }
        };
        database.getTaskPool().addTask(this.scriptTask);
    }

    public void setCommand(Command command) {
        if (this.command != command) {
            if (this.command != null) {
                this.command.removeCommandListener(this.getCommandListener());
            }
            this.command = command;
            if (this.command != null) {
                this.command.addCommandListener(this.getCommandListener());
            }
        }
    }

    private CommandListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new CommandListener(){

                public void beforeExecute(EventObject e) {
                    ScriptResultPanel.this.firstShown = false;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ScriptResultPanel.this.cmCancelScript.setEnabled(true);
                        }
                    });
                }

                public void afterExecute(EventObject e) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ScriptResultPanel.this.cmCancelScript.setEnabled(false);
                        }
                    });
                }

                public void errorPerformed(EventObject e) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ScriptResultPanel.this.cmCancelScript.setEnabled(false);
                        }
                    });
                }
            };
        }
        return this.commandListener;
    }

    public void close() throws IOException {
    }

    private void initComponents() {
        this.cmClearContent = new Action();
        this.cmSaveToFile = new Action();
        this.cmCancelScript = new Action();
        this.cmGotoNextError = new Action();
        this.cmGotoPrevError = new Action();
        this.cmCopyErrorToClipboard = new Action();
        this.panelEditData = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.buttonClear = new ToolButton();
        this.buttonSave = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonCancelScript = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonGotoNextError = new ToolButton();
        this.buttonGotoPrevError = new ToolButton();
        this.buttonCopyErrorToClipboard = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.textResult = new EditorPane();
        this.cmClearContent.setActionCommandKey("cmClearContent");
        this.cmClearContent.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/clear.gif"));
        this.cmClearContent.setText(this.stringManager.getString("cmClearContent-text"));
        this.cmClearContent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptResultPanel.this.cmClearContentActionPerformed(evt);
            }
        });
        this.cmSaveToFile.setActionCommandKey("cmSaveToFile");
        this.cmSaveToFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmSaveToFile.setText(this.stringManager.getString("cmSaveToFile-text"));
        this.cmSaveToFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptResultPanel.this.cmSaveToFileActionPerformed(evt);
            }
        });
        this.cmCancelScript.setActionCommandKey("cmCancelScript");
        this.cmCancelScript.setEnabled(false);
        this.cmCancelScript.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/cancel.gif"));
        this.cmCancelScript.setText(this.stringManager.getString("cmCancelScript-text"));
        this.cmCancelScript.setTooltip(this.stringManager.getString("cmCancelScript-hint"));
        this.cmCancelScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptResultPanel.this.cmCancelScriptActionPerformed(evt);
            }
        });
        this.cmGotoNextError.setActionCommandKey("cmGotoNextError");
        this.cmGotoNextError.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/next_error.gif"));
        this.cmGotoNextError.setText(this.stringManager.getString("cmGotoNextError-text"));
        this.cmGotoNextError.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptResultPanel.this.cmGotoNextErrorActionPerformed(evt);
            }
        });
        this.cmGotoPrevError.setActionCommandKey("cmGotoPrevError");
        this.cmGotoPrevError.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/prev_error.gif"));
        this.cmGotoPrevError.setText(this.stringManager.getString("cmGotoPrevError-text"));
        this.cmGotoPrevError.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptResultPanel.this.cmGotoPrevErrorActionPerformed(evt);
            }
        });
        this.cmCopyErrorToClipboard.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/copy-error.gif"));
        this.cmCopyErrorToClipboard.setText(this.stringManager.getString("cmCopyErrorToClipboard-text"));
        this.cmCopyErrorToClipboard.setTooltip(this.stringManager.getString("cmCopyErrorToClipboard-hint"));
        this.cmCopyErrorToClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptResultPanel.this.cmCopyErrorToClipboardActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ScriptResultPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.panelEditData.setLayout(new FlowLayout(0, 0, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonClear.setAction((javax.swing.Action)this.cmClearContent);
        this.buttonClear.setHorizontalTextPosition(0);
        this.buttonClear.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonClear);
        this.buttonSave.setAction((javax.swing.Action)this.cmSaveToFile);
        this.buttonSave.setHorizontalTextPosition(0);
        this.buttonSave.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonSave);
        this.jToolBar1.add(this.jSeparator1);
        this.buttonCancelScript.setAction((javax.swing.Action)this.cmCancelScript);
        this.buttonCancelScript.setHorizontalTextPosition(0);
        this.buttonCancelScript.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonCancelScript);
        this.jToolBar1.add(this.jSeparator2);
        this.buttonGotoNextError.setAction((javax.swing.Action)this.cmGotoNextError);
        this.buttonGotoNextError.setHorizontalTextPosition(0);
        this.buttonGotoNextError.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonGotoNextError);
        this.buttonGotoPrevError.setAction((javax.swing.Action)this.cmGotoPrevError);
        this.buttonGotoPrevError.setHorizontalTextPosition(0);
        this.buttonGotoPrevError.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonGotoPrevError);
        this.buttonCopyErrorToClipboard.setAction((javax.swing.Action)this.cmCopyErrorToClipboard);
        this.buttonCopyErrorToClipboard.setHorizontalTextPosition(0);
        this.buttonCopyErrorToClipboard.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonCopyErrorToClipboard);
        this.panelEditData.add(this.jToolBar1);
        this.add((Component)this.panelEditData, "First");
        this.textResult.setEditable(false);
        this.jScrollPane1.setViewportView((Component)this.textResult);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void cmClearContentActionPerformed(ActionEvent evt) {
        this.clearErrorList();
        this.textResult.setText("");
    }

    private void cmSaveToFileActionPerformed(ActionEvent evt) {
        File file = FileUtil.selectFileToSave((Component)this, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("text-files"), new String[]{".txt"})});
        if (file != null) {
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(file));
                pw.write(this.textResult.getText());
                pw.close();
            }
            catch (FileNotFoundException ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmCancelScriptActionPerformed(ActionEvent evt) {
        if (this.scriptTask != null) {
            this.scriptTask.setCanceled(true);
        } else if (this.command != null && this.command.getState() == Command.State.EXECUTEING) {
            try {
                this.command.cancel();
            }
            catch (SQLException ex) {
                this.append(ex.getMessage() + "\n");
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmGotoNextErrorActionPerformed(ActionEvent evt) {
        ++this.errorPointer;
        this.updatePositionError();
        this.enableErrorList();
    }

    private void cmGotoPrevErrorActionPerformed(ActionEvent evt) {
        --this.errorPointer;
        this.updatePositionError();
        this.enableErrorList();
    }

    private void cmCopyErrorToClipboardActionPerformed(ActionEvent evt) {
        new TextTransfer().setClipboardContents(this.errorListText.toString());
    }

    private void formComponentShown(ComponentEvent evt) {
        this.firstShown = true;
    }
}

