/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SelectDatabaseDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private int modalResult = 0;
    private Database database;
    private boolean constraintType;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmSelect;
    private JScrollPane jScrollPane1;
    private JList listDatabases;

    public SelectDatabaseDialog(Database database, boolean constraintType) {
        super(SwingUtil.getRootFrame());
        this.database = database;
        this.constraintType = constraintType;
        this.initComponents();
        this.init();
    }

    public static Database show(Database database, boolean constraintType) {
        SelectDatabaseDialog dialog = new SelectDatabaseDialog(database, constraintType);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            return (Database)dialog.listDatabases.getSelectedValue();
        }
        return null;
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.listDatabases.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Database database = (Database)value;
                    String text = "<html>";
                    text = database.getPublicName() == null ? text + "<b>" + database.getUserName() + "</b>" : text + "<b>" + database.getPublicName() + "</b> as " + database.getUserName();
                    text = text + "<br>" + database.getUrl();
                    label.setText(text);
                    label.setVerticalAlignment(1);
                }
                return label;
            }
        });
        this.listDatabases.removeAll();
        this.listDatabases.setModel(new DefaultListModel());
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            if (this.constraintType && !DatabaseManager.getManager().getDatabase(i).getDriverType().equals(this.database.getDriverType()) || DatabaseManager.getManager().getDatabase(i).equals(InternalDatabase.get()) && !Application.get().isUserAdmin()) continue;
            ((DefaultListModel)this.listDatabases.getModel()).addElement(DatabaseManager.getManager().getDatabase(i));
        }
        this.listDatabases.setSelectedValue(this.database, true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SelectDatabaseDialog.this.listDatabases.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmSelect = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.listDatabases = new JList();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectDatabaseDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmSelect.setActionCommandKey("cmSelect");
        this.cmSelect.setText(this.stringManager.getString("cmSelect-text"));
        this.cmSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectDatabaseDialog.this.cmSelectActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("SelectDatabaseDialog-title"));
        this.setModal(true);
        this.listDatabases.setSelectionMode(0);
        this.listDatabases.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SelectDatabaseDialog.this.listDatabasesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listDatabases);
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.buttonOk.setAction((javax.swing.Action)this.cmSelect);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 508, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void listDatabasesValueChanged(ListSelectionEvent evt) {
        this.cmSelect.setEnabled(this.listDatabases.getSelectedIndex() != -1);
    }

    private void cmSelectActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

