/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.db.ConnectionFactory;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.IProcessMessagable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.CommandParametersDialog;
import pl.mpak.orbada.universal.gui.ErrorBox;
import pl.mpak.orbada.universal.gui.ScriptResultPanel;
import pl.mpak.orbada.universal.gui.SelectDatabaseDialog;
import pl.mpak.orbada.universal.gui.SqlQueryResultPanel;
import pl.mpak.orbada.universal.gui.execmd.ExecutedSqlCommandDialog;
import pl.mpak.orbada.universal.gui.execmd.ExecutedSqlManager;
import pl.mpak.orbada.universal.gui.history.QueryHistoryPanel;
import pl.mpak.orbada.universal.providers.IUniversalViewAccessibilities;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.orbada.universal.providers.UniversalSqlTextTransformProvider;
import pl.mpak.orbada.universal.services.UniversalSettingsProvider;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.files.PatternFileFilter;
import pl.mpak.util.files.WildCard;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.task.Task;
import pl.mpak.util.timer.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQueryPanelView
extends JPanel
implements Closeable,
IProcessMessagable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    public static final String PANEL_STATUS = "editor.status";
    public static final String settingsName = "universal-query-panel";
    private IViewAccesibilities accesibilities;
    private ToolButton buttonShowHideError;
    private int nextNo = 0;
    private Database currentDatabase;
    private QueryHistoryPanel historyPanel;
    private ScriptResultPanel scriptResultPanel;
    private ISettings settings;
    private ISettings globalSettings;
    private int tabNumber;
    private int autoSaveEditor = UniversalSettingsProvider.AUTO_SAVE_EDITOR_SCHEMA;
    private ArrayList<String> lastOpenedFile;
    private Database clonedDatabase;
    private File openedFile;
    private ArrayList<String> editorContentList;
    private String currentEditorContent;
    private Timer autoSaveEditorContentTimer;
    private boolean autoSaveEditorContent = true;
    private ArrayList<UniversalActionProvider> actionProviders;
    private String orygTitle;
    private ToolButton buttonActions;
    private ToolButton buttonCloneDatabase;
    private ToolButton buttonDbCommit;
    private ToolButton buttonDbRollback;
    private ToolButton buttonDeleteEditor;
    private ToolButton buttonExecute;
    private ToolButton buttonExecuteAsScript;
    private ToolButton buttonExecutedSql;
    private ToolButton buttonNewEditor;
    private ToolButton buttonNextEditor;
    private ToolButton buttonOpenFile;
    private ToolButton buttonPervEditor;
    private ToolButton buttonRecentFiles;
    private ToolButton buttonSaveFile;
    private ToolButton buttonSaveFileAs;
    private ToolButton buttonStore;
    private Action cmCloneDatabase;
    private Action cmDBStartTransaction;
    private Action cmDbCommit;
    private Action cmDbRollback;
    private Action cmDeleteEditor;
    private Action cmEmpty;
    private Action cmExecute;
    private Action cmExecuteAsScript;
    private Action cmExecutePartial;
    private Action cmExecutedSql;
    private Action cmNewEditor;
    private Action cmNextEditor;
    private Action cmOpenFile;
    private Action cmPopupRecentFiles;
    private Action cmPrevEditor;
    private Action cmSaveFile;
    private Action cmSaveFileAs;
    private Action cmSelectDatabase;
    private Action cmShowHideError;
    private Action cmStore;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JLabel labelFileName;
    private JLabel labelSelectedDatabase;
    private JPopupMenu menuActions;
    private JMenuItem menuCloneDatabase;
    private JMenuItem menuCommit;
    private JMenuItem menuDeleteEditor;
    private JMenuItem menuExecute;
    private JMenuItem menuExecuteAsScript;
    private JMenuItem menuExecutedSql;
    private JMenuItem menuNewEditor;
    private JMenuItem menuNextEditor;
    private JMenuItem menuOpenFile;
    private JMenuItem menuPrevEditor;
    private JMenu menuRecentFiles;
    private JMenuItem menuRollback;
    private JMenuItem menuSaveFile;
    private JMenuItem menuSaveFileAs;
    private JMenuItem menuSelectDatabase;
    private JMenuItem menuStore;
    private JMenu menuView;
    private JPanel panelSqlEditor;
    private JPopupMenu popupRecentFiles;
    private JScrollPane scrollSqlError;
    private JSplitPane splitPanel;
    private JTabbedPane tabbedViews;
    private OrbadaSyntaxTextArea textSqlEditor;
    private JTextArea textSqlError;
    private JToolBar toolBar;
    private ToolButton toolButton1;
    private ToolButton toolButton2;

    public SqlQueryPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    public Database getDatabase() {
        if (this.currentDatabase == null) {
            this.currentDatabase = this.accesibilities.getDatabase();
        }
        return this.currentDatabase;
    }

    private void cloneDatabase() {
        this.closeCloneDatabase();
        ConnectionFactory factory = new ConnectionFactory(this.getDatabase());
        try {
            this.clonedDatabase = factory.createDatabase();
            this.setCurrentDatabase(this.clonedDatabase);
            this.buttonCloneDatabase.setSelected(true);
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        this.menuCloneDatabase.setSelected(this.buttonCloneDatabase.isSelected());
    }

    private void closeCloneDatabase() {
        if (this.clonedDatabase != null) {
            if (this.clonedDatabase.equals(this.getDatabase())) {
                this.setCurrentDatabase(this.accesibilities.getDatabase());
            }
            this.clonedDatabase.getTaskPool().addTask(new Task(String.format(this.stringManager.getString("SqlQueryPanelView-closing-connection"), this.clonedDatabase.getPublicName())){
                Database database;
                {
                    this.database = SqlQueryPanelView.this.clonedDatabase;
                }

                public void run() {
                    this.database.close();
                }
            });
            this.clonedDatabase = null;
            this.buttonCloneDatabase.setSelected(false);
        }
        this.menuCloneDatabase.setSelected(this.buttonCloneDatabase.isSelected());
    }

    private void setCurrentDatabase(Database database) {
        this.currentDatabase = database;
        this.textSqlEditor.setDatabase(database);
        if (database != null && !database.equals(this.accesibilities.getDatabase())) {
            this.labelSelectedDatabase.setText(database.getPublicName() + " as " + database.getUserName());
        } else {
            this.labelSelectedDatabase.setText(" ");
        }
    }

    public IApplication getApplication() {
        return this.accesibilities.getApplication();
    }

    private int findTabNumber() {
        Component[] tabs = this.accesibilities.getViewComponentList(this.accesibilities.getViewProvider());
        if (tabs.length > 0) {
            for (int i = 0; i < 100; ++i) {
                boolean found = false;
                for (int t = 0; t < tabs.length; ++t) {
                    SqlQueryPanelView tab = (SqlQueryPanelView)tabs[t];
                    if (tab.getTabNumber() != i) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return i;
            }
        }
        return 0;
    }

    private void init() {
        this.tabNumber = this.findTabNumber();
        this.menuView.setText(SwingUtil.setButtonText((AbstractButton)this.menuView, (String)this.stringManager.getString("SqlQueryPanelView-menuView-text")));
        this.menuRecentFiles.setText(SwingUtil.setButtonText((AbstractButton)this.menuRecentFiles, (String)this.stringManager.getString("SqlQueryPanelView-menuRecentFiles-text")));
        this.lastOpenedFile = new ArrayList();
        this.settings = this.getApplication().getSettings(this.accesibilities.getDatabase().getUserProperties().getProperty("schemaId"), settingsName);
        this.globalSettings = this.getApplication().getSettings(UniversalSettingsProvider.settingsName);
        this.autoSaveEditor = this.globalSettings.getValue(UniversalSettingsProvider.setAutoSaveEditor, Long.valueOf(this.autoSaveEditor)).intValue();
        this.editorContentList = new ArrayList();
        this.accesibilities.addMenu(this.menuView);
        this.textSqlEditor.getStatusBar().addPanel(PANEL_STATUS);
        this.setCurrentDatabase(this.accesibilities.getDatabase());
        SwingUtil.addAction((JComponent)this.textSqlEditor.getEditorArea(), (javax.swing.Action)this.cmExecute);
        SwingUtil.addAction((JComponent)this.textSqlEditor.getEditorArea(), (javax.swing.Action)this.cmExecutedSql);
        SwingUtil.addAction((JComponent)this.textSqlEditor.getEditorArea(), (javax.swing.Action)this.cmExecutePartial);
        SwingUtil.addAction((JComponent)this.textSqlEditor.getEditorArea(), (javax.swing.Action)this.cmExecuteAsScript);
        SwingUtil.addAction((JComponent)this.textSqlEditor.getEditorArea(), (javax.swing.Action)this.cmStore);
        SwingUtil.addAction((JComponent)this.textSqlEditor.getEditorArea(), (javax.swing.Action)this.cmSaveFile);
        this.textSqlEditor.getDocument().addDocumentListener(this.getDocumentListener());
        this.buttonShowHideError = new ToolButton((javax.swing.Action)this.cmShowHideError);
        this.buttonShowHideError.setPreferredSize(new Dimension(18, 18));
        this.textSqlEditor.getStatusBar().addBefore(this.textSqlEditor.getStatusBar().getComponent(0), (Component)this.buttonShowHideError);
        this.buttonShowHideError.setVisible(false);
        this.buttonShowHideError.setMargin(new Insets(0, 0, 0, 0));
        this.scrollSqlError.setVisible(false);
        this.addHistoryTab();
        this.addResultTab();
        this.addScriptResultTab();
        this.refreshEditorContentList(true);
        if (this.globalSettings.getValue(UniversalSettingsProvider.setNewEditorContent, Boolean.valueOf(false)).booleanValue() && this.textSqlEditor.getText().trim().length() != 0) {
            this.cmNewEditor.performe();
        }
        this.initUniversalSerives();
        this.splitPanel.setResizeWeight(1.0);
        if (this.globalSettings.getValue(UniversalSettingsProvider.setSplitPanelVertical, Boolean.valueOf(false)).booleanValue()) {
            this.splitPanel.setOrientation(1);
        }
        this.splitPanel.setDividerLocation(this.settings.getValue("split-panel-position", Long.valueOf(this.splitPanel.getDividerLocation())).intValue());
        this.autoSaveEditorContentTimer = new Timer((long)this.globalSettings.getValue(UniversalSettingsProvider.setAutoSaveEditorContentIntervalSeconds, Long.valueOf(60L)).intValue() * 1000L){

            public void run() {
                if (SqlQueryPanelView.this.autoSaveEditorContent && SqlQueryPanelView.this.currentEditorContent != null && SqlQueryPanelView.this.textSqlEditor.isChanged()) {
                    try {
                        SqlQueryPanelView.this.textSqlEditor.saveToFile(SqlQueryPanelView.this.currentEditorContent);
                        SqlQueryPanelView.this.textSqlEditor.setChanged(false);
                        SqlQueryPanelView.this.storeEditorContentSettings(SqlQueryPanelView.this.currentEditorContent);
                    }
                    catch (IOException ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        };
        this.autoSaveEditorContent = this.globalSettings.getValue(UniversalSettingsProvider.setAutoSaveEditorContent, Boolean.valueOf(this.autoSaveEditorContent));
        OrbadaUniversalPlugin.refreshQueue.add(this.autoSaveEditorContentTimer);
        this.autoSaveEditorContentTimer.setEnabled(this.autoSaveEditorContent);
        this.accesibilities.getApplication().registerRequestMessager((IProcessMessagable)this);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.textSqlEditor.getEditorArea(), (JButton)this.buttonActions, this.menuActions, "universal-sql-commands");
        this.loadLastOpenedFiles();
        this.setTransactionActionEnabled();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (SqlQueryPanelView.this.settings.getValue(UniversalSettingsProvider.setAutoCloneConnection, Long.valueOf(0L)) == 0L) {
                    if (SqlQueryPanelView.this.globalSettings.getValue(UniversalSettingsProvider.setAutoCloneConnection, Boolean.valueOf(false)).booleanValue()) {
                        SqlQueryPanelView.this.cloneDatabase();
                    }
                } else if (SqlQueryPanelView.this.settings.getValue(UniversalSettingsProvider.setAutoCloneConnection, Long.valueOf(0L)) == 1L) {
                    SqlQueryPanelView.this.cloneDatabase();
                }
            }
        });
        this.orygTitle = this.accesibilities.getTabTitle();
    }

    @Override
    public void close() throws IOException {
        this.storeLastOpenedFiles();
        this.accesibilities.getApplication().unregisterRequestMessager((IProcessMessagable)this);
        int i = 0;
        while (i < this.tabbedViews.getTabCount()) {
            this.closePanel(this.tabbedViews.getComponentAt(i));
        }
        if (this.currentEditorContent != null) {
            try {
                this.textSqlEditor.saveToFile(this.currentEditorContent);
                this.storeEditorContentSettings(this.currentEditorContent);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setCurrentDatabase(null);
        this.closeCloneDatabase();
        this.accesibilities = null;
        this.tabbedViews.removeAll();
        this.settings.setValue("split-panel-position", Long.valueOf(this.splitPanel.getDividerLocation()));
        this.settings.store();
        this.autoSaveEditorContentTimer.cancel();
        this.autoSaveEditorContentTimer = null;
        this.historyPanel.close();
        this.historyPanel = null;
        this.scriptResultPanel.close();
        this.scriptResultPanel = null;
    }

    private void initUniversalSerives() {
        boolean menuFound = false;
        this.actionProviders = new ArrayList();
        UniversalActionProvider[] uaps = (UniversalActionProvider[])this.accesibilities.getApplication().getServiceArray(UniversalActionProvider.class);
        if (uaps != null && uaps.length > 0) {
            for (UniversalActionProvider uap : uaps) {
                if (!uap.isForDatabase(this.getDatabase())) continue;
                this.actionProviders.add(uap);
                uap.setUniversalViewAccessibilities(new UniversalViewAccessibilities());
                if (uap.addMenuItem()) {
                    if (!menuFound) {
                        this.menuView.addSeparator();
                        menuFound = true;
                    }
                    this.menuView.add((javax.swing.Action)((Object)uap));
                }
                if (uap.addToolButton()) {
                    this.toolBar.add((Component)new ToolButton((javax.swing.Action)((Object)uap)));
                }
                if (!uap.addToEditor() || uap.addMenuItem()) continue;
                SwingUtil.addAction((JComponent)this.textSqlEditor.getEditorArea(), (javax.swing.Action)((Object)uap));
            }
        }
    }

    private void addUniversalViewTab(String title, JComponent component) {
        this.tabbedViews.addTab(title, component);
        int index = this.tabbedViews.indexOfComponent(component);
        this.tabbedViews.setTabComponentAt(index, (Component)new TabCloseComponent(title, (Action)new TabCloseAction(component)));
        this.tabbedViews.setSelectedComponent(component);
    }

    public int getTabNumber() {
        return this.tabNumber;
    }

    public void setTransactionActionEnabled() {
        try {
            this.cmDbCommit.setEnabled(this.getDatabase().isStartTransaction());
            this.cmDbRollback.setEnabled(this.getDatabase().isStartTransaction());
            this.cmDBStartTransaction.setEnabled(this.getDatabase().startTransactionAvailable() && !this.getDatabase().isStartTransaction());
        }
        catch (SQLException ex) {
            this.cmDbCommit.setEnabled(true);
            this.cmDbRollback.setEnabled(true);
            this.cmDBStartTransaction.setEnabled(false);
        }
    }

    private void updateTabToolip() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SyntaxDocument sd = SqlQueryPanelView.this.textSqlEditor.getDocument();
                try {
                    String text = sd.getText(sd.getLineStartOffset(0), sd.getLineEndOffset(0));
                    if (text.length() > 2 && "--".equals(text.trim().substring(0, 2))) {
                        String caption = text.substring(2).trim();
                        if (SqlQueryPanelView.this.settings.getValue(UniversalSettingsProvider.setCommentAtFirstLineTitle, Boolean.valueOf(false)).booleanValue()) {
                            SqlQueryPanelView.this.accesibilities.setTabExtTooltip(caption);
                        } else if (!StringUtil.isEmpty((String)caption)) {
                            SqlQueryPanelView.this.accesibilities.setTabTitle(caption);
                        } else {
                            SqlQueryPanelView.this.accesibilities.setTabTitle(SqlQueryPanelView.this.orygTitle);
                        }
                    } else if (SqlQueryPanelView.this.settings.getValue(UniversalSettingsProvider.setCommentAtFirstLineTitle, Boolean.valueOf(false)).booleanValue()) {
                        SqlQueryPanelView.this.accesibilities.setTabExtTooltip(null);
                    } else {
                        SqlQueryPanelView.this.accesibilities.setTabTitle(SqlQueryPanelView.this.orygTitle);
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(SqlQueryPanelView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private DocumentListener getDocumentListener() {
        return new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (e.getOffset() <= 500) {
                    SqlQueryPanelView.this.updateTabToolip();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (e.getOffset() <= 500) {
                    SqlQueryPanelView.this.updateTabToolip();
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    public Component[] getResultTabs(Class<? extends Component> clazz) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < this.tabbedViews.getTabCount(); ++i) {
            Component c = this.tabbedViews.getComponentAt(i);
            if (!clazz.isInstance(c)) continue;
            list.add(c);
        }
        return list.toArray(new JComponent[list.size()]);
    }

    public void setTabTooltip(final Component comp, final String tooltip) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int index = SqlQueryPanelView.this.tabbedViews.indexOfComponent(comp);
                if (index >= 0) {
                    SqlQueryPanelView.this.tabbedViews.setToolTipTextAt(index, tooltip);
                }
            }
        });
    }

    public void setTabTitle(final Component comp, final String title) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int index = SqlQueryPanelView.this.tabbedViews.indexOfComponent(comp);
                if (index >= 0) {
                    Component tabComp = SqlQueryPanelView.this.tabbedViews.getTabComponentAt(index);
                    if (tabComp instanceof TabCloseComponent) {
                        ((TabCloseComponent)tabComp).setTitle(title);
                    } else {
                        SqlQueryPanelView.this.tabbedViews.setTitleAt(index, title);
                    }
                }
            }
        });
    }

    private void loadLastOpenedFiles() {
        long count = this.settings.getValue("last-opened-file-count", Long.valueOf(0L));
        int i = 0;
        while ((long)i < count) {
            String file = this.settings.getValue("last-opened-file-" + i, (String)null);
            if (file != null) {
                this.lastOpenedFile.add(file);
            }
            ++i;
        }
    }

    private void storeLastOpenedFiles() {
        this.settings.setValue("last-opened-file-count", Long.valueOf(this.lastOpenedFile.size()));
        for (int i = 0; i < this.lastOpenedFile.size(); ++i) {
            this.settings.setValue("last-opened-file-" + i, this.lastOpenedFile.get(i));
        }
    }

    private void updateLastOpenedFileList(String fileName) {
        int index = this.lastOpenedFile.indexOf(fileName);
        if (index != -1) {
            this.lastOpenedFile.remove(index);
        }
        this.lastOpenedFile.add(0, fileName);
        if (this.lastOpenedFile.size() > 10) {
            this.lastOpenedFile.remove(this.lastOpenedFile.size() - 1);
        }
    }

    private void createMenuLastOpenedFile(JMenu menu) {
        menu.removeAll();
        for (String s : this.lastOpenedFile) {
            menu.add((javax.swing.Action)((Object)new OpenRecentFileAction(s)));
        }
        if (this.lastOpenedFile.size() == 0) {
            menu.add((javax.swing.Action)this.cmEmpty);
        }
    }

    private void createMenuLastOpenedFile(JPopupMenu menu) {
        menu.removeAll();
        for (String s : this.lastOpenedFile) {
            menu.add((javax.swing.Action)((Object)new OpenRecentFileAction(s)));
        }
        if (this.lastOpenedFile.size() == 0) {
            menu.add((javax.swing.Action)this.cmEmpty);
        }
    }

    private void addHistoryTab() {
        this.historyPanel = new QueryHistoryPanel();
        String name = this.stringManager.getString("SqlQueryPanelView-history");
        this.tabbedViews.addTab(name, this.historyPanel);
        int index = this.tabbedViews.indexOfComponent(this.historyPanel);
        this.tabbedViews.setTabComponentAt(index, (Component)new TabCloseComponent(name));
    }

    private void addScriptResultTab() {
        this.scriptResultPanel = new ScriptResultPanel(this.accesibilities);
        String name = this.stringManager.getString("SqlQueryPanelView-command-result");
        this.tabbedViews.addTab(name, this.scriptResultPanel);
        int index = this.tabbedViews.indexOfComponent(this.scriptResultPanel);
        this.tabbedViews.setTabComponentAt(index, (Component)new TabCloseComponent(name));
    }

    public SqlQueryResultPanel addResultTab() {
        int insertAt = this.tabbedViews.getTabCount() - 1;
        for (int i = 0; i < this.tabbedViews.getTabCount(); ++i) {
            Component c = this.tabbedViews.getComponentAt(i);
            if (!(c instanceof SqlQueryResultPanel)) continue;
            insertAt = i + 1;
        }
        SqlQueryResultPanel panel = new SqlQueryResultPanel(this);
        String name = this.stringManager.getString("result") + (this.nextNo > 0 ? " " + (this.nextNo + 1) : "");
        this.tabbedViews.insertTab(name, null, panel, null, insertAt);
        int index = this.tabbedViews.indexOfComponent(panel);
        Action action = this.nextNo > 0 ? new TabCloseAction(panel) : new TabAddResultAction();
        this.tabbedViews.setTabComponentAt(index, (Component)new TabCloseComponent(name, action));
        this.tabbedViews.setSelectedComponent(panel);
        ++this.nextNo;
        return panel;
    }

    void fireEventPanel(EventPanel event, Query query, Command command, Exception ex) {
        for (UniversalActionProvider uap : this.actionProviders) {
            switch (event) {
                case BEFORE_OPEN_QUERY: {
                    uap.beforeOpenQuery(query);
                    break;
                }
                case AFTER_OPEN_QUERY: {
                    uap.afterOpenQuery(query);
                    break;
                }
                case BEFORE_CLOSE_QUERY: {
                    uap.beforeCloseQuery(query);
                    break;
                }
                case AFTER_CLOSE_QUERY: {
                    uap.afterCloseQuery(query);
                    break;
                }
                case BEFORE_EXECUTE_COMMAND: {
                    uap.beforeExecuteCommand(command);
                    break;
                }
                case AFTER_EXECUTE_COMMAND: {
                    uap.afterExecuteCommand(command);
                    break;
                }
                case QUERY_ERROR: {
                    uap.queryError(query, ex);
                    break;
                }
                case COMMAND_ERROR: {
                    uap.commandError(command, ex);
                }
            }
        }
    }

    void setUniversalActionServicesProperties(boolean commandTransfotmed, String oryginalCommand) {
        for (UniversalActionProvider uap : this.actionProviders) {
            uap.setCommandTransformed(commandTransfotmed);
            uap.setOryginalCommand(oryginalCommand);
            uap.setScriptResultPanel(this.scriptResultPanel);
        }
    }

    private void closePanel(Component panel) {
        this.tabbedViews.remove(panel);
        if (panel instanceof Closeable) {
            try {
                ((Closeable)((Object)panel)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public SqlQueryResultPanel getResultPanel() {
        Component c;
        SqlQueryResultPanel result = null;
        int index = this.tabbedViews.getSelectedIndex();
        if (index >= 0 && (c = this.tabbedViews.getComponentAt(index)) instanceof SqlQueryResultPanel && !((SqlQueryResultPanel)c).getQuery().isOpening()) {
            result = (SqlQueryResultPanel)c;
        }
        if (result == null) {
            for (int i = 0; i < this.tabbedViews.getTabCount(); ++i) {
                Component c2 = this.tabbedViews.getComponentAt(i);
                if (!(c2 instanceof SqlQueryResultPanel) || ((SqlQueryResultPanel)c2).getQuery().isOpening()) continue;
                result = (SqlQueryResultPanel)c2;
                if (result.isVisible()) break;
                this.tabbedViews.setSelectedComponent(result);
                break;
            }
        }
        if (result == null) {
            result = this.addResultTab();
        }
        return result;
    }

    private boolean isAutoFile(File file) {
        return Pattern.compile("[0-9]{14}-[0-9A-F]{16}-[0-9A-F]{8}\\.sql", 2).matcher(file.getName()).matches();
    }

    private void updateCurrentEditorFileNameLabel() {
        if (this.currentEditorContent != null) {
            File file = new File(this.currentEditorContent);
            if (this.isAutoFile(file)) {
                this.labelFileName.setText(" ");
            } else {
                this.labelFileName.setText(file.getName());
            }
        }
    }

    private void updateCurrentEditorContentFile() {
        int index = this.editorContentList.indexOf(this.currentEditorContent);
        this.currentEditorContent = this.openedFile.getAbsolutePath();
        if (index != -1) {
            this.editorContentList.set(index, this.currentEditorContent);
        }
        this.updateCurrentEditorFileNameLabel();
    }

    private boolean saveFile() {
        if (this.openedFile != null) {
            try {
                this.updateLastOpenedFileList(this.openedFile.getAbsolutePath());
                this.textSqlEditor.saveToFile(this.openedFile);
                this.textSqlEditor.setChanged(false);
                this.updateCurrentEditorContentFile();
            }
            catch (IOException ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                return false;
            }
            return true;
        }
        return this.saveFileAs();
    }

    private boolean saveFileAs() {
        File file = FileUtil.selectFileToSave((Component)this, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("sql-files"), new String[]{".sql"})});
        if (file != null) {
            this.openedFile = file;
            if (this.openedFile != null) {
                return this.saveFile();
            }
        }
        return false;
    }

    private boolean openFile(File file) {
        if (file != null) {
            this.newEditorContent();
            this.openedFile = file;
            try {
                this.updateLastOpenedFileList(this.openedFile.getAbsolutePath());
                this.textSqlEditor.loadFromFile(this.openedFile);
                this.textSqlEditor.setChanged(false);
                this.textSqlEditor.getEditorArea().getUndoManager().discardAllEdits();
                this.updateCurrentEditorContentFile();
                return true;
            }
            catch (IOException ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
        return false;
    }

    private boolean openFile() {
        File file = FileUtil.selectFileToOpen((Component)this, (File)this.openedFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("sql-files"), new String[]{".sql"})});
        return this.openFile(file);
    }

    private String getEditorContentPath() {
        String path = this.getApplication().getConfigPath() + "/sql-editor-contents/";
        path = this.autoSaveEditor == UniversalSettingsProvider.AUTO_SAVE_EDITOR_DRIVER ? path + this.getDatabase().getDriverType() : (this.autoSaveEditor == UniversalSettingsProvider.AUTO_SAVE_EDITOR_DB_SERVER ? path + FileUtil.prepareName((String)this.getDatabase().getUrl()) : (this.autoSaveEditor == UniversalSettingsProvider.AUTO_SAVE_EDITOR_SCHEMA ? path + this.getDatabase().getUserProperties().getProperty("schemaId") : path + "unknown"));
        if (this.tabNumber > 0) {
            path = path + "-no-" + this.tabNumber;
        }
        return path;
    }

    private void updateEditorContentActions() {
        this.cmPrevEditor.setEnabled(this.currentEditorContent != null && this.editorContentList.indexOf(this.currentEditorContent) > 0);
        this.cmNextEditor.setEnabled(this.currentEditorContent != null && this.editorContentList.indexOf(this.currentEditorContent) < this.editorContentList.size() - 1);
    }

    private void refreshEditorContentList(boolean autoLoad) {
        String configPath = this.getEditorContentPath();
        File dir = new File(configPath);
        dir.mkdirs();
        Object[] fileList = dir.list((FilenameFilter)new PatternFileFilter(WildCard.getRegex((String)"*.sql")));
        Arrays.sort(fileList);
        this.editorContentList.clear();
        for (int i = 0; i < fileList.length; ++i) {
            if (i > fileList.length - 100) {
                this.editorContentList.add(configPath + "/" + (String)fileList[i]);
                continue;
            }
            new File(configPath + "/" + (String)fileList[i]).delete();
        }
        if (!(this.currentEditorContent != null && this.editorContentList.contains(this.currentEditorContent) || this.editorContentList.size() <= 0)) {
            this.currentEditorContent = this.editorContentList.get(this.editorContentList.size() - 1);
            if (autoLoad) {
                try {
                    this.textSqlEditor.loadFromFile(this.currentEditorContent);
                    this.textSqlEditor.setChanged(false);
                    this.textSqlEditor.getEditorArea().getUndoManager().discardAllEdits();
                    this.restoreEditorContentSettings(this.currentEditorContent);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
        }
        if (this.currentEditorContent == null) {
            this.newEditorContent();
        } else {
            this.updateEditorContentActions();
        }
        this.updateCurrentEditorFileNameLabel();
    }

    private void newEditorContent() {
        if (this.currentEditorContent != null) {
            try {
                this.textSqlEditor.saveToFile(this.currentEditorContent);
                this.storeEditorContentSettings(this.currentEditorContent);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.openedFile = null;
        this.currentEditorContent = this.getEditorContentPath() + "/" + new UniqueID().toString() + ".sql";
        this.editorContentList.add(this.currentEditorContent);
        this.textSqlEditor.setText("");
        this.textSqlEditor.setChanged(false);
        this.textSqlEditor.getEditorArea().getUndoManager().discardAllEdits();
        this.updateEditorContentActions();
        this.updateCurrentEditorFileNameLabel();
    }

    private void deleteEditorContent() {
        if (this.currentEditorContent != null) {
            if (this.textSqlEditor.isChanged() && MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)this.stringManager.getString("SqlQueryPanelView-del-content-no-save-q"), (int[])ModalResult.YESNO) != 5) {
                return;
            }
            if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)this.stringManager.getString("SqlQueryPanelView-del-content-q"), (int[])ModalResult.YESNO) != 5) {
                return;
            }
            int index = this.editorContentList.indexOf(this.currentEditorContent);
            if (this.openedFile == null || !this.currentEditorContent.equals(this.openedFile.getAbsolutePath())) {
                new File(this.currentEditorContent).delete();
                this.deleteEditorContentSettings(this.currentEditorContent);
            }
            this.editorContentList.remove(index);
            this.currentEditorContent = null;
            if (this.editorContentList.size() > 0) {
                this.currentEditorContent = this.editorContentList.get(index < this.editorContentList.size() ? index : index - 1);
                try {
                    this.textSqlEditor.loadFromFile(this.currentEditorContent);
                    this.textSqlEditor.setChanged(false);
                    this.restoreEditorContentSettings(this.currentEditorContent);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                File file = new File(this.currentEditorContent);
                this.openedFile = !this.isAutoFile(file) ? file : null;
                this.updateEditorContentActions();
            } else {
                this.newEditorContent();
            }
        }
        this.updateCurrentEditorFileNameLabel();
    }

    public void processMessage(PluginMessage message) {
        if (message.isMessageId("universal-sql-query-settings-refresh")) {
            this.autoSaveEditorContentTimer.setInterval((long)this.globalSettings.getValue(UniversalSettingsProvider.setAutoSaveEditorContentIntervalSeconds, Long.valueOf(60L)).intValue() * 1000L);
            this.autoSaveEditorContent = this.globalSettings.getValue(UniversalSettingsProvider.setAutoSaveEditorContent, Boolean.valueOf(this.autoSaveEditorContent));
            this.autoSaveEditorContentTimer.setEnabled(this.autoSaveEditorContent);
        }
        if ("transaction-state-change".equals(message.getMessageId())) {
            this.setTransactionActionEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreEditorContentSettings(String fileName) {
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(fileName + ".properties");
            try {
                properties.load(fis);
                String lastCaretPosition = properties.getProperty("last-caret-position");
                String lastCaretView = properties.getProperty("last-caret-view");
                if (lastCaretPosition != null) {
                    this.textSqlEditor.getEditorArea().setCaretPosition(Integer.parseInt(lastCaretPosition));
                    if (lastCaretView != null) {
                        this.textSqlEditor.getScrollPane().getVerticalScrollBar().setValue(Integer.parseInt(lastCaretView));
                    }
                }
            }
            finally {
                fis.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            properties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEditorContentSettings(String fileName) {
        Properties properties = new Properties();
        try {
            properties.setProperty("last-caret-position", Integer.toString(this.textSqlEditor.getEditorArea().getCaretPosition()));
            properties.setProperty("last-caret-view", Integer.toString(this.textSqlEditor.getScrollPane().getVerticalScrollBar().getValue()));
            FileOutputStream fos = new FileOutputStream(fileName + ".properties");
            try {
                properties.store(fos, null);
            }
            finally {
                fos.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            properties = null;
        }
    }

    private void deleteEditorContentSettings(String fileName) {
        new File(fileName + ".properties").delete();
    }

    private void initComponents() {
        this.cmExecute = new Action();
        this.cmExecuteAsScript = new Action();
        this.cmShowHideError = new Action();
        this.cmExecutedSql = new Action();
        this.cmSaveFile = new Action();
        this.cmSaveFileAs = new Action();
        this.cmOpenFile = new Action();
        this.cmPrevEditor = new Action();
        this.cmNextEditor = new Action();
        this.cmNewEditor = new Action();
        this.cmDeleteEditor = new Action();
        this.menuView = new JMenu();
        this.menuExecute = new JMenuItem();
        this.menuStore = new JMenuItem();
        this.menuExecuteAsScript = new JMenuItem();
        this.menuExecutedSql = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.menuOpenFile = new JMenuItem();
        this.menuSaveFile = new JMenuItem();
        this.menuSaveFileAs = new JMenuItem();
        this.menuRecentFiles = new JMenu();
        this.jSeparator10 = new JSeparator();
        this.menuNewEditor = new JMenuItem();
        this.menuPrevEditor = new JMenuItem();
        this.menuNextEditor = new JMenuItem();
        this.menuDeleteEditor = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.menuCloneDatabase = new JMenuItem();
        this.menuSelectDatabase = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.menuCommit = new JMenuItem();
        this.menuRollback = new JMenuItem();
        this.cmSelectDatabase = new Action();
        this.cmStore = new Action();
        this.cmCloneDatabase = new Action();
        this.cmExecutePartial = new Action();
        this.menuActions = new JPopupMenu();
        this.popupRecentFiles = new JPopupMenu();
        this.cmPopupRecentFiles = new Action();
        this.cmDbCommit = new Action();
        this.cmDbRollback = new Action();
        this.cmEmpty = new Action();
        this.cmDBStartTransaction = new Action();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonOpenFile = new ToolButton();
        this.buttonRecentFiles = new ToolButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.buttonSaveFile = new ToolButton();
        this.buttonSaveFileAs = new ToolButton();
        this.jSeparator3 = new JSeparator();
        this.buttonNewEditor = new ToolButton();
        this.buttonPervEditor = new ToolButton();
        this.buttonNextEditor = new ToolButton();
        this.jSeparator4 = new JSeparator();
        this.buttonDeleteEditor = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonExecute = new ToolButton();
        this.buttonStore = new ToolButton();
        this.buttonExecuteAsScript = new ToolButton();
        this.buttonExecutedSql = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonCloneDatabase = new ToolButton();
        this.toolButton2 = new ToolButton();
        this.buttonDbCommit = new ToolButton();
        this.buttonDbRollback = new ToolButton();
        this.toolButton1 = new ToolButton();
        this.labelSelectedDatabase = new JLabel();
        this.buttonActions = new ToolButton();
        this.jSeparator6 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.labelFileName = new JLabel();
        this.splitPanel = new JSplitPane();
        this.panelSqlEditor = new JPanel();
        this.textSqlEditor = new OrbadaSyntaxTextArea();
        this.scrollSqlError = new JScrollPane();
        this.textSqlError = new JTextArea();
        this.tabbedViews = new JTabbedPane();
        this.cmExecute.setActionCommandKey("cmExecute");
        this.cmExecute.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmExecute.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_execute16.gif"));
        this.cmExecute.setText(this.stringManager.getString("cmExecute-text"));
        this.cmExecute.setTooltip(this.stringManager.getString("cmExecute-hint"));
        this.cmExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmExecuteActionPerformed(evt);
            }
        });
        this.cmExecuteAsScript.setActionCommandKey("cmExecuteAsScript");
        this.cmExecuteAsScript.setShortCut(KeyStroke.getKeyStroke(120, 2));
        this.cmExecuteAsScript.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_script_execute.gif"));
        this.cmExecuteAsScript.setText(this.stringManager.getString("cmExecuteAsScript-text"));
        this.cmExecuteAsScript.setTooltip(this.stringManager.getString("cmExecuteAsScript-hint"));
        this.cmExecuteAsScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmExecuteAsScriptActionPerformed(evt);
            }
        });
        this.cmShowHideError.setActionCommandKey("cmShowHideError");
        this.cmShowHideError.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/delete_square16.gif"));
        this.cmShowHideError.setTooltip(this.stringManager.getString("cmShowHideError-hint"));
        this.cmShowHideError.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmShowHideErrorActionPerformed(evt);
            }
        });
        this.cmExecutedSql.setActionCommandKey("cmExecutedSql");
        this.cmExecutedSql.setShortCut(KeyStroke.getKeyStroke(119, 2));
        this.cmExecutedSql.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/executed_sql16.gif"));
        this.cmExecutedSql.setText(this.stringManager.getString("cmExecutedSql-text"));
        this.cmExecutedSql.setTooltip(this.stringManager.getString("cmExecutedSql-hint"));
        this.cmExecutedSql.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmExecutedSqlActionPerformed(evt);
            }
        });
        this.cmSaveFile.setActionCommandKey("cmSaveFile");
        this.cmSaveFile.setShortCut(KeyStroke.getKeyStroke(83, 2));
        this.cmSaveFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmSaveFile.setText(this.stringManager.getString("cmSaveFile-text"));
        this.cmSaveFile.setTooltip(this.stringManager.getString("cmSaveFile-hint"));
        this.cmSaveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmSaveFileActionPerformed(evt);
            }
        });
        this.cmSaveFileAs.setActionCommandKey("cmSaveFileAs");
        this.cmSaveFileAs.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save_as16.gif"));
        this.cmSaveFileAs.setText(this.stringManager.getString("cmSaveFileAs-text"));
        this.cmSaveFileAs.setTooltip(this.stringManager.getString("cmSaveFileAs-hint"));
        this.cmSaveFileAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmSaveFileAsActionPerformed(evt);
            }
        });
        this.cmOpenFile.setActionCommandKey("cmOpenFile");
        this.cmOpenFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/open_document16.gif"));
        this.cmOpenFile.setText(this.stringManager.getString("cmOpenFile-text"));
        this.cmOpenFile.setTooltip(this.stringManager.getString("cmOpenFile-hint"));
        this.cmOpenFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmOpenFileActionPerformed(evt);
            }
        });
        this.cmPrevEditor.setActionCommandKey("cmPrevEditor");
        this.cmPrevEditor.setShortCut(KeyStroke.getKeyStroke(38, 9));
        this.cmPrevEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/arrowup.gif"));
        this.cmPrevEditor.setText(this.stringManager.getString("cmPrevEditor-text"));
        this.cmPrevEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmPrevEditorActionPerformed(evt);
            }
        });
        this.cmNextEditor.setActionCommandKey("cmNextEditor");
        this.cmNextEditor.setShortCut(KeyStroke.getKeyStroke(40, 9));
        this.cmNextEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/arrowdown.gif"));
        this.cmNextEditor.setText(this.stringManager.getString("cmNextEditor-text"));
        this.cmNextEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmNextEditorActionPerformed(evt);
            }
        });
        this.cmNewEditor.setActionCommandKey("cmNewEditor");
        this.cmNewEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_document16.gif"));
        this.cmNewEditor.setText(this.stringManager.getString("cmNewEditor-text"));
        this.cmNewEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmNewEditorActionPerformed(evt);
            }
        });
        this.cmDeleteEditor.setActionCommandKey("cmDeleteEditor");
        this.cmDeleteEditor.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/minus16.gif"));
        this.cmDeleteEditor.setText(this.stringManager.getString("cmDeleteEditor-text"));
        this.cmDeleteEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmDeleteEditorActionPerformed(evt);
            }
        });
        this.menuExecute.setAction((javax.swing.Action)this.cmExecute);
        this.menuView.add(this.menuExecute);
        this.menuStore.setAction((javax.swing.Action)this.cmStore);
        this.menuView.add(this.menuStore);
        this.menuExecuteAsScript.setAction((javax.swing.Action)this.cmExecuteAsScript);
        this.menuView.add(this.menuExecuteAsScript);
        this.menuExecutedSql.setAction((javax.swing.Action)this.cmExecutedSql);
        this.menuView.add(this.menuExecutedSql);
        this.menuView.add(this.jSeparator8);
        this.menuOpenFile.setAction((javax.swing.Action)this.cmOpenFile);
        this.menuView.add(this.menuOpenFile);
        this.menuSaveFile.setAction((javax.swing.Action)this.cmSaveFile);
        this.menuView.add(this.menuSaveFile);
        this.menuSaveFileAs.setAction((javax.swing.Action)this.cmSaveFileAs);
        this.menuView.add(this.menuSaveFileAs);
        this.menuRecentFiles.setText("Ostatnio otwarte pliki");
        this.menuRecentFiles.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                SqlQueryPanelView.this.menuRecentFilesMenuSelected(evt);
            }
        });
        this.menuView.add(this.menuRecentFiles);
        this.menuView.add(this.jSeparator10);
        this.menuNewEditor.setAction((javax.swing.Action)this.cmNewEditor);
        this.menuView.add(this.menuNewEditor);
        this.menuPrevEditor.setAction((javax.swing.Action)this.cmPrevEditor);
        this.menuView.add(this.menuPrevEditor);
        this.menuNextEditor.setAction((javax.swing.Action)this.cmNextEditor);
        this.menuView.add(this.menuNextEditor);
        this.menuDeleteEditor.setAction((javax.swing.Action)this.cmDeleteEditor);
        this.menuView.add(this.menuDeleteEditor);
        this.menuView.add(this.jSeparator7);
        this.menuCloneDatabase.setAction((javax.swing.Action)this.cmCloneDatabase);
        this.menuView.add(this.menuCloneDatabase);
        this.menuSelectDatabase.setAction((javax.swing.Action)this.cmSelectDatabase);
        this.menuView.add(this.menuSelectDatabase);
        this.menuView.add(this.jSeparator5);
        this.menuCommit.setAction((javax.swing.Action)this.cmDbCommit);
        this.menuView.add(this.menuCommit);
        this.menuRollback.setAction((javax.swing.Action)this.cmDbRollback);
        this.menuView.add(this.menuRollback);
        this.cmSelectDatabase.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/select16.gif"));
        this.cmSelectDatabase.setText(this.stringManager.getString("cmSelectDatabase-text"));
        this.cmSelectDatabase.setTooltip(this.stringManager.getString("cmSelectDatabase-hint"));
        this.cmSelectDatabase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmSelectDatabaseActionPerformed(evt);
            }
        });
        this.cmStore.setActionCommandKey("cmStore");
        this.cmStore.setShortCut(KeyStroke.getKeyStroke(120, 0));
        this.cmStore.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_sql_store.gif"));
        this.cmStore.setText(this.stringManager.getString("cmStore-text"));
        this.cmStore.setTooltip(this.stringManager.getString("cmStore-hint"));
        this.cmStore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmStoreActionPerformed(evt);
            }
        });
        this.cmCloneDatabase.setActionCommandKey("cmCloneDatabase");
        this.cmCloneDatabase.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/clone_database.gif"));
        this.cmCloneDatabase.setText(this.stringManager.getString("cmCloneDatabase-text"));
        this.cmCloneDatabase.setTooltip(this.stringManager.getString("cmCloneDatabase-hint"));
        this.cmCloneDatabase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmCloneDatabaseActionPerformed(evt);
            }
        });
        this.cmExecutePartial.setActionCommandKey("cmExecutePartial");
        this.cmExecutePartial.setShortCut(KeyStroke.getKeyStroke(10, 3));
        this.cmExecutePartial.setText(this.stringManager.getString("cmExecutePartial-text"));
        this.cmExecutePartial.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmExecutePartialActionPerformed(evt);
            }
        });
        this.popupRecentFiles.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SqlQueryPanelView.this.popupRecentFilesPopupMenuWillBecomeVisible(evt);
            }
        });
        this.cmPopupRecentFiles.setActionCommandKey("cmPopupRecentFiles");
        this.cmPopupRecentFiles.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/down10.gif"));
        this.cmPopupRecentFiles.setText(this.stringManager.getString("cmPopupRecentFiles-text"));
        this.cmPopupRecentFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmPopupRecentFilesActionPerformed(evt);
            }
        });
        this.cmDbCommit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/commit.gif"));
        this.cmDbCommit.setText(this.stringManager.getString("cmDbCommit-text"));
        this.cmDbCommit.setTooltip(this.stringManager.getString("cmDbCommit-hint"));
        this.cmDbCommit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmDbCommitActionPerformed(evt);
            }
        });
        this.cmDbRollback.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/rollback.gif"));
        this.cmDbRollback.setText(this.stringManager.getString("cmDbRollback-text"));
        this.cmDbRollback.setTooltip(this.stringManager.getString("cmDbRollback-hint"));
        this.cmDbRollback.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmDbRollbackActionPerformed(evt);
            }
        });
        this.cmEmpty.setEnabled(false);
        this.cmEmpty.setText(this.stringManager.getString("cmEmpty-text"));
        this.cmDBStartTransaction.setActionCommandKey("cmDBStartTransaction");
        this.cmDBStartTransaction.setEnabled(false);
        this.cmDBStartTransaction.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/start_transaction.gif"));
        this.cmDBStartTransaction.setText(this.stringManager.getString("cmDBStartTransaction-text"));
        this.cmDBStartTransaction.setTooltip(this.stringManager.getString("cmDBStartTransaction-hint"));
        this.cmDBStartTransaction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryPanelView.this.cmDBStartTransactionActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SqlQueryPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonOpenFile.setAction((javax.swing.Action)this.cmOpenFile);
        this.buttonOpenFile.setHorizontalTextPosition(0);
        this.buttonOpenFile.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonOpenFile);
        this.buttonRecentFiles.setAction((javax.swing.Action)this.cmPopupRecentFiles);
        this.buttonRecentFiles.setHorizontalTextPosition(0);
        this.buttonRecentFiles.setMaximumSize(new Dimension(12, 26));
        this.buttonRecentFiles.setMinimumSize(new Dimension(12, 26));
        this.buttonRecentFiles.setPreferredSize(new Dimension(12, 26));
        this.buttonRecentFiles.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRecentFiles);
        this.toolBar.add(this.jSeparator9);
        this.buttonSaveFile.setAction((javax.swing.Action)this.cmSaveFile);
        this.buttonSaveFile.setHorizontalTextPosition(0);
        this.buttonSaveFile.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSaveFile);
        this.buttonSaveFileAs.setAction((javax.swing.Action)this.cmSaveFileAs);
        this.buttonSaveFileAs.setHorizontalTextPosition(0);
        this.buttonSaveFileAs.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSaveFileAs);
        this.jSeparator3.setOrientation(1);
        this.toolBar.add(this.jSeparator3);
        this.buttonNewEditor.setAction((javax.swing.Action)this.cmNewEditor);
        this.buttonNewEditor.setHorizontalTextPosition(0);
        this.buttonNewEditor.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonNewEditor);
        this.buttonPervEditor.setAction((javax.swing.Action)this.cmPrevEditor);
        this.buttonPervEditor.setHorizontalTextPosition(0);
        this.buttonPervEditor.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonPervEditor);
        this.buttonNextEditor.setAction((javax.swing.Action)this.cmNextEditor);
        this.buttonNextEditor.setHorizontalTextPosition(0);
        this.buttonNextEditor.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonNextEditor);
        this.jSeparator4.setOrientation(1);
        this.toolBar.add(this.jSeparator4);
        this.buttonDeleteEditor.setAction((javax.swing.Action)this.cmDeleteEditor);
        this.buttonDeleteEditor.setHorizontalTextPosition(0);
        this.buttonDeleteEditor.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonDeleteEditor);
        this.jSeparator2.setOrientation(1);
        this.toolBar.add(this.jSeparator2);
        this.buttonExecute.setAction((javax.swing.Action)this.cmExecute);
        this.buttonExecute.setHorizontalTextPosition(0);
        this.buttonExecute.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonExecute);
        this.buttonStore.setAction((javax.swing.Action)this.cmStore);
        this.buttonStore.setHorizontalTextPosition(0);
        this.buttonStore.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonStore);
        this.buttonExecuteAsScript.setAction((javax.swing.Action)this.cmExecuteAsScript);
        this.buttonExecuteAsScript.setHorizontalTextPosition(0);
        this.buttonExecuteAsScript.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonExecuteAsScript);
        this.buttonExecutedSql.setAction((javax.swing.Action)this.cmExecutedSql);
        this.toolBar.add((Component)this.buttonExecutedSql);
        this.jSeparator1.setOrientation(1);
        this.toolBar.add(this.jSeparator1);
        this.buttonCloneDatabase.setAction((javax.swing.Action)this.cmCloneDatabase);
        this.buttonCloneDatabase.setHorizontalTextPosition(0);
        this.buttonCloneDatabase.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonCloneDatabase);
        this.toolButton2.setAction((javax.swing.Action)this.cmDBStartTransaction);
        this.toolButton2.setHorizontalTextPosition(0);
        this.toolButton2.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton2);
        this.buttonDbCommit.setAction((javax.swing.Action)this.cmDbCommit);
        this.buttonDbCommit.setHorizontalTextPosition(0);
        this.buttonDbCommit.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonDbCommit);
        this.buttonDbRollback.setAction((javax.swing.Action)this.cmDbRollback);
        this.buttonDbRollback.setHorizontalTextPosition(0);
        this.buttonDbRollback.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonDbRollback);
        this.toolButton1.setAction((javax.swing.Action)this.cmSelectDatabase);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.toolButton1);
        this.labelSelectedDatabase.setText(" ");
        this.toolBar.add(this.labelSelectedDatabase);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonActions);
        this.jSeparator6.setOrientation(1);
        this.toolBar.add(this.jSeparator6);
        this.jPanel1.add((Component)this.toolBar, "West");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.labelFileName.setText(" ");
        this.jPanel2.add(this.labelFileName);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.add((Component)this.jPanel1, "North");
        this.splitPanel.setBorder(null);
        this.splitPanel.setDividerLocation(250);
        this.splitPanel.setOrientation(0);
        this.splitPanel.setResizeWeight(1.0);
        this.splitPanel.setContinuousLayout(true);
        this.splitPanel.setOneTouchExpandable(true);
        this.panelSqlEditor.setPreferredSize(new Dimension(146, 300));
        this.panelSqlEditor.setLayout(new BorderLayout());
        this.panelSqlEditor.add((Component)this.textSqlEditor, "Center");
        this.textSqlError.setColumns(20);
        this.textSqlError.setEditable(false);
        this.textSqlError.setFont(new Font("Courier New", 0, 11));
        this.textSqlError.setRows(5);
        this.scrollSqlError.setViewportView(this.textSqlError);
        this.panelSqlEditor.add((Component)this.scrollSqlError, "South");
        this.splitPanel.setTopComponent(this.panelSqlEditor);
        this.tabbedViews.setFocusable(false);
        this.tabbedViews.setPreferredSize(new Dimension(100, 80));
        this.splitPanel.setBottomComponent(this.tabbedViews);
        this.add((Component)this.splitPanel, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlQueryPanelView.this.textSqlEditor.getEditorArea().requestFocusInWindow();
            }
        });
    }

    private void cmSelectDatabaseActionPerformed(ActionEvent evt) {
        Database database = SelectDatabaseDialog.show(this.getDatabase(), false);
        if (database != null) {
            if (this.clonedDatabase != null && !database.equals(this.clonedDatabase)) {
                this.closeCloneDatabase();
                this.buttonCloneDatabase.setSelected(false);
                this.menuCloneDatabase.setSelected(false);
            }
            this.setCurrentDatabase(database);
        }
    }

    private void cmPrevEditorActionPerformed(ActionEvent evt) {
        if (this.currentEditorContent != null) {
            try {
                this.textSqlEditor.saveToFile(this.currentEditorContent);
                this.storeEditorContentSettings(this.currentEditorContent);
            }
            catch (IOException ex) {
                // empty catch block
            }
            int index = this.editorContentList.indexOf(this.currentEditorContent);
            if (index > 0) {
                this.currentEditorContent = this.editorContentList.get(index - 1);
                try {
                    this.textSqlEditor.loadFromFile(this.currentEditorContent);
                    this.restoreEditorContentSettings(this.currentEditorContent);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            this.textSqlEditor.setChanged(false);
            this.textSqlEditor.getEditorArea().getUndoManager().discardAllEdits();
            File file = new File(this.currentEditorContent);
            this.openedFile = !this.isAutoFile(file) ? file : null;
        }
        this.updateEditorContentActions();
        this.updateCurrentEditorFileNameLabel();
    }

    private void cmNextEditorActionPerformed(ActionEvent evt) {
        if (this.currentEditorContent != null) {
            try {
                this.textSqlEditor.saveToFile(this.currentEditorContent);
                this.storeEditorContentSettings(this.currentEditorContent);
            }
            catch (IOException ex) {
                // empty catch block
            }
            int index = this.editorContentList.indexOf(this.currentEditorContent);
            if (index < this.editorContentList.size() - 1) {
                this.currentEditorContent = this.editorContentList.get(index + 1);
                try {
                    this.textSqlEditor.loadFromFile(this.currentEditorContent);
                    this.restoreEditorContentSettings(this.currentEditorContent);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            this.textSqlEditor.setChanged(false);
            this.textSqlEditor.getEditorArea().getUndoManager().discardAllEdits();
            File file = new File(this.currentEditorContent);
            this.openedFile = !this.isAutoFile(file) ? file : null;
        }
        this.updateEditorContentActions();
        this.updateCurrentEditorFileNameLabel();
    }

    private void cmDeleteEditorActionPerformed(ActionEvent evt) {
        this.deleteEditorContent();
    }

    private void cmNewEditorActionPerformed(ActionEvent evt) {
        this.newEditorContent();
    }

    private void cmSaveFileAsActionPerformed(ActionEvent evt) {
        this.saveFileAs();
    }

    private void cmSaveFileActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private void cmOpenFileActionPerformed(ActionEvent evt) {
        if (this.textSqlEditor.isChanged() && this.openedFile != null) {
            switch (MessageBox.show((Component)null, (String)this.stringManager.getString("saving-file"), (String)String.format(this.stringManager.getString("SqlQueryPanelView-content-changed-save-it-q"), this.openedFile.getName()), (int[])ModalResult.YESNOCANCEL)) {
                case 5: {
                    if (this.saveFile()) break;
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        this.openFile();
    }

    private void cmExecutedSqlActionPerformed(ActionEvent evt) {
        String sqlText = ExecutedSqlCommandDialog.showDialog(this.getDatabase());
        if (sqlText != null) {
            if (this.textSqlEditor.getEditorArea().getSelectionEnd() != this.textSqlEditor.getEditorArea().getSelectionStart()) {
                this.textSqlEditor.getEditorArea().replaceSelection(sqlText);
            } else {
                this.textSqlEditor.getEditorArea().insert(sqlText + "\n", this.textSqlEditor.getEditorArea().getCaretPosition());
            }
        }
    }

    private void cmShowHideErrorActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlQueryPanelView.this.scrollSqlError.setVisible(!SqlQueryPanelView.this.scrollSqlError.isVisible());
            }
        });
    }

    private void cmExecuteActionPerformed(ActionEvent evt) {
        final ActionEvent event = evt;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlQueryPanelView.this.scrollSqlError.setVisible(false);
                SqlQueryPanelView.this.buttonShowHideError.setVisible(false);
            }
        });
        String currentSqlText = this.textSqlEditor.getCurrentText();
        if (currentSqlText == null) {
            this.textSqlEditor.getStatusBar().getPanel(PANEL_STATUS).setText(" " + this.stringManager.getString("SqlQueryPanelView-no-current-sql-e") + " ");
            return;
        }
        String oryginalSqlText = currentSqlText;
        boolean changedSqlText = false;
        UniversalSqlTextTransformProvider[] usttp = (UniversalSqlTextTransformProvider[])this.accesibilities.getApplication().getServiceArray(UniversalSqlTextTransformProvider.class);
        if (usttp != null && usttp.length > 0) {
            for (int i = 0; i < usttp.length; ++i) {
                String newSqlText;
                if (!usttp[i].isForDatabase(this.getDatabase()) || (newSqlText = usttp[i].transformSqlText(this.currentDatabase, currentSqlText)) == null && !"".equals(newSqlText)) continue;
                currentSqlText = newSqlText;
                changedSqlText = true;
            }
        }
        if (StringUtil.isEmpty((String)currentSqlText)) {
            this.textSqlEditor.getStatusBar().getPanel(PANEL_STATUS).setText(" " + this.stringManager.getString("SqlQueryPanelView-no-command-e") + " ");
            return;
        }
        this.setUniversalActionServicesProperties(changedSqlText, oryginalSqlText);
        boolean isSelect = SQLUtil.isSelect((String)currentSqlText);
        if (!"cmStore".equals(event.getActionCommand())) {
            String tempText = SQLUtil.removeComments((String)currentSqlText);
            tempText = SQLUtil.removeLineComment((String)tempText);
            if ((tempText = SQLUtil.removeStrings((String)tempText)).length() > 1 && StringUtil.charCount((String)tempText, (char)';') == 1 && tempText.charAt(tempText.length() - 1) == ';') {
                currentSqlText = currentSqlText.substring(0, currentSqlText.length() - 1);
            }
        }
        final String sqlText = currentSqlText;
        if (this.globalSettings.getValue(UniversalSettingsProvider.setAutoExpandSqlText, Boolean.valueOf(false)).booleanValue() && changedSqlText && this.textSqlEditor.getEditorArea().getSelectionStart() == this.textSqlEditor.getEditorArea().getSelectionEnd()) {
            this.textSqlEditor.getEditorArea().setSelectionStart(this.textSqlEditor.getStartCurrentText());
            this.textSqlEditor.getEditorArea().setSelectionEnd(this.textSqlEditor.getEndCurrentText());
            this.textSqlEditor.getEditorArea().replaceSelection(sqlText);
        }
        this.textSqlEditor.getStatusBar().getPanel(PANEL_STATUS).setText(" " + this.stringManager.getString("SqlQueryPanelView-executed-command-3d"));
        if (isSelect && !"cmStore".equals(event.getActionCommand())) {
            final SqlQueryResultPanel panel = this.getResultPanel();
            final TabCloseComponent tabComponent = (TabCloseComponent)this.tabbedViews.getTabComponentAt(this.tabbedViews.indexOfComponent(panel));
            tabComponent.setCloseable(false);
            this.getDatabase().getTaskPool().addTask(new Task(String.format(this.stringManager.getString("SqlQueryPanelView-universal-query-exec-3d"), sqlText.substring(0, Math.min(50, sqlText.length())))){

                public void run() {
                    if (!SqlQueryPanelView.this.isVisible() || this.isCanceled()) {
                        return;
                    }
                    PleaseWait wait = PleaseWait.createSqlWait((String)sqlText.substring(0, Math.min(50, sqlText.length())), (int)2000);
                    SqlQueryPanelView.this.accesibilities.getApplication().startPleaseWait(wait);
                    try {
                        if (!panel.openQuery(sqlText)) {
                            SqlQueryPanelView.this.textSqlEditor.getStatusBar().getPanel(SqlQueryPanelView.PANEL_STATUS).setText(" " + SqlQueryPanelView.this.stringManager.getString("SqlQueryPanelView-cancel-execution-info") + " ");
                        } else {
                            SqlQueryPanelView.this.historyPanel.add(panel.getQuery());
                            ExecutedSqlManager.get().addSqlText(sqlText, SqlQueryPanelView.this.getDatabase().getUserProperties().getProperty("schemaId"));
                            SqlQueryPanelView.this.textSqlEditor.getStatusBar().getPanel(SqlQueryPanelView.PANEL_STATUS).setText(" " + SqlQueryPanelView.this.stringManager.getString("SqlQueryPanelView-command-executed-properly-info") + " ");
                        }
                        tabComponent.setCloseable(true);
                        SqlQueryPanelView.this.accesibilities.getApplication().stopPleaseWait(wait);
                    }
                    catch (Throwable e) {
                        SqlQueryPanelView.this.accesibilities.getApplication().stopPleaseWait(wait);
                        String message = e.getMessage();
                        if (message != null) {
                            if (message.length() > 120) {
                                message = e.getMessage().substring(0, 120) + "...";
                            }
                            SqlQueryPanelView.this.textSqlEditor.getStatusBar().getPanel(SqlQueryPanelView.PANEL_STATUS).setText(" " + message + " ");
                        } else {
                            ExceptionUtil.processException((Throwable)e);
                        }
                        SqlQueryPanelView.this.textSqlError.setText(ExceptionUtil.getStackTrace((Throwable)e));
                        if (e instanceof Exception) {
                            SqlQueryPanelView.this.historyPanel.add(panel.getQuery());
                            SqlQueryPanelView.this.fireEventPanel(EventPanel.QUERY_ERROR, panel.getQuery(), null, (Exception)e);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                SqlQueryPanelView.this.buttonShowHideError.setVisible(true);
                                SqlQueryPanelView.this.scrollSqlError.setVisible(false);
                                tabComponent.setCloseable(true);
                                if (SqlQueryPanelView.this.globalSettings.getValue(UniversalSettingsProvider.setOnErrorShowMessageBox, Boolean.valueOf(false)).booleanValue()) {
                                    ErrorBox.show(e);
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.getDatabase().getTaskPool().addTask(new Task(String.format(this.stringManager.getString("SqlQueryPanelView-universal-call-execution-3d"), sqlText.substring(0, Math.min(50, sqlText.length())))){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!SqlQueryPanelView.this.isVisible() || this.isCanceled()) {
                        return;
                    }
                    PleaseWait wait = PleaseWait.createSqlWait((String)sqlText.substring(0, Math.min(50, sqlText.length())), (int)2000);
                    SqlQueryPanelView.this.accesibilities.getApplication().startPleaseWait(wait);
                    Command command = SqlQueryPanelView.this.getDatabase().createCommand();
                    try {
                        if ("cmStore".equals(event.getActionCommand())) {
                            command.setParamCheck(false);
                        }
                        command.setSqlText(sqlText);
                        if (command.getParameterList().parameterCount() > 0 && !CommandParametersDialog.showDialog((ParametrizedCommand)command)) {
                            SqlQueryPanelView.this.textSqlEditor.getStatusBar().getPanel(SqlQueryPanelView.PANEL_STATUS).setText(" " + SqlQueryPanelView.this.stringManager.getString("SqlQueryPanelView-cancel-execution-info") + " ");
                            SqlQueryPanelView.this.accesibilities.getApplication().stopPleaseWait(wait);
                            return;
                        }
                        SqlQueryPanelView.this.fireEventPanel(EventPanel.BEFORE_EXECUTE_COMMAND, null, command, null);
                        SqlQueryPanelView.this.scriptResultPanel.setCommand(command);
                        try {
                            command.execute();
                        }
                        finally {
                            SqlQueryPanelView.this.scriptResultPanel.setCommand(null);
                        }
                        SqlQueryPanelView.this.fireEventPanel(EventPanel.AFTER_EXECUTE_COMMAND, null, command, null);
                        if (command.getStatement() != null) {
                            ResultSet rs = command.getStatement().getResultSet();
                            while (rs != null) {
                                SqlQueryResultPanel panel = SqlQueryPanelView.this.getResultPanel();
                                panel.closeQuery();
                                panel.getQuery().setResultSet(rs);
                                if (!command.getStatement().getMoreResults()) break;
                                rs = command.getStatement().getResultSet();
                            }
                        }
                        boolean outParams = false;
                        for (int i = 0; i < command.getParameterCount(); ++i) {
                            if (command.getParameter(i).getParamMode() != 4 && command.getParameter(i).getParamMode() != 2) continue;
                            SqlQueryPanelView.this.scriptResultPanel.append(command.getParameter(i).getParamName() + " = [" + command.getParameter(i).getString() + "]\n");
                            outParams = true;
                        }
                        SqlQueryPanelView.this.historyPanel.add(command);
                        ExecutedSqlManager.get().addSqlText(sqlText, SqlQueryPanelView.this.getDatabase().getUserProperties().getProperty("schemaId"));
                        SqlQueryPanelView.this.textSqlEditor.getStatusBar().getPanel(SqlQueryPanelView.PANEL_STATUS).setText(" " + String.format(SqlQueryPanelView.this.stringManager.getString("SqlQueryPanelView-command-exec-properly-records-info") + ", " + StringUtil.formatTime((long)command.getExecutionTime()), command.getUpdateCount()) + (outParams ? SqlQueryPanelView.this.stringManager.getString("SqlQueryPanelView-command-exec-out-params-info") : ""));
                        SqlQueryPanelView.this.accesibilities.getApplication().stopPleaseWait(wait);
                    }
                    catch (Throwable e) {
                        SqlQueryPanelView.this.accesibilities.getApplication().stopPleaseWait(wait);
                        String message = e.getMessage();
                        if (message != null && message.length() > 120) {
                            message = e.getMessage().substring(0, 120) + "...";
                        }
                        SqlQueryPanelView.this.textSqlEditor.getStatusBar().getPanel(SqlQueryPanelView.PANEL_STATUS).setText(" " + message + " ");
                        SqlQueryPanelView.this.textSqlError.setText(ExceptionUtil.getStackTrace((Throwable)e));
                        if (e instanceof Exception) {
                            SqlQueryPanelView.this.historyPanel.add(command);
                            SqlQueryPanelView.this.fireEventPanel(EventPanel.COMMAND_ERROR, null, command, (Exception)e);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                SqlQueryPanelView.this.buttonShowHideError.setVisible(true);
                                SqlQueryPanelView.this.scrollSqlError.setVisible(false);
                                if (SqlQueryPanelView.this.globalSettings.getValue(UniversalSettingsProvider.setOnErrorShowMessageBox, Boolean.valueOf(false)).booleanValue()) {
                                    ErrorBox.show(e);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void cmExecuteAsScriptActionPerformed(ActionEvent evt) {
        this.tabbedViews.setSelectedComponent(this.scriptResultPanel);
        this.scriptResultPanel.execute(this.getDatabase(), this.textSqlEditor.getText());
    }

    private void cmStoreActionPerformed(ActionEvent evt) {
        this.cmExecute.actionPerformed(evt);
    }

    private void cmCloneDatabaseActionPerformed(ActionEvent evt) {
        if (this.buttonCloneDatabase.isSelected()) {
            this.closeCloneDatabase();
        } else {
            this.cloneDatabase();
        }
    }

    private void cmExecutePartialActionPerformed(ActionEvent evt) {
        this.cmExecute.actionPerformed(evt);
    }

    private void menuRecentFilesMenuSelected(MenuEvent evt) {
        this.createMenuLastOpenedFile(this.menuRecentFiles);
    }

    private void popupRecentFilesPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.createMenuLastOpenedFile(this.popupRecentFiles);
    }

    private void cmPopupRecentFilesActionPerformed(ActionEvent evt) {
        this.popupRecentFiles.show((Component)this.buttonRecentFiles, 0, this.buttonRecentFiles.getHeight());
    }

    private void cmDbCommitActionPerformed(ActionEvent evt) {
        try {
            this.getDatabase().commit();
        }
        catch (SQLException ex) {
            MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmDbRollbackActionPerformed(ActionEvent evt) {
        try {
            this.getDatabase().rollback();
        }
        catch (SQLException ex) {
            MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmDBStartTransactionActionPerformed(ActionEvent evt) {
        try {
            this.getDatabase().startTransaction();
        }
        catch (SQLException ex) {
            MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private class ContentEditorFile {
        public String fileName;
        public boolean autoName;

        private ContentEditorFile() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UniversalViewAccessibilities
    implements IUniversalViewAccessibilities {
        private UniversalViewAccessibilities() {
        }

        @Override
        public IViewAccesibilities getViewAccesibilities() {
            return SqlQueryPanelView.this.accesibilities;
        }

        @Override
        public SyntaxEditor getSyntaxEditor() {
            return SqlQueryPanelView.this.textSqlEditor.getEditorArea();
        }

        @Override
        public void addResultTab(String title, JComponent component) {
            SqlQueryPanelView.this.addUniversalViewTab(title, component);
        }

        @Override
        public Component[] getResultTabs(Class<? extends Component> clazz) {
            return SqlQueryPanelView.this.getResultTabs(clazz);
        }

        @Override
        public void setSelectedTab(Component component) {
            SqlQueryPanelView.this.tabbedViews.setSelectedComponent(component);
        }

        @Override
        public void setTabTooltip(Component component, String tooltip) {
            SqlQueryPanelView.this.setTabTooltip(component, tooltip);
        }

        @Override
        public void setTabTitle(Component component, String title) {
            SqlQueryPanelView.this.setTabTooltip(component, title);
        }
    }

    class OpenRecentFileAction
    extends Action {
        private File file;

        public OpenRecentFileAction(String fileName) {
            this.file = new File(fileName);
            this.setText(this.file.getName());
            this.setTooltip(fileName);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            SqlQueryPanelView.this.openFile(this.file);
        }
    }

    class TabAddResultAction
    extends Action {
        public TabAddResultAction() {
            this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/add12.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            SqlQueryPanelView.this.addResultTab();
        }
    }

    class TabCloseAction
    extends Action {
        Component component;

        public TabCloseAction(Component component) {
            this.component = component;
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            SqlQueryPanelView.this.closePanel(this.component);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventPanel {
        BEFORE_OPEN_QUERY,
        AFTER_OPEN_QUERY,
        BEFORE_CLOSE_QUERY,
        AFTER_CLOSE_QUERY,
        QUERY_ERROR,
        BEFORE_EXECUTE_COMMAND,
        AFTER_EXECUTE_COMMAND,
        COMMAND_ERROR;

    }
}

