/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.CommandParametersDialog;
import pl.mpak.orbada.universal.gui.SqlQueryPanelView;
import pl.mpak.orbada.universal.services.UniversalSettingsProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.br.QueryBufferedRecord;
import pl.mpak.usedb.core.CacheRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumnModel;
import pl.mpak.usedb.gui.swing.QueryTableModel;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.JdbcUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.usedb.util.SqlTableName;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringTokenizer;

public class SqlQueryResultPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private static final ArrayList<ArrayList<String>> storedColumnList = new ArrayList();
    private SqlQueryPanelView ownerPanel;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private ArrayList<String> primaryKeyColumns;
    private int lastRowIndex = -1;
    private CacheRecord lastRecord = null;
    private QueryBufferedRecord updateRecord;
    private boolean insertRecord = false;
    private DatabaseInfoProvider infoService;
    private JPanel editPanel;
    private ISettings settings;
    private ToolButton buttonActions;
    private ToolButton buttonApplyRecord;
    private ToolButton buttonDeleteRecord;
    private ToolButton buttonEditData;
    private ToolButton buttonInsertRecord;
    private ToolButton buttonRollbackRecord;
    private ToolButton buttonStopExecuting;
    private Action cmApplyRecord;
    private Action cmDeleteRecord;
    private Action cmEditData;
    private Action cmInsertRecord;
    private Action cmNewResultPanel;
    private Action cmRecordCount;
    private Action cmRollbackRecord;
    private Action cmStopExecuting;
    private DataTable dataTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JMenuItem menuEditData;
    private JMenuItem menuRecordCount;
    private QueryTableStatusBar statusBar;
    private JToolBar toolBar;

    public SqlQueryResultPanel(SqlQueryPanelView ownerPanel) {
        this.ownerPanel = ownerPanel;
        this.primaryKeyColumns = new ArrayList();
        this.settings = ownerPanel.getApplication().getSettings(UniversalSettingsProvider.settingsName);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.dataTable.setDefaultEditor(Boolean.class, (TableCellEditor)new DefaultCellEditor(new JTextField()));
        this.dataTable.setDefaultEditor(String.class, (TableCellEditor)new DefaultCellEditor(new JTextField()));
        this.dataTable.setDefaultEditor(Number.class, (TableCellEditor)new DefaultCellEditor(new JTextField()));
        this.dataTable.setDefaultEditor(Date.class, (TableCellEditor)new DefaultCellEditor(new JTextField()));
        this.dataTable.setDefaultEditor(Time.class, (TableCellEditor)new DefaultCellEditor(new JTextField()));
        this.dataTable.setDefaultEditor(Timestamp.class, (TableCellEditor)new DefaultCellEditor(new JTextField()));
        this.getQuery().setDatabase(this.ownerPanel.getDatabase());
        this.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void beforeOpen(EventObject e) {
                SqlQueryResultPanel.this.cmStopExecuting.setEnabled(true);
            }

            public void afterOpen(EventObject e) {
                SqlQueryResultPanel.this.cmStopExecuting.setEnabled(false);
                SqlQueryResultPanel.this.cmEditData.setEnabled(true);
                SqlQueryResultPanel.this.cmRecordCount.setEnabled(true);
            }

            public void beforeClose(EventObject e) {
                SqlQueryResultPanel.this.cmEditData.setEnabled(false);
                SqlQueryResultPanel.this.cmRecordCount.setEnabled(false);
            }

            public void errorPerformed(EventObject e) {
                SqlQueryResultPanel.this.cmStopExecuting.setEnabled(false);
                SqlQueryResultPanel.this.cmRecordCount.setEnabled(false);
            }
        });
        this.dataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SqlQueryResultPanel.this.getQuery().isActive() && SqlQueryResultPanel.this.dataTable.getSelectedRow() >= 0 && ((QueryTableModel)SqlQueryResultPanel.this.dataTable.getModel()).isEditable()) {
                    SqlQueryResultPanel.this.cmApplyRecord.performe();
                    try {
                        SqlQueryResultPanel.this.lastRowIndex = SqlQueryResultPanel.this.dataTable.getSelectedRow();
                        SqlQueryResultPanel.this.lastRecord = SqlQueryResultPanel.this.getQuery().getRecord(SqlQueryResultPanel.this.lastRowIndex);
                        SqlQueryResultPanel.this.updateRecord.updateFrom(SqlQueryResultPanel.this.getQuery());
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.initEditPanel();
        SwingUtil.addAction((JComponent)this.dataTable, (javax.swing.Action)this.cmInsertRecord);
        SwingUtil.addAction((JComponent)this.dataTable, (javax.swing.Action)this.cmDeleteRecord);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.dataTable, (JButton)this.buttonActions, this.menuActions, "orbada-universal-sql-result-content-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlQueryResultPanel.this.buttonActions.setHideActionText(true);
                SqlQueryResultPanel.this.buttonActions.setPreferredSize(null);
            }
        });
    }

    private void initEditPanel() {
        this.editPanel = new JPanel(new FlowLayout(0, 1, 0));
        this.statusBar.addBefore((Component)this.statusBar.getPanel("panel.recno"), (Component)this.editPanel);
        this.editPanel.add((Component)this.buttonInsertRecord);
        this.editPanel.add((Component)this.buttonApplyRecord);
        this.editPanel.add((Component)this.buttonRollbackRecord);
        this.editPanel.add((Component)this.buttonDeleteRecord);
        this.editPanel.setVisible(false);
    }

    public Query getQuery() {
        return this.dataTable.getQuery();
    }

    public Database getDatabase() {
        return this.dataTable.getQuery().getDatabase();
    }

    private boolean showParameters(ParametrizedCommand command) {
        return command.getParameterList().parameterCount() <= 0 || CommandParametersDialog.showDialog(command);
    }

    private int findColumnList() {
        Object PRESENT = new Object();
        TableColumnModel model = this.dataTable.getColumnModel();
        HashMap<String, Object> columnSet = new HashMap<String, Object>();
        for (int c = 0; c < model.getColumnCount(); ++c) {
            columnSet.put(model.getColumn(c).getHeaderValue().toString(), PRESENT);
        }
        for (int i = 0; i < storedColumnList.size(); ++i) {
            ArrayList<String> columnList = storedColumnList.get(i);
            if (columnList.size() != model.getColumnCount()) continue;
            boolean found = true;
            for (String s : columnList) {
                if (columnSet.containsKey(s)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    private void storeColumnPositions() {
        final int maxColumnListCount = this.settings.getValue(UniversalSettingsProvider.setMaxColumnListCount, Long.valueOf(10L)).intValue();
        SwingUtil.invokeAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                ArrayList arrayList = storedColumnList;
                synchronized (arrayList) {
                    int index = SqlQueryResultPanel.this.findColumnList();
                    if (index >= 0) {
                        storedColumnList.remove(index);
                    }
                    ArrayList<String> columnList = new ArrayList<String>();
                    TableColumnModel model = SqlQueryResultPanel.this.dataTable.getColumnModel();
                    for (int c = 0; c < model.getColumnCount(); ++c) {
                        columnList.add(model.getColumn(c).getHeaderValue().toString());
                    }
                    storedColumnList.add(0, columnList);
                    while (storedColumnList.size() > maxColumnListCount) {
                        storedColumnList.remove(storedColumnList.size() - 1);
                    }
                }
                return null;
            }
        });
    }

    private void restoreColumnPositions() {
        SwingUtil.invokeAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                ArrayList arrayList = storedColumnList;
                synchronized (arrayList) {
                    int index = SqlQueryResultPanel.this.findColumnList();
                    if (index >= 0) {
                        ArrayList columnList = (ArrayList)storedColumnList.get(index);
                        QueryTableColumnModel model = (QueryTableColumnModel)SqlQueryResultPanel.this.dataTable.getColumnModel();
                        HashMap<String, TableColumn> columnSet = new HashMap<String, TableColumn>();
                        while (model.getColumnCount() > 0) {
                            TableColumn tc = model.remove(0);
                            columnSet.put(tc.getHeaderValue().toString(), tc);
                        }
                        for (int i = 0; i < columnList.size(); ++i) {
                            model.add((TableColumn)columnSet.get(columnList.get(i)));
                        }
                        storedColumnList.remove(index);
                        storedColumnList.add(0, columnList);
                    }
                }
                return null;
            }
        });
    }

    public boolean openQuery(String sqlText) throws Exception {
        boolean storingColumnListPosition = this.settings.getValue(UniversalSettingsProvider.setStoringColumnListPosition, Boolean.valueOf(true));
        this.ownerPanel.setTabTooltip(this, null);
        ((QueryTableModel)this.dataTable.getModel()).setEditable(false);
        this.lastRecord = null;
        this.lastRowIndex = -1;
        this.buttonEditData.setSelected(false);
        this.cmEditData.setEnabled(false);
        this.cmDeleteRecord.setEnabled(false);
        this.cmInsertRecord.setEnabled(false);
        this.cmApplyRecord.setEnabled(false);
        this.cmRollbackRecord.setEnabled(false);
        this.editPanel.setVisible(false);
        if (this.getQuery().isActive() && storingColumnListPosition) {
            this.storeColumnPositions();
        }
        if (this.getQuery().isActive()) {
            this.ownerPanel.fireEventPanel(SqlQueryPanelView.EventPanel.BEFORE_CLOSE_QUERY, this.getQuery(), null, null);
            this.getQuery().close();
            this.ownerPanel.fireEventPanel(SqlQueryPanelView.EventPanel.AFTER_CLOSE_QUERY, this.getQuery(), null, null);
        }
        if (!this.getQuery().getDatabase().equals(this.ownerPanel.getDatabase())) {
            this.getQuery().setDatabase(this.ownerPanel.getDatabase());
        }
        this.getQuery().setSqlText(sqlText);
        if (!this.showParameters((ParametrizedCommand)this.getQuery())) {
            return false;
        }
        this.ownerPanel.fireEventPanel(SqlQueryPanelView.EventPanel.BEFORE_OPEN_QUERY, this.getQuery(), null, null);
        this.getQuery().open();
        this.ownerPanel.fireEventPanel(SqlQueryPanelView.EventPanel.AFTER_OPEN_QUERY, this.getQuery(), null, null);
        if (!this.getQuery().eof()) {
            SwingUtil.invokeAndWait((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SqlQueryResultPanel.this.dataTable.changeSelection(0, 0, false, false);
                    SqlQueryResultPanel.this.lastRowIndex = SqlQueryResultPanel.this.dataTable.getSelectedRow();
                    return null;
                }
            });
            this.lastRecord = this.getQuery().getRecord(this.lastRowIndex);
        }
        if (storingColumnListPosition) {
            this.restoreColumnPositions();
        }
        this.revalidate();
        this.ownerPanel.setTabTooltip(this, SQLUtil.createTooltipFromSql((String)sqlText));
        return true;
    }

    public void closeQuery() {
        this.updateRecord = null;
        this.buttonEditData.setSelected(false);
        this.cmEditData.setEnabled(false);
        this.cmDeleteRecord.setEnabled(false);
        this.cmInsertRecord.setEnabled(false);
        this.cmApplyRecord.setEnabled(false);
        this.cmRollbackRecord.setEnabled(false);
        this.editPanel.setVisible(false);
        ((QueryTableModel)this.dataTable.getModel()).setEditable(false);
        this.getQuery().close();
        this.cmEditData.setTooltip(this.stringManager.getString("cmEditData-hint-on"));
        this.lastRecord = null;
        this.lastRowIndex = -1;
    }

    public void close() throws IOException {
        this.setVisible(false);
        this.getQuery().close();
        this.ownerPanel = null;
    }

    private void checkSqlForEdit(String sqlCode) {
        this.infoService = null;
        DatabaseInfoProvider[] dips = (DatabaseInfoProvider[])this.ownerPanel.getApplication().getServiceArray(DatabaseInfoProvider.class);
        if (dips != null && dips.length > 0) {
            for (DatabaseInfoProvider dip : dips) {
                if (!dip.isForDatabase(this.getDatabase())) continue;
                this.infoService = dip;
                break;
            }
        }
        String error = "";
        boolean okay = false;
        StringTokenizer st = new StringTokenizer(sqlCode, ",", " \n\r\t");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!"from".equalsIgnoreCase(token)) continue;
            if (!st.hasMoreTokens()) break;
            token = st.nextToken();
            if (token.length() <= 0 || token.charAt(0) == '(') {
                error = error + this.stringManager.getString("cmEditData-hint-error-no-subq");
                break;
            }
            SqlTableName name = SQLUtil.parseSqlTableName((String)token);
            this.catalogName = name.getCatalogName();
            this.schemaName = name.getSchemaName();
            this.tableName = name.getTableName();
            okay = true;
            if (!st.hasMoreTokens()) break;
            token = st.nextToken();
            if ("as".equalsIgnoreCase(token)) {
                token = st.nextToken();
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                }
            } else if (!(",".equals(token) || "left".equalsIgnoreCase(token) || "right".equalsIgnoreCase(token) || "outer".equalsIgnoreCase(token) || "inner".equalsIgnoreCase(token) || !st.hasMoreTokens())) {
                token = st.nextToken();
            }
            if (",".equals(token) || "left".equalsIgnoreCase(token) || "right".equalsIgnoreCase(token) || "outer".equalsIgnoreCase(token) || "inner".equalsIgnoreCase(token)) {
                error = error + this.stringManager.getString("cmEditData-hint-error-one-table");
                okay = false;
                break;
            }
            okay = true;
            break;
        }
        if (!okay) {
            this.cmEditData.setEnabled(false);
            this.cmEditData.setTooltip("<html>" + this.stringManager.getString("cmEditData-hint-error") + "<br>" + error);
        } else if (this.setTableEditable()) {
            this.cmEditData.setTooltip("<html>" + String.format(this.stringManager.getString("cmEditData-hint-on-edit-data"), this.getDatabase().quoteName(this.catalogName, this.schemaName, this.tableName)));
            this.cmEditData.setEnabled(true);
        } else {
            this.cmEditData.setEnabled(false);
        }
    }

    private boolean setTableEditable() {
        String[] fields;
        this.primaryKeyColumns.clear();
        if (this.infoService != null) {
            fields = this.infoService.getUniqueIdentFields(this.getDatabase(), this.catalogName, this.schemaName, this.tableName);
            if (fields != null) {
                this.primaryKeyColumns.addAll(Arrays.asList(fields));
            }
        } else {
            fields = JdbcUtil.getPrimaryKeyFields((Database)this.getDatabase(), (String)this.catalogName, (String)this.schemaName, (String)this.tableName);
            if (fields != null) {
                this.primaryKeyColumns.addAll(Arrays.asList(fields));
            }
        }
        if (this.primaryKeyColumns.isEmpty()) {
            this.cmEditData.setTooltip(this.stringManager.getString("cmEditData-hint-primary-key") + "<br>" + this.getDatabase().quoteName(this.catalogName, this.schemaName, this.tableName) + " " + Arrays.toString(this.primaryKeyColumns.toArray()));
            return false;
        }
        for (String field : this.primaryKeyColumns) {
            if (this.getQuery().findFieldByName(field) != null) continue;
            this.cmEditData.setTooltip(this.stringManager.getString("cmEditData-hint-pk-column") + "<br>" + this.getDatabase().quoteName(this.catalogName, this.schemaName, this.tableName) + " " + Arrays.toString(this.primaryKeyColumns.toArray()));
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.buttonRollbackRecord = new ToolButton();
        this.buttonApplyRecord = new ToolButton();
        this.buttonInsertRecord = new ToolButton();
        this.buttonDeleteRecord = new ToolButton();
        this.cmStopExecuting = new Action();
        this.cmNewResultPanel = new Action();
        this.cmEditData = new Action();
        this.cmDeleteRecord = new Action();
        this.cmInsertRecord = new Action();
        this.cmApplyRecord = new Action();
        this.cmRollbackRecord = new Action();
        this.cmRecordCount = new Action();
        this.menuActions = new JPopupMenu();
        this.menuEditData = new JMenuItem();
        this.menuRecordCount = new JMenuItem();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.dataTable = new DataTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonStopExecuting = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonEditData = new ToolButton();
        this.buttonActions = new ToolButton();
        this.buttonRollbackRecord.setAction((javax.swing.Action)this.cmRollbackRecord);
        this.buttonRollbackRecord.setHorizontalTextPosition(0);
        this.buttonRollbackRecord.setPreferredSize(new Dimension(20, 16));
        this.buttonRollbackRecord.setVerticalTextPosition(3);
        this.buttonApplyRecord.setAction((javax.swing.Action)this.cmApplyRecord);
        this.buttonApplyRecord.setHorizontalTextPosition(0);
        this.buttonApplyRecord.setPreferredSize(new Dimension(20, 16));
        this.buttonApplyRecord.setVerticalTextPosition(3);
        this.buttonInsertRecord.setAction((javax.swing.Action)this.cmInsertRecord);
        this.buttonInsertRecord.setHorizontalTextPosition(0);
        this.buttonInsertRecord.setPreferredSize(new Dimension(20, 16));
        this.buttonInsertRecord.setVerticalTextPosition(3);
        this.buttonDeleteRecord.setAction((javax.swing.Action)this.cmDeleteRecord);
        this.buttonDeleteRecord.setHorizontalTextPosition(0);
        this.buttonDeleteRecord.setPreferredSize(new Dimension(20, 16));
        this.buttonDeleteRecord.setVerticalTextPosition(3);
        this.cmStopExecuting.setEnabled(false);
        this.cmStopExecuting.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/cancel.gif"));
        this.cmStopExecuting.setTooltip(this.stringManager.getString("cmStopExecuting-hint"));
        this.cmStopExecuting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmStopExecutingActionPerformed(evt);
            }
        });
        this.cmNewResultPanel.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add_table16.gif"));
        this.cmNewResultPanel.setText(this.stringManager.getString("cmNewResultPanel-text"));
        this.cmNewResultPanel.setTooltip(this.stringManager.getString("cmNewResultPanel-hint"));
        this.cmNewResultPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmNewResultPanelActionPerformed(evt);
            }
        });
        this.cmEditData.setActionCommandKey("cmEditData");
        this.cmEditData.setEnabled(false);
        this.cmEditData.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit_table.gif"));
        this.cmEditData.setText(this.stringManager.getString("cmEditData-text"));
        this.cmEditData.setTooltip(this.stringManager.getString("cmEditData-hint"));
        this.cmEditData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmEditDataActionPerformed(evt);
            }
        });
        this.cmDeleteRecord.setActionCommandKey("cmDeleteRecord");
        this.cmDeleteRecord.setEnabled(false);
        this.cmDeleteRecord.setShortCut(KeyStroke.getKeyStroke(127, 2));
        this.cmDeleteRecord.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/minus9.gif"));
        this.cmDeleteRecord.setText(this.stringManager.getString("cmDeleteRecord-text"));
        this.cmDeleteRecord.setTooltip(this.stringManager.getString("cmDeleteRecord-hint"));
        this.cmDeleteRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmDeleteRecordActionPerformed(evt);
            }
        });
        this.cmInsertRecord.setActionCommandKey("cmInsertRecord");
        this.cmInsertRecord.setEnabled(false);
        this.cmInsertRecord.setShortCut(KeyStroke.getKeyStroke(155, 0));
        this.cmInsertRecord.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add8.gif"));
        this.cmInsertRecord.setText(this.stringManager.getString("cmInsertRecord-text"));
        this.cmInsertRecord.setTooltip(this.stringManager.getString("cmInsertRecord-hint"));
        this.cmInsertRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmInsertRecordActionPerformed(evt);
            }
        });
        this.cmApplyRecord.setActionCommandKey("cmApplyRecord");
        this.cmApplyRecord.setEnabled(false);
        this.cmApplyRecord.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/commit10.gif"));
        this.cmApplyRecord.setText(this.stringManager.getString("cmApplyRecord-text"));
        this.cmApplyRecord.setTooltip(this.stringManager.getString("cmApplyRecord-hint"));
        this.cmApplyRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmApplyRecordActionPerformed(evt);
            }
        });
        this.cmRollbackRecord.setActionCommandKey("cmRollbackRecord");
        this.cmRollbackRecord.setEnabled(false);
        this.cmRollbackRecord.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/rollback10.gif"));
        this.cmRollbackRecord.setText(this.stringManager.getString("cmRollbackRecord-text"));
        this.cmRollbackRecord.setTooltip(this.stringManager.getString("cmRollbackRecord-hint"));
        this.cmRollbackRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmRollbackRecordActionPerformed(evt);
            }
        });
        this.cmRecordCount.setActionCommandKey("cmRecordCount");
        this.cmRecordCount.setEnabled(false);
        this.cmRecordCount.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/counts.gif"));
        this.cmRecordCount.setText(this.stringManager.getString("cmRecordCount-text"));
        this.cmRecordCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlQueryResultPanel.this.cmRecordCountActionPerformed(evt);
            }
        });
        this.menuEditData.setAction((javax.swing.Action)this.cmEditData);
        this.menuActions.add(this.menuEditData);
        this.menuRecordCount.setAction((javax.swing.Action)this.cmRecordCount);
        this.menuActions.add(this.menuRecordCount);
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.dataTable);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setTable((QueryTable)this.dataTable);
        this.jPanel2.add((Component)this.statusBar, "South");
        this.add((Component)this.jPanel2, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        this.toolBar.setRollover(true);
        this.buttonStopExecuting.setAction((javax.swing.Action)this.cmStopExecuting);
        this.buttonStopExecuting.setHorizontalTextPosition(0);
        this.buttonStopExecuting.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonStopExecuting);
        this.toolBar.add(this.jSeparator1);
        this.buttonEditData.setAction((javax.swing.Action)this.cmEditData);
        this.buttonEditData.setHorizontalTextPosition(0);
        this.buttonEditData.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonEditData);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel1.add((Component)this.toolBar, "West");
        this.add((Component)this.jPanel1, "West");
    }

    private void cmNewResultPanelActionPerformed(ActionEvent evt) {
        this.ownerPanel.addResultTab();
    }

    private void cmStopExecutingActionPerformed(ActionEvent evt) {
        try {
            this.cmStopExecuting.setEnabled(false);
            this.getQuery().cancel();
        }
        catch (SQLException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmEditDataActionPerformed(ActionEvent evt) {
        if (!this.buttonEditData.isSelected()) {
            this.checkSqlForEdit(this.getQuery().getSqlText());
            if (!this.cmEditData.isEnabled()) {
                return;
            }
        }
        try {
            this.updateRecord = new QueryBufferedRecord(this.getDatabase().quoteName(this.catalogName, this.schemaName, this.tableName), this.primaryKeyColumns.toArray(new String[this.primaryKeyColumns.size()]), this.getQuery());
            this.lastRowIndex = this.dataTable.getSelectedRow();
            if (this.lastRowIndex != -1) {
                this.lastRecord = this.getQuery().getRecord(this.lastRowIndex);
                this.updateRecord.updateFrom(this.getQuery());
            }
            this.buttonEditData.setSelected(!this.buttonEditData.isSelected());
            ((QueryTableModel)this.dataTable.getModel()).setEditable(this.buttonEditData.isSelected());
            this.cmDeleteRecord.setEnabled(this.buttonEditData.isSelected());
            this.cmInsertRecord.setEnabled(this.buttonEditData.isSelected());
            this.cmApplyRecord.setEnabled(this.buttonEditData.isSelected());
            this.cmRollbackRecord.setEnabled(this.buttonEditData.isSelected());
            this.editPanel.setVisible(this.buttonEditData.isSelected());
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmApplyRecordActionPerformed(ActionEvent evt) {
        try {
            if (this.lastRecord != null && this.lastRecord.isChanged()) {
                this.getQuery().getRecord(this.lastRecord.getIndex());
                this.updateRecord.updateValues(this.getQuery());
                if (this.insertRecord) {
                    this.updateRecord.applyInsert();
                } else {
                    this.updateRecord.applyUpdate();
                }
                this.getQuery().update(this.lastRecord);
                this.insertRecord = false;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmDeleteRecordActionPerformed(ActionEvent evt) {
        if (this.dataTable.getSelectedRow() != -1) {
            try {
                CacheRecord record = this.getQuery().getRecord(this.dataTable.getSelectedRow());
                this.updateRecord.updateFrom(this.getQuery());
                this.updateRecord.applyDelete();
                this.getQuery().delete(record);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SqlQueryResultPanel.this.lastRowIndex = SqlQueryResultPanel.this.dataTable.getSelectedRow();
                        if (SqlQueryResultPanel.this.lastRowIndex != -1) {
                            try {
                                SqlQueryResultPanel.this.lastRecord = SqlQueryResultPanel.this.getQuery().getRecord(SqlQueryResultPanel.this.lastRowIndex);
                                SqlQueryResultPanel.this.updateRecord.updateFrom(SqlQueryResultPanel.this.getQuery());
                            }
                            catch (Exception ex) {
                                ExceptionUtil.processException((Throwable)ex);
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmRollbackRecordActionPerformed(ActionEvent evt) {
        try {
            if (this.lastRecord != null && this.lastRecord.isChanged()) {
                this.getQuery().getRecord(this.lastRecord.getIndex());
                this.updateRecord.cancelUpdates();
                this.lastRecord.cancelUpdates();
                this.dataTable.repaint();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmInsertRecordActionPerformed(ActionEvent evt) {
        try {
            this.lastRecord = new CacheRecord();
            for (int i = 0; i < this.getQuery().getFieldCount(); ++i) {
                this.lastRecord.add();
            }
            this.getQuery().append(this.lastRecord);
            this.lastRowIndex = this.lastRecord.getIndex();
            this.dataTable.changeSelection(this.lastRowIndex, this.dataTable.getSelectedColumn(), false, false);
            this.updateRecord.updateFrom(this.getQuery());
            this.insertRecord = true;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmRecordCountActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.setSqlText("select count( 0 ) cnt from (" + this.getQuery().getSqlText() + ") x");
            for (int i = 0; i < this.getQuery().getParameterCount(); ++i) {
                query.paramByName(this.getQuery().getParameter(i).getParamName()).setValue((Object)this.getQuery().getParameter(i).getValue(), this.getQuery().getParameter(i).getParamDataType());
            }
            query.open();
            String sqlText = this.getQuery().getSqlText();
            if (sqlText.length() > 200) {
                sqlText = sqlText.substring(0, 200) + "...";
            }
            MessageBox.show((Component)this, (String)this.stringManager.getString("record-count"), (String)String.format(this.stringManager.getString("SqlQueryResultPanel-record-count-info"), sqlText, query.fieldByName("cnt").getLong()), (int)1, (int)1);
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            query.close();
        }
    }
}

