/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui;

import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.services.UniversalSettingsProvider;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalSessionSettingsProviderPanel
extends JPanel
implements Closeable,
ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IApplication application;
    private ISettings settings;
    private Database database;
    private JCheckBox checkAutoCommit;
    private ComboBox comboAutoCloneConnection;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public UniversalSessionSettingsProviderPanel(IApplication application, Database database) {
        this.application = application;
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboAutoCloneConnection.setModel(new DefaultComboBoxModel<String>(new String[]{this.stringManager.getString("global-settings"), this.stringManager.getString("clone"), this.stringManager.getString("not-clone")}));
        this.settings = this.application.getSettings(this.database.getUserProperties().getProperty("schemaId"), "universal-query-panel");
        this.restoreSettings();
    }

    public void restoreSettings() {
        try {
            if (this.database.getMetaData().supportsTransactions()) {
                this.checkAutoCommit.setSelected(this.database.getConnection().getAutoCommit());
            } else {
                this.checkAutoCommit.setEnabled(false);
            }
            this.comboAutoCloneConnection.setSelectedIndex(this.settings.getValue(UniversalSettingsProvider.setAutoCloneConnection, Long.valueOf(0L)).intValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void applySettings() {
        if (this.checkAutoCommit.isEnabled()) {
            try {
                this.database.setAutoCommit(this.checkAutoCommit.isSelected());
                this.settings.setValue(UniversalSettingsProvider.setAutoCloneConnection, Long.valueOf(this.comboAutoCloneConnection.getSelectedIndex()));
                this.settings.store();
            }
            catch (SQLException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    public void close() throws IOException {
    }

    private void initComponents() {
        this.checkAutoCommit = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboAutoCloneConnection = new ComboBox();
        this.checkAutoCommit.setText(this.stringManager.getString("UniversalSessionSettingsProviderPanel-auto-commit"));
        this.jLabel1.setText(this.stringManager.getString("UniversalSessionSettingsProviderPanel-set-below-no-schema-info"));
        this.jLabel2.setText(this.stringManager.getString("GeneralSettingsPanel-auto-clone-connection"));
        this.comboAutoCloneConnection.setModel(new DefaultComboBoxModel<String>(new String[]{"Global setting", "Clone", "Not clone"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkAutoCommit).addComponent(this.jLabel1, -1, 400, Short.MAX_VALUE).addComponent(this.jLabel2).addComponent((Component)this.comboAutoCloneConnection, -2, 164, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoCommit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboAutoCloneConnection, -2, -1, -2).addContainerGap(208, Short.MAX_VALUE)));
    }
}

