/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.execmd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.execmd.ExecutedSqlManager;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.HtmlUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPool;
import pl.mpak.util.variant.Variant;

public class ExecutedSqlCommandDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private int modalResult = 0;
    private String sqlText;
    private String selectedFileId;
    private Database database;
    private String schemaId;
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonInsert;
    private Action cmCancel;
    private Action cmInsert;
    private Action cmSearch;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel labelInfo;
    private JSplitPane split;
    private DataTable tableSqlCommands;
    private TextField textFind;
    private OrbadaSyntaxTextArea textSqlCommand;
    private ToolButton toolButton1;

    public ExecutedSqlCommandDialog(Database database) {
        super(SwingUtil.getRootFrame());
        this.database = database;
        this.schemaId = database.getUserProperties().getProperty("schemaId");
        this.initComponents();
        this.init();
    }

    public static String showDialog(Database database) {
        ExecutedSqlCommandDialog dialog = new ExecutedSqlCommandDialog(database);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            return dialog.sqlText;
        }
        return null;
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-execmd-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(800)).getInteger(), this.settings.getValue("height", new Variant(500)).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonInsert);
        this.textSqlCommand.getEditorArea().setEditable(false);
        this.textSqlCommand.setDatabase(this.database);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ExecutedSqlCommandDialog.this.textFind.requestFocusInWindow();
                ExecutedSqlCommandDialog.this.split.setDividerLocation(0.75);
            }
        });
        this.tableSqlCommands.getQuery().setDatabase(ExecutedSqlManager.get().getDatabase());
        this.tableSqlCommands.addColumn((TableColumn)new QueryTableColumn("cmd_source", this.stringManager.getString("sql-command"), 700, (TableCellRenderer)new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, (Object)row, hasFocus, hasFocus, row, row);
                try {
                    String sqlText = HtmlUtil.prepareText((String)SQLUtil.removeWhiteSpaces((String)value.toString()));
                    label.setForeground(stringColor);
                    label.setText("<html>" + sqlText);
                    label.setHorizontalAlignment(2);
                    label.setVerticalAlignment(1);
                    if (isSelected) {
                        label.setBackground(selectionBackground);
                    }
                }
                catch (Throwable ex) {
                    ExceptionUtil.processException((Throwable)ex);
                    label.setText("<html>" + value.toString());
                }
                return label;
            }
        }));
        this.tableSqlCommands.setAutoResizeMode(4);
        this.tableSqlCommands.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = ExecutedSqlCommandDialog.this.tableSqlCommands.getSelectedRow();
                if (rowIndex >= 0 && ExecutedSqlCommandDialog.this.tableSqlCommands.getQuery().isActive()) {
                    try {
                        ExecutedSqlCommandDialog.this.tableSqlCommands.getQuery().getRecord(rowIndex);
                        ExecutedSqlCommandDialog.this.selectedFileId = ExecutedSqlCommandDialog.this.tableSqlCommands.getQuery().fieldByName("cmd_file_id").getString();
                        ExecutedSqlCommandDialog.this.sqlText = ExecutedSqlCommandDialog.this.tableSqlCommands.getQuery().fieldByName("cmd_source").getString();
                        ExecutedSqlCommandDialog.this.textSqlCommand.setText(ExecutedSqlCommandDialog.this.sqlText);
                        ExecutedSqlCommandDialog.this.textSqlCommand.getEditorArea().setCaretPosition(0);
                        ExecutedSqlCommandDialog.this.labelInfo.setText(String.format(ExecutedSqlCommandDialog.this.stringManager.getString("ExecutedSqlCommandDialog-sql-command-info"), ExecutedSqlCommandDialog.this.tableSqlCommands.getQuery().fieldByName("cmd_executed").getTimestamp(), ExecutedSqlCommandDialog.this.tableSqlCommands.getQuery().fieldByName("cmd_selected").getTimestamp(), ExecutedSqlCommandDialog.this.tableSqlCommands.getQuery().fieldByName("cmd_executed_count").getInteger()));
                        ExecutedSqlCommandDialog.this.cmInsert.setEnabled(true);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    ExecutedSqlCommandDialog.this.cmInsert.setEnabled(false);
                }
            }
        });
        this.tableSqlCommands.setRowHeight(70);
        try {
            this.tableSqlCommands.getQuery().setSqlText("select * from execmds\n where cmd_usr_id = :cmd_usr_id\n   and (cmd_sch_id = :cmd_sch_id or cmd_sch_id is null)\n   and (cmd_source like '%'||:cmd_source||'%' or cmd_source like '%'||upper(:cmd_source)||'%' or :cmd_source is null)\n order by cmd_selected desc");
            this.refresh();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.textFind.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.tableSqlCommands));
        SwingUtil.addAction((JComponent)this.textFind, (javax.swing.Action)this.cmSearch);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        this.tableSqlCommands.getQuery().close();
        super.dispose();
    }

    private void refresh() {
        try {
            this.tableSqlCommands.getQuery().close();
            this.tableSqlCommands.getQuery().paramByName("cmd_usr_id").setString(Application.get().getUserId());
            this.tableSqlCommands.getQuery().paramByName("cmd_sch_id").setString(this.schemaId);
            this.tableSqlCommands.getQuery().paramByName("cmd_source").setString(this.textFind.getText());
            this.tableSqlCommands.getQuery().open();
            if (!this.tableSqlCommands.getQuery().isEmpty()) {
                this.tableSqlCommands.changeSelection(0, this.tableSqlCommands.getSelectedColumn(), false, false);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmInsert = new Action();
        this.cmSearch = new Action();
        this.buttonCancel = new JButton();
        this.buttonInsert = new JButton();
        this.labelInfo = new JLabel();
        this.textFind = new TextField();
        this.jLabel1 = new JLabel();
        this.toolButton1 = new ToolButton();
        this.split = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tableSqlCommands = new DataTable();
        this.textSqlCommand = new OrbadaSyntaxTextArea();
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExecutedSqlCommandDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmInsert.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmInsert.setText(this.stringManager.getString("cmInsert-text"));
        this.cmInsert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExecutedSqlCommandDialog.this.cmInsertActionPerformed(evt);
            }
        });
        this.cmSearch.setActionCommandKey("cmSearch");
        this.cmSearch.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmSearch.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_object16.gif"));
        this.cmSearch.setText(this.stringManager.getString("cmSearch-text"));
        this.cmSearch.setTooltip(this.stringManager.getString("cmSearch-hint"));
        this.cmSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExecutedSqlCommandDialog.this.cmSearchActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExecutedSqlCommandDialog-title"));
        this.setModal(true);
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.buttonInsert.setAction((javax.swing.Action)this.cmInsert);
        this.buttonInsert.setPreferredSize(new Dimension(75, 23));
        this.labelInfo.setText(" ");
        this.jLabel1.setText(this.stringManager.getString("search-dd"));
        this.toolButton1.setAction((javax.swing.Action)this.cmSearch);
        this.toolButton1.setPreferredSize(new Dimension(24, 24));
        this.split.setBorder(null);
        this.split.setDividerLocation(200);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jScrollPane1.setViewportView((Component)this.tableSqlCommands);
        this.split.setLeftComponent(this.jScrollPane1);
        this.split.setRightComponent((Component)this.textSqlCommand);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.split, -1, 601, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelInfo, -1, 441, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonInsert, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textFind, -1, 517, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toolButton1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.toolButton1, -2, -1, -2).addComponent((Component)this.textFind, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.split, -1, 370, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonInsert, -2, -1, -2).addComponent(this.labelInfo)).addContainerGap()));
        this.pack();
    }

    private void cmInsertActionPerformed(ActionEvent evt) {
        TaskPool.getTaskPool().addTask(new Task(){

            public void run() {
                ExecutedSqlManager.get().updateSelected(ExecutedSqlCommandDialog.this.selectedFileId);
            }
        });
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmSearchActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

