/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.filter;

import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.filter.DefinedFilterComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.cm.FilterDefAction;
import pl.mpak.orbada.universal.gui.filter.cm.FilterTurnOffAction;
import pl.mpak.sky.gui.swing.BaseAction;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFilter {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    public static Icon filterOnIcon = null;
    public static Icon filterOffIcon = null;
    private ISettings settings;
    private SqlFilterDef definition;
    private Action action;
    private AbstractButton button;
    private boolean turnedOn;
    private SqlFilterComponent[] filterComponent;
    private ArrayList<DefinedFilterComponent> filterComponentList = new ArrayList();
    private JPopupMenu menu;
    private boolean silentDialog;
    private FilterTurnOffAction cmFilterTurnOff;

    public SqlFilter(ISettings settings, Action action, AbstractButton button, SqlFilterDef definition) {
        this.filterComponent = new SqlFilterComponent[5];
        for (int i = 0; i < this.filterComponent.length; ++i) {
            this.filterComponent[i] = new SqlFilterComponent();
        }
        this.button = button;
        this.action = action;
        this.settings = settings;
        this.definition = definition;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlFilter.this.action.putValue("Name", SqlFilter.this.stringManager.getString("filter-definition-3d"));
                SqlFilter.this.cmFilterTurnOff = new FilterTurnOffAction(SqlFilter.this);
                SqlFilter.this.loadSettings();
                SqlFilter.this.updateAction();
                SqlFilter.this.prepareMenu();
            }
        });
    }

    public SqlFilter(ISettings settings, Action action, SqlFilterDef definition) {
        this(settings, action, null, definition);
    }

    private void loadSettings() {
        this.turnedOn = this.settings.getValue("turned-on", Boolean.valueOf(this.turnedOn));
        for (int i = 0; i < this.filterComponent.length; ++i) {
            this.filterComponent[i].setTurnedOn(this.settings.getValue("turned-on-" + i, Boolean.valueOf(this.filterComponent[i].isTurnedOn())));
            this.filterComponent[i].setOperator(this.settings.getValue("operator-" + i, this.filterComponent[i].getOperator()));
            this.filterComponent[i].setColumnName(this.settings.getValue("column-name-" + i, this.filterComponent[i].getColumnName()));
            this.filterComponent[i].setCondition(this.settings.getValue("condition-" + i, this.filterComponent[i].getCondition()));
            this.filterComponent[i].setValue(this.settings.getValue("value-" + i, this.filterComponent[i].getValue()));
        }
        this.filterComponentList.add(new DefinedFilterComponent(this.filterComponent));
        long fdc = this.settings.getValue("filter-def-count", Long.valueOf(0L)) + 1L;
        int d = 1;
        while ((long)d < fdc) {
            DefinedFilterComponent def = new DefinedFilterComponent(this.settings.getValue(d + "-name", "<undefined>"));
            for (int i = 0; i < def.getFilterComponent().length; ++i) {
                def.getFilterComponent()[i].setTurnedOn(this.settings.getValue(d + "-turned-on-" + i, Boolean.valueOf(def.getFilterComponent()[i].isTurnedOn())));
                def.getFilterComponent()[i].setOperator(this.settings.getValue(d + "-operator-" + i, def.getFilterComponent()[i].getOperator()));
                def.getFilterComponent()[i].setColumnName(this.settings.getValue(d + "-column-name-" + i, def.getFilterComponent()[i].getColumnName()));
                def.getFilterComponent()[i].setCondition(this.settings.getValue(d + "-condition-" + i, def.getFilterComponent()[i].getCondition()));
                def.getFilterComponent()[i].setValue(this.settings.getValue(d + "-value-" + i, def.getFilterComponent()[i].getValue()));
            }
            this.filterComponentList.add(def);
            ++d;
        }
    }

    public void storeSettings() {
        this.settings.setValue("turned-on", Boolean.valueOf(this.turnedOn));
        for (int i = 0; i < this.filterComponent.length; ++i) {
            this.settings.setValue("turned-on-" + i, Boolean.valueOf(this.filterComponent[i].isTurnedOn()));
            this.settings.setValue("operator-" + i, this.filterComponent[i].getOperator());
            this.settings.setValue("column-name-" + i, this.filterComponent[i].getColumnName());
            this.settings.setValue("condition-" + i, this.filterComponent[i].getCondition());
            this.settings.setValue("value-" + i, this.filterComponent[i].getValue());
        }
        this.settings.store();
    }

    public void storeSettings(DefinedFilterComponent def, long index) {
        this.settings.setValue("filter-def-count", Long.valueOf((long)this.filterComponentList.size() - 1L));
        if (def == null) {
            return;
        }
        this.settings.setValue(index + "-name", def.getName());
        for (int i = 0; i < def.getFilterComponent().length; ++i) {
            this.settings.setValue(index + "-turned-on-" + i, Boolean.valueOf(def.getFilterComponent()[i].isTurnedOn()));
            this.settings.setValue(index + "-operator-" + i, def.getFilterComponent()[i].getOperator());
            this.settings.setValue(index + "-column-name-" + i, def.getFilterComponent()[i].getColumnName());
            this.settings.setValue(index + "-condition-" + i, def.getFilterComponent()[i].getCondition());
            this.settings.setValue(index + "-value-" + i, def.getFilterComponent()[i].getValue());
        }
        this.settings.store();
    }

    public void setDefComponents(DefinedFilterComponent def) {
        for (int i = 0; i < this.filterComponent.length; ++i) {
            this.filterComponent[i].setTurnedOn(def.getFilterComponent()[i].isTurnedOn());
            this.filterComponent[i].setColumnName(def.getFilterComponent()[i].getColumnName());
            this.filterComponent[i].setCondition(def.getFilterComponent()[i].getCondition());
            this.filterComponent[i].setOperator(def.getFilterComponent()[i].getOperator());
            this.filterComponent[i].setValue(def.getFilterComponent()[i].getValue());
        }
    }

    private void updateAction() {
        if (filterOnIcon == null || filterOffIcon == null) {
            filterOnIcon = ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif");
            filterOffIcon = ImageManager.getImage((String)"/pl/mpak/res/icons/filter_off16.gif");
        }
        if (this.action != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (SqlFilter.this.action instanceof BaseAction) {
                        if (SqlFilter.this.turnedOn) {
                            ((BaseAction)SqlFilter.this.action).setSmallIcon(filterOnIcon);
                        } else {
                            ((BaseAction)SqlFilter.this.action).setSmallIcon(filterOffIcon);
                        }
                        ((BaseAction)SqlFilter.this.action).setTooltip(SqlFilter.this.getTooltip());
                    } else {
                        if (SqlFilter.this.turnedOn) {
                            SqlFilter.this.action.putValue("SmallIcon", filterOnIcon);
                        } else {
                            SqlFilter.this.action.putValue("SmallIcon", filterOffIcon);
                        }
                        SqlFilter.this.action.putValue("ShortDescription", SqlFilter.this.getTooltip());
                    }
                    SqlFilter.this.cmFilterTurnOff.setEnabled(SqlFilter.this.turnedOn);
                }
            });
        }
    }

    private void prepareMenu() {
        if (this.button != null && this.menu == null) {
            this.menu = new JPopupMenu("Filtr");
            this.menu.addPopupMenuListener(this.getPopupMenuListener());
            this.button.setComponentPopupMenu(this.menu);
        }
    }

    private PopupMenuListener getPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SqlFilter.this.menu.removeAll();
                SqlFilter.this.menu.add(SqlFilter.this.action);
                if (SqlFilter.this.filterComponentList.size() > 1) {
                    SqlFilter.this.menu.addSeparator();
                    for (int d = 1; d < SqlFilter.this.filterComponentList.size(); ++d) {
                        SqlFilter.this.menu.add((Action)((Object)new FilterDefAction(SqlFilter.this, (DefinedFilterComponent)SqlFilter.this.filterComponentList.get(d))));
                    }
                }
                SqlFilter.this.menu.addSeparator();
                SqlFilter.this.menu.add((Action)((Object)SqlFilter.this.cmFilterTurnOff));
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    public SqlFilterDef getDefinition() {
        return this.definition;
    }

    public String getTooltip() {
        if (!this.turnedOn) {
            return this.stringManager.getString("SqlFilter-hint-off");
        }
        boolean resultFilterOn = false;
        String result = "<html>" + this.stringManager.getString("SqlFilter-hint-on") + "<br><hr>";
        for (int i = 0; i < this.filterComponent.length; ++i) {
            if (!this.filterComponent[i].isTurnedOn()) continue;
            resultFilterOn = true;
            if (i > 0) {
                result = result + "<br>";
                if ("AND".equalsIgnoreCase(this.filterComponent[i].getOperator())) {
                    result = result + this.stringManager.getString("and") + " ";
                } else if ("OR".equalsIgnoreCase(this.filterComponent[i].getOperator())) {
                    result = result + this.stringManager.getString("or") + " ";
                }
            }
            result = result + this.getDefinition().getByColumn(this.filterComponent[i].getColumnName()).getColumnPublicName();
            if ("USER".equalsIgnoreCase(this.filterComponent[i].getCondition())) continue;
            String value = "";
            if (!"IS NULL".equalsIgnoreCase(this.filterComponent[i].getCondition()) && !"IS NOT NULL".equalsIgnoreCase(this.filterComponent[i].getCondition())) {
                value = this.filterComponent[i].getValue();
            }
            result = result + " " + this.filterComponent[i].getCondition() + " " + value;
        }
        return resultFilterOn ? result : this.stringManager.getString("SqlFilter-hint-on-offed");
    }

    public String getSqlText() {
        if (!this.turnedOn) {
            return null;
        }
        boolean resultFilterOn = false;
        String result = "(";
        for (int i = 0; i < this.filterComponent.length; ++i) {
            if (!this.filterComponent[i].isTurnedOn()) continue;
            resultFilterOn = true;
            if (i > 0) {
                result = result + " " + this.filterComponent[i].getOperator() + " ";
            }
            result = result + this.filterComponent[i].getColumnName();
            if ("USER".equalsIgnoreCase(this.filterComponent[i].getCondition())) continue;
            String cond = this.filterComponent[i].getCondition();
            String value = "";
            if (!"IS NULL".equalsIgnoreCase(this.filterComponent[i].getCondition()) && !"IS NOT NULL".equalsIgnoreCase(this.filterComponent[i].getCondition())) {
                value = this.filterComponent[i].getValue();
            }
            if (("LIKE".equalsIgnoreCase(cond) || "NOT LIKE".equalsIgnoreCase(cond)) && value != null && value.trim().length() > 0 && value.trim().charAt(0) != '\'') {
                value = "'" + value + "'";
            } else if (("IN".equalsIgnoreCase(cond) || "NOT IN".equalsIgnoreCase(cond)) && value != null && value.trim().length() > 0 && value.trim().charAt(0) != '(') {
                value = "(" + value + ")";
            }
            result = result + " " + cond + " " + value;
        }
        return resultFilterOn ? result + ")" : null;
    }

    public boolean isTurnedOn() {
        return this.turnedOn;
    }

    public void setTurnedOn(boolean turnedOn) {
        this.turnedOn = turnedOn;
        this.updateAction();
    }

    public boolean isSilentDialog() {
        return this.silentDialog;
    }

    public void setSilentDialog(boolean silentDialog) {
        this.silentDialog = silentDialog;
    }

    public SqlFilterComponent[] getFilterComponent() {
        return this.filterComponent;
    }

    public Action getAction() {
        return this.action;
    }

    public ArrayList<DefinedFilterComponent> getFilterComponentList() {
        return this.filterComponentList;
    }
}

