/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.filter.DefinedFilterComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterConsts;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SqlFilterDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private int modalResult = 0;
    private SqlFilter sqlFilter;
    private boolean disableUpdatedControls;
    private JButton buttonCancel;
    private JButton buttonClear;
    private JButton buttonDeleteDef;
    private JButton buttonNewDef;
    private JButton buttonOk;
    private JButton buttonUpdateDef;
    private JCheckBox checkFilterOn;
    private Action cmCancel;
    private Action cmClearDefs;
    private Action cmDeleteDef;
    private Action cmNewDef;
    private Action cmOk;
    private Action cmUpdateDef;
    private JComboBox comboColumn1;
    private JComboBox comboColumn2;
    private JComboBox comboColumn3;
    private JComboBox comboColumn4;
    private JComboBox comboColumn5;
    private JComboBox comboCond1;
    private JComboBox comboCond2;
    private JComboBox comboCond3;
    private JComboBox comboCond4;
    private JComboBox comboCond5;
    private ComboBox comboDefs;
    private JComboBox comboOp1;
    private JComboBox comboOp2;
    private JComboBox comboOp3;
    private JComboBox comboOp4;
    private JComboBox comboValue1;
    private JComboBox comboValue2;
    private JComboBox comboValue3;
    private JComboBox comboValue4;
    private JComboBox comboValue5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public SqlFilterDialog(SqlFilter sqlFilter) {
        super(SwingUtil.getRootFrame());
        this.sqlFilter = sqlFilter;
        this.initComponents();
        this.init();
    }

    public static boolean show(SqlFilter sqlFilter) {
        if (sqlFilter.isSilentDialog()) {
            return true;
        }
        SqlFilterDialog dialog = new SqlFilterDialog(sqlFilter);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        ArrayList<SqlFilterDefComponent> defList = new ArrayList<SqlFilterDefComponent>();
        for (int i = 0; i < this.sqlFilter.getDefinition().getCount(); ++i) {
            SqlFilterDefComponent def = this.sqlFilter.getDefinition().get(i);
            defList.add(def);
        }
        this.comboColumn1.setModel(new DefaultComboBoxModel<Object>(defList.toArray()));
        this.comboColumn2.setModel(new DefaultComboBoxModel<Object>(defList.toArray()));
        this.comboColumn3.setModel(new DefaultComboBoxModel<Object>(defList.toArray()));
        this.comboColumn4.setModel(new DefaultComboBoxModel<Object>(defList.toArray()));
        this.comboColumn5.setModel(new DefaultComboBoxModel<Object>(defList.toArray()));
        this.comboDefs.setModel(new DefaultComboBoxModel<Object>(this.sqlFilter.getFilterComponentList().toArray()));
        this.checkFilterOn.setSelected(this.sqlFilter.isTurnedOn());
        this.filterToDialog(this.sqlFilter.getFilterComponent());
        this.updateEnableControls();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SqlFilterDialog.this.comboColumn1.requestFocusInWindow();
            }
        });
    }

    private void filterToDialog(SqlFilterComponent[] filterComponent) {
        SqlFilterComponent sfc = filterComponent[0];
        this.comboColumn1.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(sfc.getColumnName()));
        this.comboCond1.setSelectedItem(sfc.getCondition());
        this.comboValue1.setSelectedItem(sfc.getValue());
        sfc = filterComponent[1];
        this.comboOp1.setSelectedItem(sfc.getOperator());
        this.comboColumn2.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(sfc.getColumnName()));
        this.comboCond2.setSelectedItem(sfc.getCondition());
        this.comboValue2.setSelectedItem(sfc.getValue());
        sfc = filterComponent[2];
        this.comboOp2.setSelectedItem(sfc.getOperator());
        this.comboColumn3.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(sfc.getColumnName()));
        this.comboCond3.setSelectedItem(sfc.getCondition());
        this.comboValue3.setSelectedItem(sfc.getValue());
        sfc = filterComponent[3];
        this.comboOp3.setSelectedItem(sfc.getOperator());
        this.comboColumn4.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(sfc.getColumnName()));
        this.comboCond4.setSelectedItem(sfc.getCondition());
        this.comboValue4.setSelectedItem(sfc.getValue());
        sfc = filterComponent[4];
        this.comboOp4.setSelectedItem(sfc.getOperator());
        this.comboColumn5.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(sfc.getColumnName()));
        this.comboCond5.setSelectedItem(sfc.getCondition());
        this.comboValue5.setSelectedItem(sfc.getValue());
    }

    private void dialogToFilter(SqlFilterComponent[] filterComponent) {
        this.sqlFilter.setTurnedOn(this.checkFilterOn.getSelectedObjects() != null);
        SqlFilterComponent sfc = filterComponent[0];
        sfc.setColumnName(((SqlFilterDefComponent)this.comboColumn1.getSelectedItem()).getColumnSqlName());
        sfc.setCondition(StringUtil.nvl((Object)this.comboCond1.getSelectedItem(), (Object)"").toString());
        sfc.setValue(StringUtil.nvl((Object)this.comboValue1.getSelectedItem(), (Object)"").toString());
        sfc.setTurnedOn(((SqlFilterDefComponent)this.comboColumn1.getSelectedItem()).getColumnSqlName() != null);
        sfc = filterComponent[1];
        sfc.setOperator(this.comboOp1.getSelectedItem().toString());
        sfc.setColumnName(((SqlFilterDefComponent)this.comboColumn2.getSelectedItem()).getColumnSqlName());
        sfc.setCondition(StringUtil.nvl((Object)this.comboCond2.getSelectedItem(), (Object)"").toString());
        sfc.setValue(StringUtil.nvl((Object)this.comboValue2.getSelectedItem(), (Object)"").toString());
        sfc.setTurnedOn(!StringUtil.isEmpty((String)this.comboOp1.getSelectedItem().toString()) && ((SqlFilterDefComponent)this.comboColumn2.getSelectedItem()).getColumnSqlName() != null);
        sfc = filterComponent[2];
        sfc.setOperator(this.comboOp2.getSelectedItem().toString());
        sfc.setColumnName(((SqlFilterDefComponent)this.comboColumn3.getSelectedItem()).getColumnSqlName());
        sfc.setCondition(StringUtil.nvl((Object)this.comboCond3.getSelectedItem(), (Object)"").toString());
        sfc.setValue(StringUtil.nvl((Object)this.comboValue3.getSelectedItem(), (Object)"").toString());
        sfc.setTurnedOn(!StringUtil.isEmpty((String)this.comboOp2.getSelectedItem().toString()) && ((SqlFilterDefComponent)this.comboColumn3.getSelectedItem()).getColumnSqlName() != null);
        sfc = filterComponent[3];
        sfc.setOperator(this.comboOp3.getSelectedItem().toString());
        sfc.setColumnName(((SqlFilterDefComponent)this.comboColumn4.getSelectedItem()).getColumnSqlName());
        sfc.setCondition(StringUtil.nvl((Object)this.comboCond4.getSelectedItem(), (Object)"").toString());
        sfc.setValue(StringUtil.nvl((Object)this.comboValue4.getSelectedItem(), (Object)"").toString());
        sfc.setTurnedOn(!StringUtil.isEmpty((String)this.comboOp3.getSelectedItem().toString()) && ((SqlFilterDefComponent)this.comboColumn4.getSelectedItem()).getColumnSqlName() != null);
        sfc = filterComponent[4];
        sfc.setOperator(this.comboOp4.getSelectedItem().toString());
        sfc.setColumnName(((SqlFilterDefComponent)this.comboColumn5.getSelectedItem()).getColumnSqlName());
        sfc.setCondition(StringUtil.nvl((Object)this.comboCond5.getSelectedItem(), (Object)"").toString());
        sfc.setValue(StringUtil.nvl((Object)this.comboValue5.getSelectedItem(), (Object)"").toString());
        sfc.setTurnedOn(!StringUtil.isEmpty((String)this.comboOp4.getSelectedItem().toString()) && ((SqlFilterDefComponent)this.comboColumn5.getSelectedItem()).getColumnSqlName() != null);
    }

    private void updateEnableControls() {
        if (this.disableUpdatedControls) {
            return;
        }
        this.comboCond1.setEnabled(!"USER".equals(this.comboCond1.getSelectedItem()));
        this.comboValue1.setEnabled(!StringUtil.equalAnyOfString((String)((String)this.comboCond1.getSelectedItem()), (String[])new String[]{"USER", "IS NULL", "IS NOT NULL"}));
        this.comboOp1.setEnabled(!StringUtil.isEmpty((String)this.comboColumn1.getSelectedItem().toString()));
        this.comboColumn2.setEnabled(!StringUtil.isEmpty((String)this.comboOp1.getSelectedItem().toString()));
        this.comboCond2.setEnabled(this.comboColumn2.isEnabled() && !"USER".equals(this.comboCond2.getSelectedItem()));
        this.comboValue2.setEnabled(this.comboColumn2.isEnabled() && !StringUtil.equalAnyOfString((String)((String)this.comboCond2.getSelectedItem()), (String[])new String[]{"USER", "IS NULL", "IS NOT NULL"}));
        this.comboOp2.setEnabled(this.comboColumn2.isEnabled() && !StringUtil.isEmpty((String)this.comboColumn2.getSelectedItem().toString()));
        this.comboColumn3.setEnabled(!StringUtil.isEmpty((String)this.comboOp2.getSelectedItem().toString()));
        this.comboCond3.setEnabled(this.comboColumn3.isEnabled() && !"USER".equals(this.comboCond3.getSelectedItem()));
        this.comboValue3.setEnabled(this.comboColumn3.isEnabled() && !StringUtil.equalAnyOfString((String)((String)this.comboCond3.getSelectedItem()), (String[])new String[]{"USER", "IS NULL", "IS NOT NULL"}));
        this.comboOp3.setEnabled(this.comboColumn3.isEnabled() && !StringUtil.isEmpty((String)this.comboColumn3.getSelectedItem().toString()));
        this.comboColumn4.setEnabled(!StringUtil.isEmpty((String)this.comboOp3.getSelectedItem().toString()));
        this.comboCond4.setEnabled(this.comboColumn4.isEnabled() && !"USER".equals(this.comboCond4.getSelectedItem()));
        this.comboValue4.setEnabled(this.comboColumn4.isEnabled() && !StringUtil.equalAnyOfString((String)((String)this.comboCond4.getSelectedItem()), (String[])new String[]{"USER", "IS NULL", "IS NOT NULL"}));
        this.comboOp4.setEnabled(this.comboColumn4.isEnabled() && !StringUtil.isEmpty((String)this.comboColumn4.getSelectedItem().toString()));
        this.comboColumn5.setEnabled(!StringUtil.isEmpty((String)this.comboOp4.getSelectedItem().toString()));
        this.comboCond5.setEnabled(this.comboColumn5.isEnabled() && !"USER".equals(this.comboCond5.getSelectedItem()));
        this.comboValue5.setEnabled(this.comboColumn5.isEnabled() && !StringUtil.equalAnyOfString((String)((String)this.comboCond5.getSelectedItem()), (String[])new String[]{"USER", "IS NULL", "IS NOT NULL"}));
        this.cmDeleteDef.setEnabled(this.comboDefs.getSelectedIndex() > 0);
        this.cmUpdateDef.setEnabled(this.comboDefs.getSelectedIndex() > 0);
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmOk = new Action();
        this.cmNewDef = new Action();
        this.cmDeleteDef = new Action();
        this.cmClearDefs = new Action();
        this.cmUpdateDef = new Action();
        this.checkFilterOn = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboColumn1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboCond1 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.comboValue1 = new JComboBox();
        this.comboOp1 = new JComboBox();
        this.comboColumn2 = new JComboBox();
        this.comboCond2 = new JComboBox();
        this.comboValue2 = new JComboBox();
        this.comboOp2 = new JComboBox();
        this.comboColumn3 = new JComboBox();
        this.comboCond3 = new JComboBox();
        this.comboValue3 = new JComboBox();
        this.comboOp3 = new JComboBox();
        this.comboColumn4 = new JComboBox();
        this.comboCond4 = new JComboBox();
        this.comboValue4 = new JComboBox();
        this.comboOp4 = new JComboBox();
        this.comboColumn5 = new JComboBox();
        this.comboCond5 = new JComboBox();
        this.comboValue5 = new JComboBox();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.comboDefs = new ComboBox();
        this.buttonDeleteDef = new JButton();
        this.buttonNewDef = new JButton();
        this.buttonUpdateDef = new JButton();
        this.buttonClear = new JButton();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlFilterDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlFilterDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmNewDef.setActionCommandKey("cmNewDef");
        this.cmNewDef.setText(this.stringManager.getString("cmNewDef-text"));
        this.cmNewDef.setTooltip(this.stringManager.getString("cmNewDef-hint"));
        this.cmNewDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlFilterDialog.this.cmNewDefActionPerformed(evt);
            }
        });
        this.cmDeleteDef.setActionCommandKey("cmDeleteDef");
        this.cmDeleteDef.setText(this.stringManager.getString("cmDeleteDef-text"));
        this.cmDeleteDef.setTooltip(this.stringManager.getString("cmDeleteDef-hint"));
        this.cmDeleteDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlFilterDialog.this.cmDeleteDefActionPerformed(evt);
            }
        });
        this.cmClearDefs.setActionCommandKey("cmClearDefs");
        this.cmClearDefs.setText(this.stringManager.getString("cmClearDefs-text"));
        this.cmClearDefs.setTooltip(this.stringManager.getString("cmClearDefs-hint"));
        this.cmClearDefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlFilterDialog.this.cmClearDefsActionPerformed(evt);
            }
        });
        this.cmUpdateDef.setActionCommandKey("cmUpdateDef");
        this.cmUpdateDef.setText(this.stringManager.getString("cmUpdateDef-text"));
        this.cmUpdateDef.setTooltip(this.stringManager.getString("cmUpdateDef-hint"));
        this.cmUpdateDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlFilterDialog.this.cmUpdateDefActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("SqlFilterDialog-title"));
        this.setModal(true);
        this.checkFilterOn.setText(this.stringManager.getString("filter-on"));
        this.checkFilterOn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkFilterOn.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("column-filter")));
        this.jLabel1.setText(this.stringManager.getString("comb-op-dd"));
        this.jLabel2.setText(this.stringManager.getString("column-dd"));
        this.comboColumn1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboColumn1ItemStateChanged(evt);
            }
        });
        this.jLabel3.setText(this.stringManager.getString("condition-dd"));
        this.comboCond1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboCond1ItemStateChange(evt);
            }
        });
        this.jLabel4.setText(this.stringManager.getString("value-dd"));
        this.comboValue1.setEditable(true);
        this.comboOp1.setModel(new DefaultComboBoxModel<String>(new String[]{"", "AND", "OR"}));
        this.comboOp1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboOp1ItemStateChanged(evt);
            }
        });
        this.comboColumn2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboColumn2ItemStateChanged(evt);
            }
        });
        this.comboCond2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboCond2ItemStateChange(evt);
            }
        });
        this.comboValue2.setEditable(true);
        this.comboOp2.setModel(new DefaultComboBoxModel<String>(new String[]{"", "AND", "OR"}));
        this.comboOp2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboOp2ItemStateChanged(evt);
            }
        });
        this.comboColumn3.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboColumn3ItemStateChanged(evt);
            }
        });
        this.comboCond3.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboCond3ItemStateChange(evt);
            }
        });
        this.comboValue3.setEditable(true);
        this.comboOp3.setModel(new DefaultComboBoxModel<String>(new String[]{"", "AND", "OR"}));
        this.comboOp3.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboOp3ItemStateChanged(evt);
            }
        });
        this.comboColumn4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboColumn4ItemStateChanged(evt);
            }
        });
        this.comboCond4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboCond4ItemStateChange(evt);
            }
        });
        this.comboValue4.setEditable(true);
        this.comboOp4.setModel(new DefaultComboBoxModel<String>(new String[]{"", "AND", "OR"}));
        this.comboOp4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboOp4ItemStateChanged(evt);
            }
        });
        this.comboColumn5.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboColumn5ItemStateChanged(evt);
            }
        });
        this.comboCond5.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboCond5ItemStateChange(evt);
            }
        });
        this.comboValue5.setEditable(true);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(75, 75, 75).addComponent(this.comboColumn1, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCond1, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboValue1, 0, 236, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(31, 31, 31).addComponent(this.jLabel2).addGap(103, 103, 103).addComponent(this.jLabel3).addGap(35, 35, 35).addComponent(this.jLabel4)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboOp1, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboColumn2, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCond2, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboValue2, 0, 236, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboOp2, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboColumn3, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCond3, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboValue3, 0, 236, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboOp3, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboColumn4, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCond4, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboValue4, 0, 236, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.comboOp4, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboColumn5, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCond5, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboValue5, 0, 236, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboColumn1, -2, -1, -2).addComponent(this.comboCond1, -2, -1, -2).addComponent(this.comboValue1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboOp1, -2, -1, -2).addComponent(this.comboColumn2, -2, -1, -2).addComponent(this.comboCond2, -2, -1, -2).addComponent(this.comboValue2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboOp2, -2, -1, -2).addComponent(this.comboColumn3, -2, -1, -2).addComponent(this.comboCond3, -2, -1, -2).addComponent(this.comboValue3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboOp3, -2, -1, -2).addComponent(this.comboColumn4, -2, -1, -2).addComponent(this.comboCond4, -2, -1, -2).addComponent(this.comboValue4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboOp4, -2, -1, -2).addComponent(this.comboColumn5, -2, -1, -2).addComponent(this.comboCond5, -2, -1, -2).addComponent(this.comboValue5, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("saved-definitions")));
        this.comboDefs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SqlFilterDialog.this.comboDefsItemStateChanged(evt);
            }
        });
        this.buttonDeleteDef.setAction((javax.swing.Action)this.cmDeleteDef);
        this.buttonDeleteDef.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDeleteDef.setPreferredSize(new Dimension(75, 23));
        this.buttonNewDef.setAction((javax.swing.Action)this.cmNewDef);
        this.buttonNewDef.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNewDef.setPreferredSize(new Dimension(75, 23));
        this.buttonUpdateDef.setAction((javax.swing.Action)this.cmUpdateDef);
        this.buttonUpdateDef.setMargin(new Insets(2, 2, 2, 2));
        this.buttonUpdateDef.setPreferredSize(new Dimension(75, 23));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.comboDefs, -1, 298, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonNewDef, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonUpdateDef, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDeleteDef, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonDeleteDef, -2, -1, -2).addComponent(this.buttonUpdateDef, -2, -1, -2).addComponent(this.buttonNewDef, -2, -1, -2).addComponent((Component)this.comboDefs, -2, -1, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.buttonClear.setAction((javax.swing.Action)this.cmClearDefs);
        this.buttonClear.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClear.setPreferredSize(new Dimension(75, 23));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.checkFilterOn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 441, Short.MAX_VALUE).addComponent(this.buttonClear, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkFilterOn).addComponent(this.buttonClear, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void comboOp4ItemStateChanged(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboOp3ItemStateChanged(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboOp2ItemStateChanged(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboOp1ItemStateChanged(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboColumn5ItemStateChanged(ItemEvent evt) {
        this.comboCond5.setModel(new DefaultComboBoxModel<String>(SqlFilterConsts.getConditionList(((SqlFilterDefComponent)evt.getItem()).getConditions())));
        this.comboValue5.setModel(new DefaultComboBoxModel<String>(((SqlFilterDefComponent)evt.getItem()).getValueList()));
        this.updateEnableControls();
    }

    private void comboColumn4ItemStateChanged(ItemEvent evt) {
        this.comboCond4.setModel(new DefaultComboBoxModel<String>(SqlFilterConsts.getConditionList(((SqlFilterDefComponent)evt.getItem()).getConditions())));
        this.comboValue4.setModel(new DefaultComboBoxModel<String>(((SqlFilterDefComponent)evt.getItem()).getValueList()));
        this.updateEnableControls();
    }

    private void comboColumn3ItemStateChanged(ItemEvent evt) {
        this.comboCond3.setModel(new DefaultComboBoxModel<String>(SqlFilterConsts.getConditionList(((SqlFilterDefComponent)evt.getItem()).getConditions())));
        this.comboValue3.setModel(new DefaultComboBoxModel<String>(((SqlFilterDefComponent)evt.getItem()).getValueList()));
        this.updateEnableControls();
    }

    private void comboColumn2ItemStateChanged(ItemEvent evt) {
        this.comboCond2.setModel(new DefaultComboBoxModel<String>(SqlFilterConsts.getConditionList(((SqlFilterDefComponent)evt.getItem()).getConditions())));
        this.comboValue2.setModel(new DefaultComboBoxModel<String>(((SqlFilterDefComponent)evt.getItem()).getValueList()));
        this.updateEnableControls();
    }

    private void comboColumn1ItemStateChanged(ItemEvent evt) {
        this.comboCond1.setModel(new DefaultComboBoxModel<String>(SqlFilterConsts.getConditionList(((SqlFilterDefComponent)evt.getItem()).getConditions())));
        this.comboValue1.setModel(new DefaultComboBoxModel<String>(((SqlFilterDefComponent)evt.getItem()).getValueList()));
        this.updateEnableControls();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dialogToFilter(this.sqlFilter.getFilterComponent());
        this.sqlFilter.storeSettings();
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmClearDefsActionPerformed(ActionEvent evt) {
        this.disableUpdatedControls = true;
        try {
            this.comboOp1.setSelectedItem("");
            this.comboColumn1.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(null));
            this.comboCond1.setSelectedItem(null);
            this.comboValue1.setSelectedItem(null);
            this.comboOp2.setSelectedItem("");
            this.comboColumn2.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(null));
            this.comboCond2.setSelectedItem(null);
            this.comboValue2.setSelectedItem(null);
            this.comboOp3.setSelectedItem("");
            this.comboColumn3.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(null));
            this.comboCond3.setSelectedItem(null);
            this.comboValue3.setSelectedItem(null);
            this.comboOp4.setSelectedItem("");
            this.comboColumn4.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(null));
            this.comboCond4.setSelectedItem(null);
            this.comboValue4.setSelectedItem(null);
            this.comboColumn5.setSelectedItem(this.sqlFilter.getDefinition().getByColumn(null));
            this.comboCond5.setSelectedItem(null);
            this.comboValue5.setSelectedItem(null);
        }
        finally {
            this.disableUpdatedControls = false;
            this.updateEnableControls();
        }
    }

    private void cmNewDefActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, (Object)this.stringManager.getString("definition-name-dd"));
        if (name != null) {
            DefinedFilterComponent def = new DefinedFilterComponent(name);
            this.filterToDialog(def.getFilterComponent());
            this.sqlFilter.getFilterComponentList().add(def);
            this.sqlFilter.storeSettings(def, this.sqlFilter.getFilterComponentList().size() - 1);
            this.comboDefs.setModel(new DefaultComboBoxModel<Object>(this.sqlFilter.getFilterComponentList().toArray()));
            this.comboDefs.setSelectedIndex(this.sqlFilter.getFilterComponentList().size() - 1);
        }
    }

    private void cmDeleteDefActionPerformed(ActionEvent evt) {
        if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)this.stringManager.getString("SqlFilterDialog-del-def-q"), (int[])ModalResult.YESNO) == 5) {
            this.sqlFilter.getFilterComponentList().remove(this.comboDefs.getSelectedIndex());
            this.comboDefs.setModel(new DefaultComboBoxModel<Object>(this.sqlFilter.getFilterComponentList().toArray()));
            this.comboDefs.setSelectedIndex(0);
            this.sqlFilter.storeSettings(null, -1L);
        }
    }

    private void comboDefsItemStateChanged(ItemEvent evt) {
        this.filterToDialog(((DefinedFilterComponent)this.comboDefs.getSelectedItem()).getFilterComponent());
        this.updateEnableControls();
    }

    private void cmUpdateDefActionPerformed(ActionEvent evt) {
        DefinedFilterComponent def = (DefinedFilterComponent)this.comboDefs.getSelectedItem();
        this.dialogToFilter(def.getFilterComponent());
        this.sqlFilter.storeSettings(def, this.sqlFilter.getFilterComponentList().size() - 1);
    }

    private void comboCond1ItemStateChange(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboCond2ItemStateChange(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboCond3ItemStateChange(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboCond4ItemStateChange(ItemEvent evt) {
        this.updateEnableControls();
    }

    private void comboCond5ItemStateChange(ItemEvent evt) {
        this.updateEnableControls();
    }
}

