/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.universal.gui.history.QueryHistory;
import pl.mpak.orbada.universal.gui.history.QueryHistoryItem;
import pl.mpak.orbada.universal.gui.history.QueryHistoryTableModel;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Query;

public class QueryHistoryPanel
extends JPanel
implements Closeable {
    private QueryHistory history;
    private QueryHistoryTableModel historyTableModel;
    private JScrollPane jScrollPane1;
    private Table tableHistory;

    public QueryHistoryPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.history = new QueryHistory();
        this.historyTableModel = new QueryHistoryTableModel(this.history);
        this.tableHistory.setModel((TableModel)this.historyTableModel);
        this.historyTableModel.configureTable((JTable)this.tableHistory);
    }

    public QueryHistory getHistory() {
        return this.history;
    }

    private void refreshTable() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                QueryHistoryPanel.this.tableHistory.revalidate();
                QueryHistoryPanel.this.tableHistory.repaint();
            }
        });
    }

    public QueryHistoryItem add(Query query) {
        QueryHistoryItem item = this.history.add(query);
        this.refreshTable();
        return item;
    }

    public QueryHistoryItem add(Command command) {
        QueryHistoryItem item = this.history.add(command);
        this.refreshTable();
        return item;
    }

    public void close() throws IOException {
        if (this.history != null) {
            this.history.clear();
            this.history = null;
        }
        this.historyTableModel = null;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableHistory = new Table();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableHistory);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

