/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.history;

import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.history.QueryHistory;
import pl.mpak.orbada.universal.gui.history.QueryHistoryItem;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class QueryHistoryTableModel
extends AbstractTableModel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private QueryHistory history;

    public QueryHistoryTableModel(QueryHistory history) {
        this.history = history;
    }

    public int getRowCount() {
        return this.history == null ? 0 : this.history.getCount();
    }

    public int getColumnCount() {
        return 0;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Date.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Long.class;
            }
            case 3: {
                return String.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        QueryHistoryItem item = this.history.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return new Date(item.getExecutedTime());
            }
            case 1: {
                return StringUtil.formatTime((long)item.getExecutingTime());
            }
            case 2: {
                return item.getFetchedRows();
            }
            case 3: {
                return SQLUtil.removeWhiteSpaces((String)item.getSqlText());
            }
        }
        return "???";
    }

    protected TableColumn createColumn(int index, int width, String title) {
        TableColumn tc = new TableColumn(index, width);
        tc.setHeaderValue(title);
        tc.setCellRenderer((TableCellRenderer)new QueryTableCellRenderer(true));
        return tc;
    }

    public void configureTable(JTable table) {
        table.setAutoResizeMode(0);
        table.setSelectionMode(0);
        DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
        table.setColumnModel(tableColumnModel);
        tableColumnModel.addColumn(this.createColumn(0, 110, this.stringManager.getString("cmd-executed")));
        tableColumnModel.addColumn(this.createColumn(1, 50, this.stringManager.getString("time")));
        tableColumnModel.addColumn(this.createColumn(2, 50, this.stringManager.getString("rows")));
        tableColumnModel.addColumn(this.createColumn(3, 1000, this.stringManager.getString("sql-command")));
        if (this.history.getCount() > 0) {
            table.changeSelection(0, 0, false, false);
        } else {
            table.changeSelection(-1, 0, false, false);
        }
    }
}

