/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.procedures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ProcedureColumnsPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentCatalogName;
    private String currentSchemaName = "";
    private String currentProcedureName = "";
    private boolean isView;
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JScrollPane jScrollPane1;
    private QueryTableStatusBar statusBarColumns;
    private ViewTable tableColumns;
    private JToolBar toolBarColumns;

    public ProcedureColumnsPanel(IViewAccesibilities accesibilities) {
        this(accesibilities, false);
    }

    public ProcedureColumnsPanel(IViewAccesibilities accesibilities, boolean isView) {
        this.accesibilities = accesibilities;
        this.isView = isView;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = ProcedureColumnsPanel.this.tableColumns.getSelectedRow();
                if (rowIndex >= 0 && ProcedureColumnsPanel.this.tableColumns.getQuery().isActive()) {
                    try {
                        ProcedureColumnsPanel.this.tableColumns.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableColumns.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableColumns.getQuery().setFlushMode(Query.FlushMode.fmSynch);
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("COLUMN_NAME", this.stringManager.getString("argument-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("TYPE_NAME", this.stringManager.getString("argument-type"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("LENGTH", this.stringManager.getString("length"), 60));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("PRECISION", this.stringManager.getString("precision"), 60));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("NULLABLE", this.stringManager.getString("null-q"), 30));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("REMARKS", this.stringManager.getString("comment"), 300));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableColumns.getQuery().close();
            this.tableColumns.getQuery().setResultSet(this.getDatabase().getMetaData().getProcedureColumns(this.currentCatalogName, this.currentSchemaName, this.currentProcedureName, null));
            if (!this.tableColumns.getQuery().isEmpty()) {
                this.tableColumns.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!StringUtil.equals((String)catalogName, (String)this.currentCatalogName) || !StringUtil.equals((String)schemaName, (String)this.currentSchemaName) || !this.currentProcedureName.equals(objectName) || this.requestRefresh) {
            this.currentCatalogName = catalogName;
            this.currentSchemaName = schemaName;
            this.currentProcedureName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableColumns.getQuery().close();
        this.accesibilities = null;
    }

    public String getTitle() {
        return this.stringManager.getString("ProcedureColumnsPanel-title");
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new ViewTable();
        this.statusBarColumns = new QueryTableStatusBar();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureColumnsPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ProcedureColumnsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarColumns.setShowFieldType(false);
        this.statusBarColumns.setShowOpenTime(false);
        this.statusBarColumns.setTable((QueryTable)this.tableColumns);
        this.add((Component)this.statusBarColumns, "Last");
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.add((Component)this.toolBarColumns, "North");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refresh();
        }
    }
}

