/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.tabbed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.VerticalQueryTablePanel;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public abstract class UniversalPropDetailsTab
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    protected IViewAccesibilities accesibilities;
    protected String currentSchemaName = "";
    protected String currentObjectName = "";
    protected boolean requestRefresh = false;
    protected boolean closing = false;
    protected VerticalQueryTablePanel tableInfoPanel;
    protected ComponentActionsAction componentActions;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JPanel panel;
    private QueryTableStatusBar statusStatus;
    private JToolBar toolBar;

    public UniversalPropDetailsTab(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalPropDetailsTab.this.init();
            }
        });
    }

    private void init() {
        this.tableInfoPanel = new VerticalQueryTablePanel(this.getDatabase());
        this.add((Component)this.tableInfoPanel, "Center");
        this.componentActions = new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableInfoPanel, (JButton)this.buttonActions, this.menuActions, this.getPanelName() + "-actions");
    }

    public abstract String getPanelName();

    public abstract String getSql();

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalPropDetailsTab.this.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        String sqlText = this.getSql();
        if (!StringUtil.isEmpty((String)this.currentObjectName) && !StringUtil.isEmpty((String)sqlText)) {
            Query query = this.getDatabase().createQuery();
            try {
                query.setSqlText(sqlText);
                this.extraSqlParameters((ParametrizedCommand)query);
                query.open();
                this.tableInfoPanel.refresh(query);
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
            finally {
                query.close();
                this.requestRefresh = false;
            }
        } else {
            this.tableInfoPanel.getTable().setModel(new DefaultTableModel());
            this.requestRefresh = false;
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (SwingUtil.isVisible((Component)this)) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.accesibilities = null;
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public String getCurrentObjectName() {
        return this.currentObjectName;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.panel = new JPanel();
        this.statusStatus = new QueryTableStatusBar();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalPropDetailsTab.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                UniversalPropDetailsTab.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBar);
        this.add((Component)this.jPanel1, "North");
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.statusStatus, "South");
        this.add((Component)this.panel, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

