/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.tabbed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.sql.ResultSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public abstract class UniversalPropSourceTab
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    protected IViewAccesibilities accesibilities;
    protected String currentSchemaName = "";
    protected String currentObjectName = "";
    protected String currentPropName;
    protected boolean requestRefresh = false;
    protected boolean closing = false;
    protected SqlFilter filter;
    protected ISettings settings;
    protected ComponentActionsAction componentActions;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JSplitPane split;
    private QueryTableStatusBar statusBarProps;
    private ViewTable tableProps;
    private OrbadaSyntaxTextArea textProp;
    private JToolBar toolBarTriggers;

    public UniversalPropSourceTab(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalPropSourceTab.this.init();
            }
        });
    }

    protected void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), this.getPanelName() + "-settings");
        this.split.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.split.getDividerLocation())).intValue());
        this.textProp.setDatabase(this.getDatabase());
        this.textProp.setEditable(false);
        this.tableProps.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = UniversalPropSourceTab.this.tableProps.getSelectedRow();
                if (rowIndex >= 0 && UniversalPropSourceTab.this.tableProps.getQuery().isActive()) {
                    try {
                        UniversalPropSourceTab.this.tableProps.getQuery().getRecord(rowIndex);
                        if (UniversalPropSourceTab.this.currentPropName == null || !UniversalPropSourceTab.this.currentPropName.equals(UniversalPropSourceTab.this.tableProps.getQuery().fieldByName(UniversalPropSourceTab.this.getPropColumnName()).getString())) {
                            UniversalPropSourceTab.this.currentPropName = UniversalPropSourceTab.this.tableProps.getQuery().fieldByName(UniversalPropSourceTab.this.getPropColumnName()).getString();
                            UniversalPropSourceTab.this.updateBody(UniversalPropSourceTab.this.textProp);
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    UniversalPropSourceTab.this.currentPropName = null;
                    UniversalPropSourceTab.this.textProp.setDatabaseObject(null, null, null, "");
                }
            }
        });
        this.tableProps.getQuery().setDatabase(this.getDatabase());
        try {
            SqlFilterDefComponent[] fdcs;
            QueryTableColumn[] qtcs;
            if (StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("dict-persistent-query", "false"))) {
                this.tableProps.getQuery().setCloseResultAfterOpen(true);
            }
            if ((qtcs = this.getTableColumns()) != null) {
                for (QueryTableColumn qtc : qtcs) {
                    this.tableProps.addColumn((TableColumn)qtc);
                }
            }
            if ((fdcs = this.getFilterDefComponent()) != null) {
                SqlFilterDef def = new SqlFilterDef();
                for (SqlFilterDefComponent fdc : fdcs) {
                    def.add(fdc);
                }
                this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), this.getPanelName() + "-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
            } else {
                this.cmFilter.setEnabled(false);
                this.buttonFilter.setVisible(false);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.componentActions = new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableProps, (JButton)this.buttonActions, this.menuActions, this.getPanelName() + "-actions");
    }

    public abstract String getPanelName();

    public abstract String getObjectColumnName();

    public abstract String getSchemaColumnName();

    public abstract String getPropColumnName();

    public abstract QueryTableColumn[] getTableColumns();

    public abstract String getSql(SqlFilter var1);

    public abstract SqlFilterDefComponent[] getFilterDefComponent();

    public abstract void updateBody(OrbadaSyntaxTextArea var1);

    protected boolean executeSql() {
        return false;
    }

    public boolean canClose() {
        return true;
    }

    protected void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalPropSourceTab.this.refresh();
            }
        });
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            int column = Math.max(0, this.tableProps.getSelectedColumn());
            int index = Math.max(0, this.tableProps.getSelectedRow());
            String propName = null;
            if (this.tableProps.getQuery().isActive() && this.tableProps.getSelectedRow() >= 0) {
                this.tableProps.getQuery().getRecord(this.tableProps.getSelectedRow());
                propName = this.tableProps.getQuery().fieldByName(this.getPropColumnName()).getString();
            }
            this.tableProps.getQuery().close();
            if (!StringUtil.isEmpty((String)this.currentObjectName)) {
                if (this.executeSql()) {
                    ResultSet rs;
                    Command command = this.getDatabase().createCommand(this.getSql(this.filter), false);
                    if (this.getSchemaColumnName() != null) {
                        command.paramByName(this.getSchemaColumnName()).setString(this.currentSchemaName);
                    }
                    if (this.getObjectColumnName() != null) {
                        command.paramByName(this.getObjectColumnName()).setString(this.currentObjectName);
                    }
                    command.execute();
                    if (command.getStatement() != null && (rs = command.getStatement().getResultSet()) != null) {
                        this.tableProps.getQuery().setResultSet(rs);
                    }
                } else {
                    this.tableProps.getQuery().setSqlText(this.getSql(this.filter));
                    if (this.getSchemaColumnName() != null) {
                        this.tableProps.getQuery().paramByName(this.getSchemaColumnName()).setString(this.currentSchemaName);
                    }
                    if (this.getObjectColumnName() != null) {
                        this.tableProps.getQuery().paramByName(this.getObjectColumnName()).setString(this.currentObjectName);
                    }
                    this.tableProps.getQuery().open();
                }
                if (!this.tableProps.getQuery().isEmpty()) {
                    if (propName != null && this.tableProps.getQuery().locate(this.getPropColumnName(), new Variant(propName))) {
                        this.tableProps.changeSelection(this.tableProps.getQuery().getCurrentRecord().getIndex(), column);
                    } else {
                        this.tableProps.changeSelection(Math.min(index, this.tableProps.getRowCount() - 1), column);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (SwingUtil.isVisible((Component)this)) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public String getCurrentObjectName() {
        return this.currentObjectName;
    }

    public String getCurrentPropName() {
        return this.currentPropName;
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public Query getQuery() {
        return this.tableProps.getQuery();
    }

    public AbsOrbadaSyntaxTextArea getTextArea() {
        return this.textProp;
    }

    public void close() throws IOException {
        this.closing = true;
        this.settings.setValue("split-location", Long.valueOf(this.split.getDividerLocation()));
        this.settings.store();
        this.tableProps.getQuery().close();
        this.textProp.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.split = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableProps = new ViewTable();
        this.statusBarProps = new QueryTableStatusBar();
        this.textProp = new OrbadaSyntaxTextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalPropSourceTab.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalPropSourceTab.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                UniversalPropSourceTab.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonFilter);
        this.toolBarTriggers.add(this.jSeparator1);
        this.toolBarTriggers.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
        this.split.setBorder(null);
        this.split.setDividerLocation(350);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableProps);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarProps.setShowFieldType(false);
        this.statusBarProps.setShowOpenTime(false);
        this.statusBarProps.setTable((QueryTable)this.tableProps);
        this.jPanel1.add((Component)this.statusBarProps, "South");
        this.split.setLeftComponent(this.jPanel1);
        this.textProp.setPreferredSize(new Dimension(81, 150));
        this.split.setRightComponent((Component)this.textProp);
        this.add((Component)this.split, "Center");
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show(this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

