/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.tabbed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxDocument;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public abstract class UniversalSourceTab
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    protected IViewAccesibilities accesibilities;
    protected String currentSchemaName = "";
    protected String currentObjectName = "";
    protected boolean requestRefresh = false;
    protected boolean closing = false;
    protected String lastSource;
    protected ISettings settings;
    protected ComponentActionsAction componentActions;
    private SyntaxDocument.LineMark lineMark;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private ToolButton buttonStore;
    private Action cmRefreshSource;
    private Action cmStore;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private OrbadaSyntaxTextArea textProp;
    private JToolBar toolBarContent;
    private JPanel toolBarPanel;

    public UniversalSourceTab(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalSourceTab.this.init();
            }
        });
    }

    protected void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), this.getPanelName() + "-settings");
        this.textProp.setDatabase(this.getDatabase());
        if (this.isToolbar()) {
            SwingUtil.addAction((JComponent)this.textProp.getEditorArea(), (javax.swing.Action)this.cmStore);
            this.componentActions = new ComponentActionsAction(this.getDatabase(), (JComponent)this.textProp.getEditorArea(), (JButton)this.buttonActions, this.menuActions, this.getPanelName() + "-actions");
            this.cmStore.setEnabled(this.isStorable());
            this.buttonStore.setVisible(this.isStorable());
        } else {
            this.toolBarPanel.setVisible(false);
        }
        this.textProp.setEditable(this.isStorable());
        this.lineMark = new SyntaxDocument.LineMark(-1, Color.getColor("activeCaption", new Color(204, 204, 255)), ImageManager.getImage((String)"/pl/mpak/res/icons/line_point.gif"));
    }

    public abstract String getPanelName();

    public abstract void updateBody(AbsOrbadaSyntaxTextArea var1);

    public abstract boolean isStorable();

    public void afterStore() {
    }

    protected boolean isToolbar() {
        return true;
    }

    public String getObjectName() {
        return this.currentObjectName;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void gotoPoint(int line, int column) {
        int offset = this.textProp.getEditorArea().getLineStartOffset(line - 1) + column - 1;
        this.textProp.getEditorArea().setCaretPosition(offset);
        this.textProp.updateCaretPositionList();
        this.textProp.removeLineMark(this.lineMark);
        this.lineMark.setLine(line);
        this.textProp.setLineMark(this.lineMark);
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalSourceTab.this.refresh();
            }
        });
    }

    public void refresh() {
        this.requestRefresh = false;
        this.updateBody((AbsOrbadaSyntaxTextArea)this.textProp);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalSourceTab.this.lastSource = UniversalSourceTab.this.textProp.getText();
            }
        });
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentObjectName = objectName;
            if (SwingUtil.isVisible((Component)this)) {
                this.refresh();
            } else {
                this.requestRefresh = true;
                this.textProp.setDatabaseObject(this.currentSchemaName, "", this.currentObjectName, "");
            }
        }
    }

    public String getCurrentObjectName() {
        return this.currentObjectName;
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public AbsOrbadaSyntaxTextArea getTextArea() {
        return this.textProp;
    }

    public JToolBar getToolBar() {
        return this.toolBarContent;
    }

    public boolean canClose() {
        return this.textProp.canClose();
    }

    public void close() throws IOException {
        this.closing = true;
        this.settings.store();
        this.textProp.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefreshSource = new Action();
        this.menuActions = new JPopupMenu();
        this.cmStore = new Action();
        this.toolBarPanel = new JPanel();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonStore = new ToolButton();
        this.buttonActions = new ToolButton();
        this.textProp = new OrbadaSyntaxTextArea();
        this.cmRefreshSource.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshSource.setText(this.stringManager.getString("cmRefreshSource-text"));
        this.cmRefreshSource.setTooltip(this.stringManager.getString("cmRefreshSource-hint"));
        this.cmRefreshSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalSourceTab.this.cmRefreshSourceActionPerformed(evt);
            }
        });
        this.cmStore.setActionCommandKey("cmStore");
        this.cmStore.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmStore.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/store_db.gif"));
        this.cmStore.setText(this.stringManager.getString("cmStore-text"));
        this.cmStore.setTooltip(this.stringManager.getString("cmStore-hint"));
        this.cmStore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalSourceTab.this.cmStoreActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                UniversalSourceTab.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.toolBarPanel.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefreshSource);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.toolBarContent.add(this.jSeparator1);
        this.buttonStore.setAction((javax.swing.Action)this.cmStore);
        this.buttonStore.setHorizontalTextPosition(0);
        this.buttonStore.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonStore);
        this.toolBarContent.add((Component)this.buttonActions);
        this.toolBarPanel.add(this.toolBarContent);
        this.add((Component)this.toolBarPanel, "North");
        this.add((Component)this.textProp, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    private void cmRefreshSourceActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void cmStoreActionPerformed(ActionEvent evt) {
        this.textProp.getStatusBar().getPanel("ddl-status").setText(this.stringManager.getString("executing-3d"));
        try {
            this.textProp.storeScript();
            this.afterStore();
            this.lastSource = this.textProp.getText();
            this.textProp.getStatusBar().getPanel("ddl-status").setText(this.stringManager.getString("stored"));
            UniversalViewTabs view = (UniversalViewTabs)SwingUtil.getOwnerComponent(UniversalViewTabs.class, (Component)this);
            if (view != null) {
                view.refresh();
            }
        }
        catch (Exception ex) {
            if (this.lastSource != null) {
                try {
                    this.textProp.storeScript(this.lastSource);
                }
                catch (Exception ex2) {
                    ExceptionUtil.processException((Throwable)ex2);
                }
            }
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            this.textProp.getStatusBar().getPanel("ddl-status").setText(this.stringManager.getString("error-e"));
        }
    }
}

