/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.tabbed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectUserData;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.CloseAbilitable;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniversalViewTabs
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    protected IViewAccesibilities accesibilities;
    protected String currentSchemaName;
    protected SqlFilter filter;
    protected String tabTitle;
    protected boolean viewClosing = false;
    protected ISettings settings;
    protected Timer timer;
    protected Component tabbedPane;
    protected boolean refreshing = false;
    protected ComponentActionsAction componentActions;
    private int tabNumber;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPopupMenu menuActions;
    private JPanel panelObjects;
    private JScrollPane scrollDescription;
    private JSplitPane splitObjects;
    private QueryTableStatusBar statusBarObjects;
    private ViewTable tableObjects;
    private JPanel temp;
    private TextArea textDescription;
    private JToolBar toolBar;

    public UniversalViewTabs(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalViewTabs.this.initComponents();
                UniversalViewTabs.this.init();
            }
        });
    }

    private int findTabNumber() {
        Component[] tabs = this.accesibilities.getViewComponentList(this.accesibilities.getViewProvider());
        if (tabs.length > 0) {
            for (int i = 0; i < 100; ++i) {
                boolean found = false;
                for (int t = 0; t < tabs.length; ++t) {
                    UniversalViewTabs tab = (UniversalViewTabs)tabs[t];
                    if (tab.getTabNumber() != i) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return i;
            }
        }
        return 0;
    }

    public int getTabNumber() {
        return this.tabNumber;
    }

    protected void init() {
        this.tabNumber = this.findTabNumber();
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                UniversalViewTabs.this.refreshTabbedPanes();
            }
        };
        OrbadaUniversalPlugin.refreshQueue.add(this.timer);
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), this.getPanelName() + "-settings");
        this.tabbedPane = this.getTabbedPane();
        if (this.tabbedPane != null) {
            this.splitObjects.setRightComponent(this.tabbedPane);
            if (!this.isHorizontal()) {
                this.splitObjects.setOrientation(0);
            }
            this.splitObjects.setDividerLocation(this.settings.getValue("split-location", Long.valueOf(this.splitObjects.getDividerLocation())).intValue());
        } else {
            Component c = this.splitObjects.getLeftComponent();
            this.remove(this.splitObjects);
            this.add(c);
            this.statusBarObjects.setShowFieldValue(true);
        }
        this.currentSchemaName = this.getCurrentSchemaName();
        if (this.getSchemaColumnName() == null) {
            this.cmSelectSchema.setEnabled(false);
            this.buttonSelectSchema.setVisible(false);
        } else if (this.getTabNumber() > 1) {
            this.setCurrentSchemaName(this.settings.getValue("current-schema-" + this.getTabNumber(), (String)null));
        }
        this.tableObjects.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                if (!UniversalViewTabs.this.refreshing) {
                    if (this.lastIndex != UniversalViewTabs.this.tableObjects.getSelectedRow() && UniversalViewTabs.this.tabbedPane instanceof OrbadaTabbedPane) {
                        if (this.lastIndex == -1) {
                            this.lastIndex = UniversalViewTabs.this.tableObjects.getSelectedRow();
                        }
                        if (!((OrbadaTabbedPane)UniversalViewTabs.this.tabbedPane).canClose()) {
                            UniversalViewTabs.this.tableObjects.changeSelection(this.lastIndex, UniversalViewTabs.this.tableObjects.getSelectedColumn());
                            return;
                        }
                    }
                    this.lastIndex = UniversalViewTabs.this.tableObjects.getSelectedRow();
                    UniversalViewTabs.this.timer.restart();
                }
            }
        });
        this.tableObjects.getQuery().setDatabase(this.getDatabase());
        try {
            SqlFilterDefComponent[] fdcs;
            QueryTableColumn[] qtcs;
            if (StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("dict-persistent-query", "false"))) {
                this.tableObjects.getQuery().setCloseResultAfterOpen(true);
            }
            if ((qtcs = this.getTableColumns()) != null) {
                for (QueryTableColumn qtc : qtcs) {
                    this.tableObjects.addColumn((TableColumn)qtc);
                }
            }
            if ((fdcs = this.getFilterDefComponent()) != null) {
                SqlFilterDef def = new SqlFilterDef();
                for (SqlFilterDefComponent fdc : fdcs) {
                    def.add(fdc);
                }
                this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), this.getPanelName() + "-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
            } else {
                this.cmFilter.setEnabled(false);
                this.buttonFilter.setVisible(false);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.scrollDescription.setVisible(this.getDescriptionColumnName() != null);
        this.componentActions = new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableObjects, (JButton)this.buttonActions, this.menuActions, this.getPanelName() + "-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalViewTabs.this.tableObjects.requestFocusInWindow();
            }
        });
    }

    public boolean isHorizontal() {
        return true;
    }

    public abstract Component getTabbedPane();

    public abstract String getCurrentSchemaName();

    public abstract String getPanelName();

    public abstract String getSchemaColumnName();

    public abstract String getObjectColumnName();

    public abstract String getDescriptionColumnName();

    public abstract QueryTableColumn[] getTableColumns();

    public abstract String getSql(SqlFilter var1);

    protected void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
    }

    public abstract SqlFilterDefComponent[] getFilterDefComponent();

    public abstract String[] getSchemaList();

    protected boolean executeSql() {
        return false;
    }

    public boolean canOpen(ParametrizedCommand qc) {
        return true;
    }

    public void afterOpen(Query query) {
    }

    protected HashMap<String, Variant> getUserData() {
        return null;
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!StringUtil.isEmpty((String)schemaName) && !this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(this.getCurrentSchemaName())) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
                this.buttonSelectSchema.setSelected(true);
            } else {
                this.buttonSelectSchema.setSelected(false);
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    protected void refreshTabbedPanes() {
        String objectName = "";
        String schemaName = "";
        int rowIndex = this.tableObjects.getSelectedRow();
        if (rowIndex >= 0) {
            try {
                HashMap<String, Variant> map;
                String dcn;
                this.tableObjects.getQuery().getRecord(rowIndex);
                objectName = this.tableObjects.getQuery().fieldByName(this.getObjectColumnName()).getString();
                if (this.getSchemaColumnName() != null && this.tableObjects.getQuery().findFieldByName(this.getSchemaColumnName()) != null) {
                    schemaName = this.tableObjects.getQuery().fieldByName(this.getSchemaColumnName()).getString();
                }
                if ((dcn = this.getDescriptionColumnName()) != null) {
                    final String description = this.tableObjects.getQuery().fieldByName(dcn).getString();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            UniversalViewTabs.this.textDescription.setText(description);
                        }
                    });
                }
                if (this.tabbedPane instanceof ITabObjectUserData && (map = this.getUserData()) != null) {
                    ((ITabObjectUserData)this.tabbedPane).userData(map);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        } else {
            if (this.tabbedPane instanceof ITabObjectUserData) {
                ((ITabObjectUserData)this.tabbedPane).userData(null);
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    UniversalViewTabs.this.textDescription.setText("");
                }
            });
        }
        if (this.tabbedPane instanceof ITabObjectInfo) {
            ((ITabObjectInfo)this.tabbedPane).refresh(null, StringUtil.isEmpty((String)schemaName) ? this.currentSchemaName : schemaName, objectName);
        }
    }

    protected void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UniversalViewTabs.this.refresh();
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || !SwingUtil.isVisible((Component)this) || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableObjects.getQuery().isActive() && this.tableObjects.getSelectedRow() >= 0) {
                this.tableObjects.getQuery().getRecord(this.tableObjects.getSelectedRow());
                objectName = this.tableObjects.getQuery().fieldByName(this.getObjectColumnName()).getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String objectName) {
        this.refreshing = true;
        try {
            int column = Math.max(0, this.tableObjects.getSelectedColumn());
            int index = Math.max(0, this.tableObjects.getSelectedRow());
            this.tableObjects.getQuery().close();
            if (this.executeSql()) {
                Command command = this.getDatabase().createCommand(this.getSql(this.filter), false);
                if (this.canOpen((ParametrizedCommand)command)) {
                    ResultSet rs;
                    if (this.getSchemaColumnName() != null) {
                        command.paramByName(this.getSchemaColumnName()).setString(this.currentSchemaName);
                    }
                    this.extraSqlParameters((ParametrizedCommand)command);
                    command.execute();
                    if (command.getStatement() != null && (rs = command.getStatement().getResultSet()) != null) {
                        this.tableObjects.getQuery().setResultSet(rs);
                    }
                }
            } else {
                this.tableObjects.getQuery().setSqlText(this.getSql(this.filter));
                if (this.canOpen((ParametrizedCommand)this.tableObjects.getQuery())) {
                    if (this.getSchemaColumnName() != null) {
                        this.tableObjects.getQuery().paramByName(this.getSchemaColumnName()).setString(this.currentSchemaName);
                    }
                    this.extraSqlParameters((ParametrizedCommand)this.tableObjects.getQuery());
                    this.tableObjects.getQuery().open();
                }
            }
            if (!this.tableObjects.getQuery().isEmpty()) {
                if (objectName != null && this.tableObjects.getQuery().locate(this.getObjectColumnName(), new Variant(objectName))) {
                    this.tableObjects.changeSelection(this.tableObjects.getQuery().getCurrentRecord().getIndex(), column);
                } else {
                    this.tableObjects.changeSelection(Math.min(index, this.tableObjects.getRowCount() - 1), column);
                }
            }
            this.afterOpen(this.tableObjects.getQuery());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    public boolean canClose() {
        if (this.tabbedPane instanceof CloseAbilitable) {
            return ((CloseAbilitable)this.tabbedPane).canClose();
        }
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.viewClosing = true;
        if (this.cmSelectSchema.isEnabled()) {
            if (!this.currentSchemaName.equalsIgnoreCase(this.getCurrentSchemaName())) {
                this.settings.setValue("current-schema-" + this.getTabNumber(), this.currentSchemaName);
            } else {
                this.settings.setValue("current-schema-" + this.getTabNumber(), (String)null);
            }
        }
        if (this.tabbedPane != null) {
            this.settings.setValue("split-location", Long.valueOf(this.splitObjects.getDividerLocation()));
            if (this.tabbedPane instanceof Closeable) {
                ((Closeable)((Object)this.tabbedPane)).close();
            }
        }
        this.tableObjects.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public Query getQuery() {
        return this.tableObjects.getQuery();
    }

    public JTable getTable() {
        return this.tableObjects;
    }

    public IViewAccesibilities getAccesibilities() {
        return this.accesibilities;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.cmFilter = new Action();
        this.splitObjects = new JSplitPane();
        this.panelObjects = new JPanel();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonActions = new ToolButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableObjects = new ViewTable();
        this.scrollDescription = new JScrollPane();
        this.textDescription = new TextArea();
        this.jPanel2 = new JPanel();
        this.statusBarObjects = new QueryTableStatusBar();
        this.temp = new JPanel();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalViewTabs.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setActionCommandKey("cmSelectDatabase");
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/request.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalViewTabs.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UniversalViewTabs.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                UniversalViewTabs.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitObjects.setBorder(null);
        this.splitObjects.setDividerLocation(200);
        this.splitObjects.setContinuousLayout(true);
        this.splitObjects.setOneTouchExpandable(true);
        this.panelObjects.setPreferredSize(new Dimension(250, 100));
        this.panelObjects.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBar);
        this.panelObjects.add((Component)this.jPanel1, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableObjects);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.scrollDescription.setPreferredSize(new Dimension(166, 50));
        this.textDescription.setColumns(20);
        this.textDescription.setEditable(false);
        this.textDescription.setLineWrap(true);
        this.textDescription.setRows(5);
        this.textDescription.setFocusable(false);
        this.textDescription.setFont(new Font("Courier New", 0, 11));
        this.scrollDescription.setViewportView((Component)this.textDescription);
        this.jPanel3.add((Component)this.scrollDescription, "South");
        this.panelObjects.add((Component)this.jPanel3, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarObjects.setShowFieldType(false);
        this.statusBarObjects.setShowFieldValue(false);
        this.statusBarObjects.setShowOpenTime(false);
        this.statusBarObjects.setTable((QueryTable)this.tableObjects);
        this.jPanel2.add((Component)this.statusBarObjects, "South");
        this.panelObjects.add((Component)this.jPanel2, "South");
        this.splitObjects.setLeftComponent(this.panelObjects);
        this.splitObjects.setRightComponent(this.temp);
        this.add((Component)this.splitObjects, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableObjects.getQuery().isActive()) {
            this.refreshTableListTask();
        }
    }

    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        ArrayList<String> vl = new ArrayList<String>(Arrays.asList(this.getSchemaList()));
        Point point = this.buttonSelectSchema.getLocationOnScreen();
        point.y += this.buttonSelectSchema.getHeight();
        SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

            public void selected(Object o) {
                UniversalViewTabs.this.setCurrentSchemaName(o.toString());
                UniversalViewTabs.this.refreshTableListTask();
            }
        });
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableListTask();
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show(this.filter)) {
            this.refresh();
        }
    }
}

