/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class TableImportedKeysPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentCatalogName;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean isView;
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JScrollPane jScrollPane1;
    private QueryTableStatusBar statusBarImportedKeys;
    private ViewTable tableImportedKeys;
    private JToolBar toolBarImportedKeys;

    public TableImportedKeysPanel(IViewAccesibilities accesibilities) {
        this(accesibilities, false);
    }

    public TableImportedKeysPanel(IViewAccesibilities accesibilities, boolean isView) {
        this.accesibilities = accesibilities;
        this.isView = isView;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableImportedKeys.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableImportedKeysPanel.this.tableImportedKeys.getSelectedRow();
                if (rowIndex >= 0 && TableImportedKeysPanel.this.tableImportedKeys.getQuery().isActive()) {
                    try {
                        TableImportedKeysPanel.this.tableImportedKeys.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableImportedKeys.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableImportedKeys.addColumn((TableColumn)new QueryTableColumn("FK_NAME", this.stringManager.getString("key-name"), 150));
            this.tableImportedKeys.addColumn((TableColumn)new QueryTableColumn("FKCOLUMN_NAME", this.stringManager.getString("column"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableImportedKeys.addColumn((TableColumn)new QueryTableColumn("PK_NAME", this.stringManager.getString("ref-key-name"), 150));
            this.tableImportedKeys.addColumn((TableColumn)new QueryTableColumn("PKTABLE_SCHEM", this.stringManager.getString("ref-schema"), 150));
            this.tableImportedKeys.addColumn((TableColumn)new QueryTableColumn("PKTABLE_NAME", this.stringManager.getString("ref-table"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableImportedKeys.addColumn((TableColumn)new QueryTableColumn("PKCOLUMN_NAME", this.stringManager.getString("ref-column"), 150));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableImportedKeys.getQuery().close();
            this.tableImportedKeys.getQuery().setResultSet(this.getDatabase().getMetaData().getImportedKeys(this.currentCatalogName, this.currentSchemaName, this.currentTableName));
            if (!this.tableImportedKeys.getQuery().isEmpty()) {
                this.tableImportedKeys.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!StringUtil.equals((String)catalogName, (String)this.currentCatalogName) || !StringUtil.equals((String)schemaName, (String)this.currentSchemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentCatalogName = catalogName;
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableImportedKeys.getQuery().close();
        this.accesibilities = null;
    }

    public String getTitle() {
        return this.stringManager.getString("TableImportedKeysPanel-title");
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableImportedKeys = new ViewTable();
        this.statusBarImportedKeys = new QueryTableStatusBar();
        this.toolBarImportedKeys = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableImportedKeysPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableImportedKeysPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableImportedKeys);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarImportedKeys.setShowFieldType(false);
        this.statusBarImportedKeys.setShowOpenTime(false);
        this.statusBarImportedKeys.setTable((QueryTable)this.tableImportedKeys);
        this.add((Component)this.statusBarImportedKeys, "Last");
        this.toolBarImportedKeys.setFloatable(false);
        this.toolBarImportedKeys.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarImportedKeys.add((Component)this.buttonRefresh);
        this.add((Component)this.toolBarImportedKeys, "North");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refresh();
        }
    }
}

