/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class TableIndexesPanel
extends JPanel
implements ITabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentCatalogName;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JScrollPane jScrollPane1;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableIndexes;
    private JToolBar toolBarIndexes;

    public TableIndexesPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableIndexes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = TableIndexesPanel.this.tableIndexes.getSelectedRow();
                if (rowIndex >= 0 && TableIndexesPanel.this.tableIndexes.getQuery().isActive()) {
                    try {
                        TableIndexesPanel.this.tableIndexes.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableIndexes.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("ORDINAL_POSITION", this.stringManager.getString("pos"), 30));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("INDEX_NAME", this.stringManager.getString("index-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("COLUMN_NAME", this.stringManager.getString("column"), 150));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("ASC_OR_DESC", this.stringManager.getString("asc-desc"), 40));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("NON_UNIQUE", this.stringManager.getString("non-unique"), 40));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableIndexes.getQuery().close();
            this.tableIndexes.getQuery().setResultSet(this.getDatabase().getMetaData().getIndexInfo(this.currentCatalogName, this.currentSchemaName, this.currentTableName, false, false));
            if (!this.tableIndexes.getQuery().isEmpty()) {
                this.tableIndexes.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!StringUtil.equals((String)catalogName, (String)this.currentCatalogName) || !StringUtil.equals((String)schemaName, (String)this.currentSchemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentCatalogName = catalogName;
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.closing = true;
        this.tableIndexes.getQuery().close();
        this.accesibilities = null;
    }

    public String getTitle() {
        return this.stringManager.getString("TableIndexesPanel-title");
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableIndexes = new ViewTable();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableIndexesPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TableIndexesPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableIndexes);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableIndexes);
        this.add((Component)this.statusBarIndexes, "Last");
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.add((Component)this.toolBarIndexes, "First");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

