/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ContentPanel;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.tables.TableColumnsPanel;
import pl.mpak.orbada.universal.gui.tables.TableExportedKeysPanel;
import pl.mpak.orbada.universal.gui.tables.TableImportedKeysPanel;
import pl.mpak.orbada.universal.gui.tables.TableIndexesPanel;
import pl.mpak.orbada.universal.gui.tables.TablePrivilegesPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.Titleable;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class TablesPanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentCatalogName;
    private String currentSchemaName;
    private String tabTitle;
    private boolean viewClosing = false;
    private boolean refreshing = false;
    private Timer timer;
    private boolean catalogPresents;
    private boolean schemaPresents;
    private TableIndexesPanel indexesPanel;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectCatalog;
    private ToolButton buttonSelectSchema;
    private Action cmRefresh;
    private Action cmSelectCatalog;
    private Action cmSelectSchema;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel panelTables;
    private JSplitPane splinPane;
    private QueryTableStatusBar statusBarTables;
    private JTabbedPane tabbedTableInfo;
    private ViewTable tableTables;
    private TextField textSchema;
    private JToolBar toolBarTables;

    public TablesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        try {
            this.catalogPresents = !StringUtil.isEmpty((String)this.getDatabase().getMetaData().getCatalogTerm());
            this.schemaPresents = !StringUtil.isEmpty((String)this.getDatabase().getMetaData().getSchemaTerm());
        }
        catch (SQLException ex) {
            this.catalogPresents = false;
            this.schemaPresents = true;
        }
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TablesPanelView.this.refreshTabbedPanes();
            }
        };
        OrbadaUniversalPlugin.refreshQueue.add(this.timer);
        this.textSchema.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    TablesPanelView.this.setCurrentSchemaName(TablesPanelView.this.textSchema.getText());
                    TablesPanelView.this.refreshTableList();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.currentSchemaName = this.getDatabase().getUserName().toUpperCase();
        try {
            if (!StringUtil.equalAnyOfString((String)this.currentSchemaName, (String[])this.getDatabase().getSchemaArray())) {
                this.currentSchemaName = null;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.currentSchemaName = null;
        }
        this.tableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!TablesPanelView.this.refreshing) {
                    TablesPanelView.this.timer.restart();
                }
            }
        });
        this.addInfoPanel(new TableColumnsPanel(this.accesibilities), -1);
        this.indexesPanel = new TableIndexesPanel(this.accesibilities);
        this.addInfoPanel(this.indexesPanel, -1);
        this.addInfoPanel(new TableImportedKeysPanel(this.accesibilities), -1);
        this.addInfoPanel(new TableExportedKeysPanel(this.accesibilities), -1);
        this.addInfoPanel(new TablePrivilegesPanel(this.accesibilities), -1);
        this.addInfoPanel((JPanel)new ContentPanel(this.accesibilities), -1);
        this.tableTables.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableTables.getQuery().setFlushMode(Query.FlushMode.fmSynch);
        }
        catch (UseDBException useDBException) {
            // empty catch block
        }
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("TABLE_NAME", this.stringManager.getString("table-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("TABLE_TYPE", this.stringManager.getString("table-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("REMARKS", this.stringManager.getString("comment"), 300));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TablesPanelView.this.tableTables.requestFocusInWindow();
            }
        });
    }

    private void setCurrentSchemaName(String schemaName) {
        if (this.schemaPresents && !StringUtil.equals((String)schemaName, (String)this.currentSchemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(this.getDatabase().getUserName())) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentCatalogName + " " + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    private void setCurrentCatalogName(String catalogName) {
        if (this.catalogPresents && !StringUtil.equals((String)catalogName, (String)this.currentCatalogName)) {
            this.currentCatalogName = catalogName;
            this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentCatalogName + " " + this.currentSchemaName + ")");
        }
    }

    private void refreshTabbedPanes() {
        String tableName = "";
        String tableSchema = null;
        String tableCatalog = null;
        int rowIndex = this.tableTables.getSelectedRow();
        if (rowIndex >= 0 && this.tableTables.getQuery().isActive()) {
            try {
                this.tableTables.getQuery().getRecord(rowIndex);
                if (this.tableTables.getQuery().findFieldByName("TABLE_CAT") != null) {
                    tableCatalog = this.tableTables.getQuery().fieldByName("TABLE_CAT").getString();
                } else if (this.tableTables.getQuery().findFieldByName("TABLE_CATALOG") != null) {
                    tableCatalog = this.tableTables.getQuery().fieldByName("TABLE_CATALOG").getString();
                }
                tableName = this.tableTables.getQuery().fieldByName("TABLE_NAME").getString();
                if (this.tableTables.getQuery().findFieldByName("TABLE_SCHEM") != null) {
                    if (!this.tableTables.getQuery().fieldByName("TABLE_SCHEM").isNull()) {
                        tableSchema = this.tableTables.getQuery().fieldByName("TABLE_SCHEM").getString();
                    }
                } else if (this.tableTables.getQuery().findFieldByName("TABLE_SCHEMA") != null && !this.tableTables.getQuery().fieldByName("TABLE_SCHEMA").isNull()) {
                    tableSchema = this.tableTables.getQuery().fieldByName("TABLE_SCHEMA").getString();
                }
                if (this.tableTables.getQuery().fieldByName("TABLE_TYPE").getString().equals("VIEW")) {
                    this.tabbedTableInfo.remove(this.indexesPanel);
                } else if (!this.tabbedTableInfo.getComponentAt(1).equals(this.indexesPanel)) {
                    this.addInfoPanel(this.indexesPanel, 1);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        for (int i = 0; i < this.tabbedTableInfo.getTabCount(); ++i) {
            Component c = this.tabbedTableInfo.getComponentAt(i);
            if (!(c instanceof ITabObjectInfo)) continue;
            ((ITabObjectInfo)c).refresh(tableCatalog, this.currentSchemaName == null ? tableSchema : this.currentSchemaName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTableList() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            this.refreshing = true;
            String tableName = null;
            if (this.tableTables.getQuery().isActive() && this.tableTables.getSelectedRow() >= 0) {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                tableName = this.tableTables.getQuery().fieldByName("TABLE_NAME").getString();
            }
            this.tableTables.getQuery().close();
            this.tableTables.getQuery().setResultSet(this.getDatabase().getMetaData().getTables(this.currentCatalogName, this.currentSchemaName, null, new String[]{"TABLE", "SYSTEM TABLE", "VIEW"}));
            if (tableName != null && this.tableTables.getQuery().locate("TABLE_NAME", new Variant(tableName))) {
                this.tableTables.changeSelection(this.tableTables.getQuery().getCurrentRecord().getIndex(), this.tableTables.getQuery().getCurrentRecord().getIndex());
            } else if (!this.tableTables.getQuery().isEmpty()) {
                this.tableTables.changeSelection(0, 0);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            this.refreshing = false;
            this.refreshTabbedPanes();
        }
    }

    private void addInfoPanel(JPanel panel, int index) {
        String title = "???";
        if (panel instanceof Titleable) {
            title = ((Titleable)panel).getTitle();
        }
        if (index >= 0) {
            this.tabbedTableInfo.insertTab(title, null, panel, null, index);
        } else {
            this.tabbedTableInfo.addTab(title, panel);
            index = this.tabbedTableInfo.indexOfComponent(panel);
        }
        this.tabbedTableInfo.setTabComponentAt(index, (Component)new TabCloseComponent(title));
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.viewClosing = true;
        int i = 0;
        while (i < this.tabbedTableInfo.getTabCount()) {
            Component c = this.tabbedTableInfo.getComponentAt(i);
            if (c instanceof Closeable) {
                try {
                    ((Closeable)((Object)c)).close();
                }
                catch (IOException iOException) {}
            } else {
                ++i;
            }
            this.tabbedTableInfo.remove(c);
        }
        this.tableTables.getQuery().close();
        this.accesibilities = null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmSelectCatalog = new Action();
        this.splinPane = new JSplitPane();
        this.panelTables = new JPanel();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jLabel1 = new JLabel();
        this.buttonSelectCatalog = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.textSchema = new TextField();
        this.jScrollPane1 = new JScrollPane();
        this.tableTables = new ViewTable();
        this.statusBarTables = new QueryTableStatusBar();
        this.tabbedTableInfo = new JTabbedPane();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmSelectCatalog.setActionCommandKey("cmSelectCatalog");
        this.cmSelectCatalog.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/request.gif"));
        this.cmSelectCatalog.setText(this.stringManager.getString("cmSelectCatalog-text"));
        this.cmSelectCatalog.setTooltip(this.stringManager.getString("cmSelectCatalog-hint"));
        this.cmSelectCatalog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablesPanelView.this.cmSelectCatalogActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TablesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splinPane.setBorder(null);
        this.splinPane.setDividerLocation(250);
        this.splinPane.setContinuousLayout(true);
        this.splinPane.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.jLabel1.setText(this.stringManager.getString("schema-dd"));
        this.toolBarTables.add(this.jLabel1);
        this.buttonSelectCatalog.setAction((javax.swing.Action)this.cmSelectCatalog);
        this.buttonSelectCatalog.setHorizontalTextPosition(0);
        this.buttonSelectCatalog.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectCatalog);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.textSchema.setPreferredSize(new Dimension(90, 20));
        this.toolBarTables.add((Component)this.textSchema);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableTables);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableTables);
        this.panelTables.add((Component)this.statusBarTables, "South");
        this.splinPane.setLeftComponent(this.panelTables);
        this.splinPane.setRightComponent(this.tabbedTableInfo);
        this.add((Component)this.splinPane, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableTables.getQuery().isActive()) {
            this.refreshTableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            Vector vl = null;
            if (this.schemaPresents) {
                try {
                    query.setResultSet(this.getDatabase().getMetaData().getSchemas(this.currentCatalogName, null));
                }
                catch (Throwable ex) {
                    query.setResultSet(this.getDatabase().getMetaData().getSchemas());
                }
                vl = QueryUtil.staticData((String)"{table_schem}", (Query)query);
            }
            if (vl != null) {
                Point point = this.buttonSelectSchema.getLocationOnScreen();
                point.y += this.buttonSelectSchema.getHeight();
                SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                    public void selected(Object o) {
                        TablesPanelView.this.setCurrentSchemaName(o.toString().trim());
                        TablesPanelView.this.textSchema.setText(o.toString().trim());
                        TablesPanelView.this.refreshTableList();
                    }
                });
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectCatalogActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            Vector vl = null;
            if (this.catalogPresents) {
                query.setResultSet(this.getDatabase().getMetaData().getCatalogs());
                vl = QueryUtil.staticData((String)"{table_cat}", (Query)query);
            }
            if (vl != null) {
                Point point = this.buttonSelectCatalog.getLocationOnScreen();
                point.y += this.buttonSelectCatalog.getHeight();
                SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentCatalogName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                    public void selected(Object o) {
                        TablesPanelView.this.setCurrentCatalogName(o.toString().trim());
                        TablesPanelView.this.refreshTableList();
                    }
                });
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }
}

