/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbDatabaseInfo;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class TableColumnComboBoxModel
extends DefaultComboBoxModel {
    private Database database;
    private String schemaName;
    private String tableName;
    private JdbcDbDatabaseInfo info;

    public TableColumnComboBoxModel(Database database) {
        this.database = database;
        this.info = new JdbcDbDatabaseInfo(database);
        this.init();
    }

    public TableColumnComboBoxModel(Database database, String schemaName, String tableName) {
        this(database);
        this.change(schemaName, tableName);
    }

    public void change(String schemaName, String tableName) {
        this.tableName = tableName;
        this.schemaName = schemaName == null ? this.database.getUserName().toUpperCase() : schemaName;
        try {
            if (!StringUtil.equalAnyOfString((String)this.schemaName, (String[])this.database.getSchemaArray())) {
                this.schemaName = null;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.schemaName = null;
        }
        this.removeAllElements();
        DbObjectIdentified list = this.schemaName == null ? this.info.getObjectInfo("/TABLES/" + tableName + "/COLUMNS") : this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/TABLES/" + tableName + "/COLUMNS");
        if (list instanceof DbObjectContainer) {
            for (DbObjectIdentified i : ((DbObjectContainer)list).objectsArray(true)) {
                this.addElement(i);
            }
        }
    }

    public void select(String columnName, JComboBox combo) {
        if (columnName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(columnName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

