/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbDatabaseInfo;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class TableComboBoxModel
extends DefaultComboBoxModel {
    private Database database;
    private String schemaName;
    private JdbcDbDatabaseInfo info;

    public TableComboBoxModel(Database database) {
        this.database = database;
        this.info = new JdbcDbDatabaseInfo(database);
        this.init();
    }

    public TableComboBoxModel(Database database, String schemaName) {
        this(database);
        this.change(schemaName);
    }

    private void init() {
    }

    public void change(String schemaName) {
        this.schemaName = schemaName == null ? this.database.getUserName().toUpperCase() : schemaName;
        try {
            if (!StringUtil.equalAnyOfString((String)this.schemaName, (String[])this.database.getSchemaArray())) {
                this.schemaName = null;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.schemaName = null;
        }
        this.removeAllElements();
        DbObjectIdentified list = this.schemaName == null ? this.info.getObjectInfo("/TABLES") : this.info.getObjectInfo("/SCHEMAS/" + this.schemaName + "/TABLES");
        if (list instanceof DbObjectContainer) {
            for (DbObjectIdentified i : ((DbObjectContainer)list).objectsArray(true)) {
                this.addElement(i);
            }
        }
    }

    public void select(String tableName, JComboBox combo) {
        if (tableName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(tableName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }
}

