/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.wizards;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableInfo;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.util.TableColumnComboBoxModel;
import pl.mpak.orbada.universal.gui.util.TableComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class AlterTableNullWizardPanel
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private String columnName;
    private String modifyClause;
    private String beforeNull;
    private JCheckBox checkNotNull;
    private JComboBox comboColumns;
    private JComboBox comboTables;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public AlterTableNullWizardPanel(Database database, String schemaName, String tableName, String columnName, String modifyClause) {
        this(database, schemaName, tableName, columnName, modifyClause, null);
    }

    public AlterTableNullWizardPanel(Database database, String schemaName, String tableName, String columnName, String modifyClause, String beforeNull) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.modifyClause = modifyClause;
        this.beforeNull = beforeNull;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboColumns.setModel(new TableColumnComboBoxModel(this.database));
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboTables.addItemListener(new ItemListener(){
            JdbcDbTableInfo lastTable;

            public void itemStateChanged(ItemEvent e) {
                JdbcDbTableInfo ti;
                if (e.getStateChange() == 1 && e.getItem() != null && e.getItem() instanceof JdbcDbTableInfo && (!(ti = (JdbcDbTableInfo)e.getItem()).equals((Object)this.lastTable) || this.lastTable == null)) {
                    ((TableColumnComboBoxModel)AlterTableNullWizardPanel.this.comboColumns.getModel()).change(ti.getSchema().getName(), ti.getName());
                    this.lastTable = ti;
                }
            }
        });
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
        ((TableColumnComboBoxModel)this.comboColumns.getModel()).select(this.columnName, this.comboColumns);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("AlterTableNullWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("AlterTableNullWizardPanel-tab-title");
    }

    public String getSqlCode() {
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + " " + this.modifyClause + " " + SQLUtil.createSqlName((String)this.comboColumns.getSelectedItem().toString()) + (this.beforeNull == null ? "" : " " + this.beforeNull) + (this.checkNotNull.isSelected() ? " NOT NULL" : " NULL");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboColumns = new JComboBox();
        this.checkNotNull = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("column-dd"));
        this.checkNotNull.setSelected(true);
        this.checkNotNull.setText(this.stringManager.getString("not-null"));
        this.checkNotNull.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkNotNull.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 196, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkNotNull).addComponent(this.comboColumns, 0, 196, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboColumns, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNotNull).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

