/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.util.TableComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateConstraintCheckWizardPanel
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private JComboBox comboTables;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private OrbadaSyntaxTextArea textCheck;
    private TextField textName;

    public CreateConstraintCheckWizardPanel(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.textCheck.setDatabase(this.database);
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateConstraintCheckWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateConstraintCheckWizardPanel-tab-title");
    }

    public String getSqlCode() {
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + " ADD CONSTRAINT " + this.textName.getText() + " CHECK (" + this.textCheck.getText() + ")";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel1 = new JLabel();
        this.textCheck = new OrbadaSyntaxTextArea();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel1.setText(this.stringManager.getString("description-dd-check"));
        this.textCheck.setMinimumSize(new Dimension(81, 80));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("constraint-name-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textCheck, -1, 358, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -2, 131, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboTables, 0, 223, Short.MAX_VALUE).addComponent((Component)this.textName, -1, 223, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textCheck, -1, 116, Short.MAX_VALUE).addContainerGap()));
    }
}

