/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableInfo;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.util.TableColumnComboBoxModel;
import pl.mpak.orbada.universal.gui.util.TableComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateConstraintForeignKeyWizardPanel
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private String columnName;
    private ComboBox comboColumnForeignKey;
    private ComboBox comboColumnReference;
    private JButton buttonAddRow;
    private JButton buttonRemoveRow;
    private Action cmAddRow;
    private Action cmRemoveRow;
    private JComboBox comboOnDelete;
    private JComboBox comboOnUpdate;
    private JComboBox comboTablesConstraints;
    private JComboBox comboTablesReferences;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private Table tableColumns;
    private TextField textName;

    public CreateConstraintForeignKeyWizardPanel(Database database, String schemaName, String tableName) {
        this(database, schemaName, tableName, null);
    }

    public CreateConstraintForeignKeyWizardPanel(Database database, String schemaName, String tableName, String columnName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.setModel((TableModel)new DefaultTableModel(new Object[][]{{this.columnName, null}}, new String[]{this.stringManager.getString("foreign-key-columns"), this.stringManager.getString("reference-columns")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableColumns.setRowHeight(20);
        this.comboColumnForeignKey = new ComboBox((ComboBoxModel)new TableColumnComboBoxModel(this.database));
        this.comboColumnReference = new ComboBox((ComboBoxModel)new TableColumnComboBoxModel(this.database));
        TableColumn tc = this.tableColumns.getColumnModel().getColumn(0);
        tc.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.comboColumnForeignKey));
        tc = this.tableColumns.getColumnModel().getColumn(1);
        tc.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.comboColumnReference));
        this.comboTablesConstraints.addItemListener(new ItemListener(){
            JdbcDbTableInfo lastTable;

            public void itemStateChanged(ItemEvent e) {
                JdbcDbTableInfo ti;
                if (e.getStateChange() == 1 && e.getItem() != null && e.getItem() instanceof JdbcDbTableInfo && (!(ti = (JdbcDbTableInfo)e.getItem()).equals((Object)this.lastTable) || this.lastTable == null)) {
                    JdbcDbSchemaInfo schema = ti.getSchema();
                    ((TableColumnComboBoxModel)CreateConstraintForeignKeyWizardPanel.this.comboColumnForeignKey.getModel()).change(schema == null ? null : schema.getName(), ti.getName());
                    this.lastTable = ti;
                }
            }
        });
        this.comboTablesReferences.addItemListener(new ItemListener(){
            JdbcDbTableInfo lastTable;

            public void itemStateChanged(ItemEvent e) {
                JdbcDbTableInfo ti;
                if (e.getStateChange() == 1 && e.getItem() != null && e.getItem() instanceof JdbcDbTableInfo && (!(ti = (JdbcDbTableInfo)e.getItem()).equals((Object)this.lastTable) || this.lastTable == null)) {
                    JdbcDbSchemaInfo schema = ti.getSchema();
                    ((TableColumnComboBoxModel)CreateConstraintForeignKeyWizardPanel.this.comboColumnReference.getModel()).change(schema == null ? null : schema.getName(), ti.getName());
                    this.lastTable = ti;
                }
            }
        });
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTablesConstraints.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTablesReferences.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTablesConstraints.getModel()).select(this.tableName, this.comboTablesConstraints);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateConstraintForeignKeyWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateConstraintForeignKeyWizardPanel-tab-title");
    }

    public String getSqlCode() {
        String fkColumns = "";
        for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
            Object column = this.tableColumns.getValueAt(i, 0);
            if (column == null) continue;
            if (!StringUtil.isEmpty((String)fkColumns)) {
                fkColumns = fkColumns + ", ";
            }
            fkColumns = fkColumns + SQLUtil.createSqlName((String)column.toString());
        }
        String refColumns = "";
        for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
            Object column = this.tableColumns.getValueAt(i, 1);
            if (column == null) continue;
            if (!StringUtil.isEmpty((String)refColumns)) {
                refColumns = refColumns + ", ";
            }
            refColumns = refColumns + SQLUtil.createSqlName((String)column.toString());
        }
        String onDelete = "NO ACTION".equals(this.comboOnDelete.getSelectedItem().toString()) ? "" : "\n  ON DELETE " + this.comboOnDelete.getSelectedItem().toString();
        String onUpdate = "NO ACTION".equals(this.comboOnUpdate.getSelectedItem().toString()) ? "" : "\n  ON UPDATE " + this.comboOnUpdate.getSelectedItem().toString();
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTablesConstraints.getSelectedItem().toString()) + "\n" + "  ADD CONSTRAINT " + this.textName.getText() + "\n" + "  FOREIGN KEY (" + fkColumns + ")\n" + "  REFERENCES " + SQLUtil.createSqlName((String)this.comboTablesReferences.getSelectedItem().toString()) + " (" + refColumns + ")" + onDelete + onUpdate;
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.jLabel2 = new JLabel();
        this.comboTablesConstraints = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.comboTablesReferences = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new Table();
        this.jLabel6 = new JLabel();
        this.comboOnDelete = new JComboBox();
        this.jLabel7 = new JLabel();
        this.comboOnUpdate = new JComboBox();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add8.gif"));
        this.cmAddRow.setText(this.stringManager.getString("cmAddRow-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateConstraintForeignKeyWizardPanel.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/remove8.gif"));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemoveRow-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateConstraintForeignKeyWizardPanel.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("constraint-table-dd"));
        this.comboTablesConstraints.setModel(new TableComboBoxModel(this.database));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("constraint-name-dd"));
        this.comboTablesReferences.setModel(new TableComboBoxModel(this.database));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("reference-table-dd"));
        this.jLabel1.setText(this.stringManager.getString("foreign-key-column-dd"));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("delete-rule-dd"));
        this.comboOnDelete.setModel(new DefaultComboBoxModel<String>(new String[]{"NO ACTION", "CASCADE", "SET NULL", "RESTRICT"}));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("update-rule-dd"));
        this.comboOnUpdate.setModel(new DefaultComboBoxModel<String>(new String[]{"NO ACTION", "CASCADE", "SET NULL", "RESTRICT"}));
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonRemoveRow, -1, -1, Short.MAX_VALUE).addComponent(this.buttonAddRow, -1, 60, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboTablesConstraints, GroupLayout.Alignment.TRAILING, 0, 324, Short.MAX_VALUE).addComponent(this.comboTablesReferences, GroupLayout.Alignment.TRAILING, 0, 324, Short.MAX_VALUE).addComponent((Component)this.textName, -1, 324, Short.MAX_VALUE))).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboOnDelete, GroupLayout.Alignment.TRAILING, 0, 324, Short.MAX_VALUE).addComponent(this.comboOnUpdate, GroupLayout.Alignment.TRAILING, 0, 324, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTablesConstraints, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboTablesReferences, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow)).addComponent(this.jScrollPane1, -1, 110, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboOnDelete, -2, 22, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.comboOnUpdate, -2, 22, -2)).addContainerGap()));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getRowCount() > 1) {
            this.tableColumns.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
            this.tableColumns.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
            ((DefaultTableModel)this.tableColumns.getModel()).removeRow(this.tableColumns.getRowCount() - 1);
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 0) != null && this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 1) != null) {
            ((DefaultTableModel)this.tableColumns.getModel()).addRow(new Object[]{null, null});
        }
    }
}

