/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.wizards;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableInfo;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.util.TableColumnComboBoxModel;
import pl.mpak.orbada.universal.gui.util.TableComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateIndexWizardPanel
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private Database database;
    private String schemaName;
    private String tableName;
    private JCheckBox checkUnique;
    private JComboBox comboColumns;
    private JComboBox comboTables;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textIndexName;

    public CreateIndexWizardPanel(Database database, String schemaName, String tableName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboColumns.setModel(new TableColumnComboBoxModel(this.database));
        this.comboTables.setModel(new TableComboBoxModel(this.database));
        this.comboTables.addItemListener(new ItemListener(){
            JdbcDbTableInfo lastTable;

            public void itemStateChanged(ItemEvent e) {
                JdbcDbTableInfo ti;
                if (e.getStateChange() == 1 && e.getItem() != null && e.getItem() instanceof JdbcDbTableInfo && (!(ti = (JdbcDbTableInfo)e.getItem()).equals((Object)this.lastTable) || this.lastTable == null)) {
                    JdbcDbSchemaInfo schema = ti.getSchema();
                    ((TableColumnComboBoxModel)CreateIndexWizardPanel.this.comboColumns.getModel()).change(schema == null ? null : schema.getName(), ti.getName());
                    this.lastTable = ti;
                }
            }
        });
    }

    public void wizardShow() {
        ((TableComboBoxModel)this.comboTables.getModel()).change(this.schemaName);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateIndexWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateIndexWizardPanel-tab-title");
    }

    public String getSqlCode() {
        return "CREATE" + (this.checkUnique.isSelected() ? " UNIQUE" : "") + " INDEX " + this.textIndexName.getText() + " ON " + SQLUtil.createSqlName((String)this.schemaName, (String)this.comboTables.getSelectedItem().toString()) + "(" + StringUtil.nvl((String)((JTextField)this.comboColumns.getEditor().getEditorComponent()).getText(), (String)"").toString() + ")";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textIndexName = new TextField();
        this.checkUnique = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboColumns = new JComboBox();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("name-dd"));
        this.checkUnique.setText(this.stringManager.getString("unique"));
        this.checkUnique.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkUnique.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("expression-dd"));
        this.comboColumns.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 246, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkUnique).addGap(74, 74, 74)).addComponent((Component)this.textIndexName, -1, 246, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboColumns, 0, 246, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textIndexName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUnique).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboColumns, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

