/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.gui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPool;
import pl.mpak.util.variant.Variant;

public class SqlCodeWizardDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    private int modalResult = 0;
    private SqlCodeWizardPanel wizardPanel;
    private boolean execute;
    private boolean initialized = false;
    private boolean editableSql;
    private WizardResult result = new WizardResult();
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonOk;
    private ToolButton buttonScriptInfo;
    private JCheckBox checkBackground;
    private JCheckBox checkClipoard;
    private Action cmCancel;
    private Action cmOk;
    private Action cmScriptInfo;
    private JPanel panelSqlCode;
    private JTabbedPane tabbedWizard;
    private OrbadaSyntaxTextArea textSqlCode;

    public SqlCodeWizardDialog(SqlCodeWizardPanel wizardPanel, boolean execute, boolean editableSql) {
        super(SwingUtil.getRootFrame());
        this.wizardPanel = wizardPanel;
        this.execute = execute;
        this.editableSql = editableSql;
        this.wizardPanel.setResultMap(this.result.resultMap);
        this.initComponents();
        this.init();
    }

    public static WizardResult show(SqlCodeWizardPanel wizardPanel, boolean execute) {
        return SqlCodeWizardDialog.show(wizardPanel, execute, false);
    }

    public static WizardResult show(final SqlCodeWizardPanel wizardPanel, final boolean execute, final boolean editableSql) {
        WizardResult result = (WizardResult)SwingUtil.invokeAndWait((Callable)new Callable<WizardResult>(){

            @Override
            public WizardResult call() throws Exception {
                SqlCodeWizardDialog dialog = new SqlCodeWizardDialog(wizardPanel, execute, editableSql);
                dialog.setVisible(true);
                if (dialog.modalResult == 1) {
                    dialog.result.sqlCode = wizardPanel.getSqlCode();
                    return dialog.result;
                }
                return null;
            }
        });
        return result;
    }

    private void init() {
        this.settings = Application.get().getSettings("wizard-" + this.wizardPanel.getClass().getCanonicalName());
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.setTitle(this.wizardPanel.getDialogTitle());
        this.tabbedWizard.insertTab(this.wizardPanel.getTabTitle(), null, this.wizardPanel, null, 0);
        this.tabbedWizard.setSelectedIndex(0);
        this.checkBackground.setVisible(this.execute);
        this.textSqlCode.setEditable(this.editableSql);
        int height = SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        this.buttonScriptInfo.setPreferredSize(new Dimension(height, height));
        this.pack();
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        try {
            this.wizardPanel.close();
        }
        catch (IOException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        super.dispose();
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmOk = new Action();
        this.cmScriptInfo = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.tabbedWizard = new JTabbedPane();
        this.panelSqlCode = new JPanel();
        this.textSqlCode = new OrbadaSyntaxTextArea();
        this.checkClipoard = new JCheckBox();
        this.checkBackground = new JCheckBox();
        this.buttonScriptInfo = new ToolButton();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlCodeWizardDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlCodeWizardDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmScriptInfo.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/help.gif"));
        this.cmScriptInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlCodeWizardDialog.this.cmScriptInfoActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle("Title");
        this.setModal(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SqlCodeWizardDialog.this.formComponentShown(evt);
            }
        });
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.tabbedWizard.setFocusable(false);
        this.panelSqlCode.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SqlCodeWizardDialog.this.panelSqlCodeComponentShown(evt);
            }
        });
        this.textSqlCode.setEditable(false);
        GroupLayout panelSqlCodeLayout = new GroupLayout(this.panelSqlCode);
        this.panelSqlCode.setLayout(panelSqlCodeLayout);
        panelSqlCodeLayout.setHorizontalGroup(panelSqlCodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSqlCodeLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.textSqlCode, -1, 542, Short.MAX_VALUE).addContainerGap()));
        panelSqlCodeLayout.setVerticalGroup(panelSqlCodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSqlCodeLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.textSqlCode, -1, 269, Short.MAX_VALUE).addContainerGap()));
        this.tabbedWizard.addTab(this.stringManager.getString("sql"), this.panelSqlCode);
        this.checkClipoard.setText(this.stringManager.getString("copy-toclipboard"));
        this.checkBackground.setText(this.stringManager.getString("background-execute"));
        this.buttonScriptInfo.setAction((javax.swing.Action)this.cmScriptInfo);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.checkClipoard).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBackground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 133, Short.MAX_VALUE).addComponent((Component)this.buttonScriptInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.tabbedWizard, -1, 567, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedWizard, -1, 316, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.checkClipoard).addComponent(this.checkBackground).addComponent((Component)this.buttonScriptInfo, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void panelSqlCodeComponentShown(ComponentEvent evt) {
        try {
            if (!this.initialized) {
                this.wizardPanel.wizardShow();
                this.initialized = true;
            }
            this.textSqlCode.setText(this.wizardPanel.getSqlCode());
            this.textSqlCode.setChanged(false);
            this.textSqlCode.getEditorArea().setCaretPosition(0);
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        String sqlCode = this.wizardPanel.getSqlCode();
        this.result.getResultMap().put("sql-code", sqlCode);
        if (this.checkClipoard.isSelected()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(sqlCode);
            clipboard.setContents(data, data);
            this.result.getResultMap().put("object-to-clipboard", "true");
        } else if (this.execute) {
            if (this.checkBackground.isSelected()) {
                TaskPool.getTaskPool((String)"sql-code-wizard-execute").addTask(new Task(this.stringManager.getString("executing-3d") + " " + sqlCode.substring(0, Math.min(50, sqlCode.length()))){

                    public void run() {
                        SqlCodeWizardDialog.this.wizardPanel.execute();
                    }
                });
            } else if (!this.wizardPanel.execute()) {
                return;
            }
            this.result.getResultMap().put("object-to-clipboard", "false");
        }
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.initialized) {
            this.wizardPanel.wizardShow();
            this.initialized = true;
        }
    }

    private void cmScriptInfoActionPerformed(ActionEvent evt) {
        MessageBox.show((String)this.stringManager.getString("wizard-script-info"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WizardResult {
        private HashMap<String, String> resultMap = new HashMap();
        private String sqlCode;

        public Map<String, String> getResultMap() {
            return this.resultMap;
        }

        public String getSqlCode() {
            return this.sqlCode;
        }
    }
}

