/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.universal.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.orbada.universal.OrbadaUniversalPlugin;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StreamUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalDatabaseProvider
extends DatabaseProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaUniversalPlugin.class);
    public static UniversalDatabaseProvider instance;

    public UniversalDatabaseProvider() {
        instance = this;
    }

    public String getFilePath() {
        return this.application.getConfigPath() + "/universal";
    }

    public String getScriptFile(Database database, boolean connect) {
        return this.getFilePath() + "/" + database.getUserProperties().getProperty("schemaId") + "-" + (connect ? "connect" : "disconnect") + ".sql";
    }

    private void runScript(Database database, String scriptText) {
        try {
            database.executeScript(scriptText);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public String readScript(Database database, boolean connect) {
        String fileName = this.getScriptFile(database, connect);
        String script = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                script = StreamUtil.stream2String((InputStream)new FileInputStream(fileName));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return script;
    }

    public boolean isForDatabase(Database database) {
        return database != null;
    }

    public void afterConnection(Database database) {
        String script = this.readScript(database, true);
        if (script != null) {
            this.runScript(database, script);
        }
    }

    public void beforeDisconnect(Database database) {
        String script = this.readScript(database, false);
        if (script != null) {
            this.runScript(database, script);
        }
    }

    public String getDescription() {
        return this.stringManager.getString("UniversalDatabaseProvider-description");
    }

    public String getGroupName() {
        return OrbadaUniversalPlugin.universalGroupName;
    }
}

