/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BaseTableHeaderUI
extends BasicTableHeaderUI {
    protected MouseAdapter myMouseAdapter = null;
    protected MouseMotionAdapter myMouseMotionAdapter = null;
    protected int rolloverCol = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseTableHeaderUI();
    }

    public void installListeners() {
        super.installListeners();
        this.myMouseAdapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    return;
                }
                if (BaseTableHeaderUI.this.header.getBounds().contains(mouseEvent.getPoint())) {
                    BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                    BaseTableHeaderUI.this.header.repaint();
                } else {
                    BaseTableHeaderUI.this.rolloverCol = -1;
                    BaseTableHeaderUI.this.header.repaint();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (!BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    return;
                }
                BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                BaseTableHeaderUI.this.header.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (!BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    return;
                }
                BaseTableHeaderUI.this.rolloverCol = -1;
                BaseTableHeaderUI.this.header.repaint();
            }
        };
        this.myMouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (!BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    return;
                }
                if (BaseTableHeaderUI.this.header.getDraggedColumn() == null) {
                    BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                    BaseTableHeaderUI.this.header.repaint();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    return;
                }
                if (BaseTableHeaderUI.this.header.getDraggedColumn() != null) {
                    try {
                        BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndex(BaseTableHeaderUI.this.header.getDraggedColumn().getIdentifier());
                    }
                    catch (Exception exception) {}
                } else if (BaseTableHeaderUI.this.header.getResizingColumn() != null) {
                    BaseTableHeaderUI.this.rolloverCol = -1;
                }
            }
        };
        this.header.addMouseListener(this.myMouseAdapter);
        this.header.addMouseMotionListener(this.myMouseMotionAdapter);
    }

    public void uninstallListeners() {
        this.header.removeMouseListener(this.myMouseAdapter);
        this.header.removeMouseMotionListener(this.myMouseMotionAdapter);
        super.uninstallListeners();
    }

    private int getHeaderHeight() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (tableColumn.getHeaderRenderer() == null && bl) continue;
            Component component = this.getHeaderRenderer(i);
            int n2 = component.getPreferredSize().height;
            n = Math.max(n, n2);
            if (n2 <= 0) continue;
            bl = true;
        }
        return n + 2;
    }

    private Dimension createHeaderSize(long l) {
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(bl ? n2 : n3);
        if (bl) {
            for (n = n2; n <= n3; ++n) {
                int n4;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle2.width = n4 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n4;
            }
        } else {
            for (n = n3; n >= n2; --n) {
                int n5;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                rectangle2.width = n5 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n5;
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n);
        }
        this.rendererPane.removeAll();
    }

    protected Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        this.paintBackground(graphics, rectangle, n);
        if (this.rolloverCol == n) {
            int n2 = ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getRolloverColor());
            if (n2 > 128) {
                component.setForeground(Color.black);
            } else {
                component.setForeground(Color.white);
            }
        }
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (n == this.rolloverCol && component.isEnabled()) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n2, n3, n4, n5);
        } else if (JTattooUtilities.isFrameActive(this.header)) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getColHeaderColors(), n2, n3, n4, n5);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getInActiveColors(), n2, n3, n4, n5);
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }
}

