/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;

public class McWinComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new McWinComboBoxUI();
    }

    public JButton createArrowButton() {
        ArrowButton arrowButton = new ArrowButton();
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, McWinLookAndFeel.getFrameColor());
            arrowButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, McWinLookAndFeel.getFrameColor());
            arrowButton.setBorder(matteBorder);
        }
        return arrowButton;
    }

    static class ArrowButton
    extends NoFocusButton {
        ArrowButton() {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.isEnabled()) {
                if (this.getModel().isArmed() && this.getModel().isPressed()) {
                    JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getPressedColors(), 0, 0, dimension.width, dimension.height);
                } else if (this.getModel().isRollover()) {
                    JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), 0, 0, dimension.width, dimension.height);
                } else if (JTattooUtilities.isActive(this)) {
                    JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getDefaultColors(), 0, 0, dimension.width, dimension.height);
                } else {
                    JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getInActiveColors(), 0, 0, dimension.width, dimension.height);
                }
            } else {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getDisabledColors(), 0, 0, dimension.width, dimension.height);
            }
            Icon icon = BaseIcons.getComboBoxIcon();
            int n = (dimension.width - icon.getIconWidth()) / 2;
            int n2 = (dimension.height - icon.getIconHeight()) / 2;
            if (this.getModel().isPressed() && this.getModel().isArmed()) {
                icon.paintIcon(this, graphics, n + 2, n2 + 1);
            } else {
                icon.paintIcon(this, graphics, n + 1, n2);
            }
            this.paintBorder(graphics);
        }
    }
}

