/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.plaf.ColorUIResource;

public class McWinUtils {
    private McWinUtils() {
    }

    public static void fillComponent(Graphics graphics, Component component, Color[] colorArray) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
        if (AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            Point point = JTattooUtilities.getRelLocation(component);
            ColorUIResource colorUIResource = McWinLookAndFeel.getTheme().getBackgroundColorDark();
            Color color = ColorHelper.brighter(ColorHelper.median(colorUIResource, colorArray[colorArray.length - 1]), 50.0);
            for (int i = 2 - point.y % 3; i < n2; i += 3) {
                graphics.setColor(color);
                graphics.drawLine(0, i, n, i);
                color = ColorHelper.darker(color, 1.5);
            }
        }
    }

    public static void fillComponent(Graphics graphics, Component component) {
        if (AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            int n = component.getWidth();
            int n2 = component.getHeight();
            Point point = JTattooUtilities.getRelLocation(component);
            graphics.setColor(McWinLookAndFeel.getTheme().getBackgroundColorLight());
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(McWinLookAndFeel.getTheme().getBackgroundColorDark());
            for (int i = 2 - point.y % 3; i < n2; i += 3) {
                graphics.drawLine(0, i, n, i);
            }
        } else {
            graphics.setColor(AbstractLookAndFeel.getBackgroundColor());
            graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
        }
    }
}

