/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlmacro.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.patt.Resolvers;
import pl.mpak.util.variant.Variant;

public class SqlMacroRecord
extends DefaultBufferedRecord {
    private Pattern pattern;

    public SqlMacroRecord(Database database) {
        super(database, "OSQLMACROS", "OSM_ID");
        this.add("OSM_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("OSM_USR_ID", 11, true);
        this.add("OSM_NAME", 11, true);
        this.add("OSM_REGEXP", 11, true);
        this.add("OSM_RESOLVE", 11, true);
        this.add("OSM_ORDER", 6, true);
        this.add("OSM_DTP_ID", 11, true);
    }

    public SqlMacroRecord(Database database, String osm_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(osm_id));
    }

    public String getId() {
        return this.fieldByName("OSM_ID").getValue().toString();
    }

    public void setId(String id) {
        this.fieldByName("OSM_ID").setString(id);
    }

    public String getUsrId() {
        if (this.fieldByName("OSM_USR_ID").isNull()) {
            return null;
        }
        return this.fieldByName("OSM_USR_ID").getValue().toString();
    }

    public void setUsrId(String id) {
        this.fieldByName("OSM_USR_ID").setString(id);
    }

    public String getName() {
        return this.fieldByName("OSM_NAME").getValue().toString();
    }

    public void setName(String name) {
        this.fieldByName("OSM_NAME").setString(name);
    }

    public String getRegexp() {
        return this.fieldByName("OSM_REGEXP").getValue().toString();
    }

    public void setRegexp(String regexp) {
        this.fieldByName("OSM_REGEXP").setString(regexp);
    }

    public String getResolve() {
        return this.fieldByName("OSM_RESOLVE").getValue().toString();
    }

    public void setResolve(String resolve) {
        this.fieldByName("OSM_RESOLVE").setString(resolve);
    }

    public Long getOrder() {
        if (this.fieldByName("OSM_ORDER").isNull()) {
            return null;
        }
        try {
            return this.fieldByName("OSM_ORDER").getLong();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setOrder(Long order) {
        this.fieldByName("OSM_ORDER").setLong(order.longValue());
    }

    public String getDtpId() {
        if (this.fieldByName("OSM_DTP_ID").isNull()) {
            return null;
        }
        return this.fieldByName("OSM_DTP_ID").getValue().toString();
    }

    public void setDtpId(String id) {
        this.fieldByName("OSM_DTP_ID").setString(id);
    }

    public String resolve(String sqlText) {
        try {
            Matcher mat;
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.getRegexp(), 42);
            }
            if ((mat = this.pattern.matcher(sqlText)).matches()) {
                String toResolve = Resolvers.expand((String)this.getResolve());
                return mat.replaceAll(toResolve);
            }
        }
        catch (PatternSyntaxException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        return null;
    }
}

